/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.Decoration;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.tencent.code.intel.apibridge.Decoration.bean.DecorationOptions;
import com.tencent.code.intel.apibridge.Decoration.bean.DecorationRenderOptions;
import com.tencent.code.intel.apibridge.Decoration.bean.Range;
import com.tencent.code.intel.apibridge.Decoration.processor.TextAttributesProcessor;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.inlay.CopilotInlayRender;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.CopilotEditorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.util.TextUtils;

public final class DecorationService {
    public Map<String, List<Inlay<?>>> inlaysMap = new HashMap();
    private Map<String, List<RangeHighlighter>> rangeHighlighterMap = new HashMap<String, List<RangeHighlighter>>();
    private static Map<String, DecorationRenderOptions> decorationRenderOptionsMap = new HashMap<String, DecorationRenderOptions>();

    public static DecorationService getInstance(Project project) {
        return (DecorationService)project.getService(DecorationService.class);
    }

    public synchronized void registerTextEditorDecorationType(String decorationType, DecorationRenderOptions renderOptions) {
        try {
            if (decorationType == null || decorationType.isEmpty()) {
                return;
            }
            decorationRenderOptionsMap.put(decorationType, renderOptions);
        }
        catch (Exception e) {
            LogManager.warn(DecorationService.class, "registerTextEditorDecorationType:" + e.toString());
        }
    }

    public synchronized void showDecorations(Editor editor, String decorationType, List<DecorationOptions> decorations) {
        try {
            if (CollectionUtils.isEmpty(decorations)) {
                this.dispose(decorationType);
            }
            for (DecorationOptions decoration : decorations) {
                this.markup(editor, decorationType, decoration.getRange());
                this.addInlays(editor, decorationType, decoration);
            }
        }
        catch (Exception e) {
            LogManager.warn(DecorationService.class, "show decorations:" + e.toString());
        }
    }

    public synchronized void showDecorationsFast(Editor editor, String decorationType, List<Range> ranges) {
        try {
            if (CollectionUtils.isEmpty(ranges)) {
                this.dispose(decorationType);
                return;
            }
            for (Range range : ranges) {
                this.markup(editor, decorationType, range);
            }
        }
        catch (Exception e) {
            LogManager.warn(DecorationService.class, "showDecorationsFast:" + e.toString());
        }
    }

    private void addInlays(Editor editor, String decorationType, DecorationOptions decoration) {
        try {
            String text;
            if (editor.getSelectionModel().hasSelection()) {
                return;
            }
            Range range = decoration.getRange();
            int lineNumber = range.getStartLineNumber() - 1;
            int column = range.getStartColumn() - 1;
            int startLineStartOffset = CopilotEditorUtils.getLineStartOffsetByLine(editor, lineNumber);
            int startLineEndOffset = CopilotEditorUtils.getLineEndOffsetByLine(editor, lineNumber);
            int actualLineLength = startLineEndOffset - startLineStartOffset;
            if (column > actualLineLength) {
                column = actualLineLength;
            }
            int startOffset = startLineStartOffset + column;
            if (decoration.getRenderOptions() == null) {
                return;
            }
            if (decoration.getRenderOptions().getBefore() != null) {
                text = decoration.getRenderOptions().getBefore().getContentText();
                this.addInlay(editor, decorationType, text, startOffset, startLineEndOffset, startLineStartOffset);
            }
            if (decoration.getRenderOptions().getAfter() != null) {
                text = decoration.getRenderOptions().getAfter().getContentText();
                this.addInlay(editor, decorationType, text, startOffset, startLineEndOffset, startLineStartOffset);
            }
        }
        catch (Exception e) {
            LogManager.warn(DecorationService.class, "addInlays:" + e.toString());
        }
    }

    private void markup(Editor editor, String decorationType, Range range) {
        try {
            int startLineNumber = range.getStartLineNumber() - 1;
            int endLineNumber = range.getEndLineNumber() - 1;
            int startColumn = range.getStartColumn() - 1;
            int endColumn = range.getEndColumn() - 1;
            DecorationRenderOptions renderOptions = decorationRenderOptionsMap.get(decorationType);
            if (renderOptions == null) {
                return;
            }
            TextAttributes textAttributes = new TextAttributes();
            TextAttributesProcessor processor = new TextAttributesProcessor();
            if (!TextUtils.isEmpty((CharSequence)renderOptions.getBackgroundColor())) {
                processor.processCssBackground(textAttributes, renderOptions.getBackgroundColor());
            }
            if (!TextUtils.isEmpty((CharSequence)renderOptions.getBorder())) {
                processor.processCssBorder(textAttributes, renderOptions.getBorder());
            }
            if (!TextUtils.isEmpty((CharSequence)renderOptions.getBorderColor())) {
                processor.processCssBorderColor(textAttributes, renderOptions.getBorderColor());
            }
            if (!TextUtils.isEmpty((CharSequence)renderOptions.getTextDecoration())) {
                processor.processTextDecoration(textAttributes, renderOptions.getTextDecoration());
            }
            List highlighters = this.rangeHighlighterMap.computeIfAbsent(decorationType, k -> new ArrayList());
            if (renderOptions.getIsWholeLine() != null && renderOptions.getIsWholeLine().booleanValue()) {
                for (int i = startLineNumber; i <= endLineNumber; ++i) {
                    RangeHighlighter rangeHighlighter = editor.getMarkupModel().addLineHighlighter(i, 6000, textAttributes);
                    highlighters.add(rangeHighlighter);
                }
                return;
            }
            int lineStartOffsetStart = CopilotEditorUtils.getLineStartOffsetByLine(editor, startLineNumber);
            int lineStartOffsetEnd = CopilotEditorUtils.getLineStartOffsetByLine(editor, endLineNumber);
            int startLineActualLength = CopilotEditorUtils.getLineEndOffsetByLine(editor, startLineNumber) - lineStartOffsetStart;
            int endLineActualLength = CopilotEditorUtils.getLineEndOffsetByLine(editor, endLineNumber) - lineStartOffsetEnd;
            if (startColumn > startLineActualLength) {
                startColumn = startLineActualLength;
            }
            if (endColumn > endLineActualLength) {
                endColumn = endLineActualLength;
            }
            int documentLength = editor.getDocument().getTextLength();
            int startOffset = lineStartOffsetStart + startColumn;
            int endOffset = lineStartOffsetEnd + endColumn;
            if (startOffset < 0) {
                startOffset = 0;
            }
            if (endOffset < 0) {
                endOffset = 0;
            }
            if (startOffset > documentLength) {
                startOffset = documentLength;
            }
            if (endOffset > documentLength) {
                endOffset = documentLength;
            }
            if (startOffset > endOffset) {
                int temp = startOffset;
                startOffset = Math.min(temp, endOffset);
                endOffset = Math.max(temp, endOffset);
            }
            RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 6000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add(rangeHighlighter);
        }
        catch (Exception e) {
            LogManager.warn(DecorationService.class, "markupdChars:" + e.toString());
        }
    }

    public void disposeAll() {
        if (!this.rangeHighlighterMap.isEmpty()) {
            HashSet<String> highlightKeysToDispose = new HashSet<String>(this.rangeHighlighterMap.keySet());
            for (String key : highlightKeysToDispose) {
                this.disposeMarkup(key);
            }
        }
        if (!this.inlaysMap.isEmpty()) {
            HashSet<String> inlayKeysToDispose = new HashSet<String>(this.inlaysMap.keySet());
            for (String key : inlayKeysToDispose) {
                this.disposeInlays(key);
            }
        }
    }

    public void dispose(String decorationType) {
        try {
            this.disposeMarkup(decorationType);
            this.disposeInlays(decorationType);
        }
        catch (Exception e) {
            LogManager.warn(DecorationService.class, "dispose:" + e.toString());
        }
    }

    private void disposeMarkup(String decorationType) {
        List<RangeHighlighter> rangeHighlighters = this.rangeHighlighterMap.get(decorationType);
        if (!CollectionUtils.isEmpty(rangeHighlighters)) {
            for (RangeHighlighter rangeHighlighter : rangeHighlighters) {
                ThreadManager.getInstance().runUiThread(() -> ((RangeHighlighter)rangeHighlighter).dispose());
            }
            rangeHighlighters.clear();
        }
        this.rangeHighlighterMap.remove(decorationType);
    }

    private void disposeInlays(String decorationType) {
        List<Inlay<?>> inlays = this.inlaysMap.get(decorationType);
        if (!CollectionUtils.isEmpty(inlays)) {
            for (Inlay<?> inlay : inlays) {
                try {
                    ThreadManager.getInstance().runUiThread(() -> inlay.dispose());
                }
                catch (Exception e) {
                    LogManager.warn(DecorationService.class, "disposeInlay error: " + e.toString());
                }
            }
            inlays.clear();
        }
        this.inlaysMap.remove(decorationType);
    }

    private void addInlay(Editor editor, String decorationType, String text, int offset, int lineEndOffset, int lineStartOffset) {
        List existingInlays = this.inlaysMap.getOrDefault(decorationType, Collections.emptyList());
        for (Inlay inlay : existingInlays) {
            if (!inlay.isValid() || inlay.getOffset() != offset && inlay.getOffset() != lineEndOffset || !((CopilotInlayRender)inlay.getRenderer()).getSolutions().contains(text)) continue;
            inlay.dispose();
        }
        InlayModel inlayModel = editor.getInlayModel();
        String source = editor.getDocument().getText();
        int tabSize = editor.getSettings().getTabSize(editor.getProject());
        CopilotInlayRender render = CopilotInlayRender.builder().source(source).solutions(List.of(text)).tabSize(tabSize).bgColor(null).fgColor((Color)JBColor.GRAY).offsetX(0).inlayColorItems(null).build();
        Inlay inlay = offset >= lineEndOffset || CopilotEditorUtils.isCaretAtEmptyLine(editor) ? inlayModel.addAfterLineEndElement(lineEndOffset, true, (EditorCustomElementRenderer)render) : inlayModel.addInlineElement(offset, true, (EditorCustomElementRenderer)render);
        List inlays = this.inlaysMap.computeIfAbsent(decorationType, k -> new ArrayList());
        inlays.add(inlay);
    }
}

