/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.Decoration.processor;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.tencent.code.intel.manager.LogManager;
import java.awt.Color;
import java.util.Map;

public class TextAttributesProcessor {
    private static final String EDITOR_WORD_HIGHLIGHT_TEXT_BACKGROUND = "editor.wordHighlightTextBackground";
    private static final String EDITOR_INSERTED_LINE_BACKGROUND = "diffEditor.insertedLineBackground";
    private static final String EDITOR_REMOVED_LINE_BACKGROUND = "diffEditor.removedLineBackground";
    private static final String EDITOR_UNCHANGED_CODE_BACKGROUND = "diffEditor.unchangedCodeBackground";
    private static final String EDITOR_SYMBOL_HIGHLIGHT_BACKGROUND = "editor.symbolHighlightBackground";
    private static final Map<String, Color> CSS_COLOR_MAP = Map.of("editor.wordHighlightTextBackground", ColorUtil.fromHex((String)"575757B8"), "diffEditor.insertedLineBackground", new Color(155, 185, 85, 51), "diffEditor.removedLineBackground", new Color(255, 0, 0, 51), "diffEditor.unchangedCodeBackground", ColorUtil.fromHex((String)"74747429"), "editor.symbolHighlightBackground", ColorUtil.fromHex((String)"EA5C0055"));

    public void processCssBackground(TextAttributes attributes, String cssColor) {
        try {
            Color color;
            if (cssColor.contains("\"id\"")) {
                this.processCssBackgroundKey(attributes, cssColor);
            }
            if ((color = this.parseCssColor(cssColor)) != null) {
                attributes.setBackgroundColor(color);
            }
        }
        catch (Exception e) {
            LogManager.warn(TextAttributesProcessor.class, "cssBackgroundProcess error: " + e.getMessage() + " for cssColor: " + cssColor);
        }
    }

    public void processCssBorderColor(TextAttributes attributes, String cssBorderColor) {
        try {
            Color color = this.parseBorderColor(cssBorderColor);
            if (color != null) {
                attributes.setEffectColor(color);
            }
        }
        catch (Exception e) {
            LogManager.warn(TextAttributesProcessor.class, "processCssBorderColor error: " + e.getMessage() + " for cssBorderColor: " + cssBorderColor);
        }
    }

    public void processCssBorder(TextAttributes attributes, String cssBorder) {
        try {
            String[] parts = cssBorder.split("\\s+");
            String style = parts.length > 1 ? parts[1] : "solid";
            Color color = this.parseBorderColor(cssBorder);
            attributes.setEffectColor(color);
            switch (style.toLowerCase()) {
                case "dashed": 
                case "double": {
                    attributes.setEffectType(EffectType.LINE_UNDERSCORE);
                    break;
                }
                case "dotted": {
                    attributes.setEffectType(EffectType.BOLD_DOTTED_LINE);
                    break;
                }
                default: {
                    attributes.setEffectType(EffectType.ROUNDED_BOX);
                    break;
                }
            }
        }
        catch (Exception e) {
            LogManager.warn(TextAttributesProcessor.class, "processCssBorder error: " + e.getMessage() + " for cssBorder: " + cssBorder);
        }
    }

    private void processCssBackgroundKey(TextAttributes attributes, String cssBackground) {
        try {
            if (cssBackground.contains(EDITOR_WORD_HIGHLIGHT_TEXT_BACKGROUND)) {
                attributes.setBackgroundColor(CSS_COLOR_MAP.get(EDITOR_WORD_HIGHLIGHT_TEXT_BACKGROUND));
            } else if (cssBackground.contains(EDITOR_INSERTED_LINE_BACKGROUND)) {
                attributes.setBackgroundColor(CSS_COLOR_MAP.get(EDITOR_INSERTED_LINE_BACKGROUND));
            } else if (cssBackground.contains(EDITOR_REMOVED_LINE_BACKGROUND)) {
                attributes.setBackgroundColor(CSS_COLOR_MAP.get(EDITOR_REMOVED_LINE_BACKGROUND));
            } else if (cssBackground.contains(EDITOR_UNCHANGED_CODE_BACKGROUND)) {
                attributes.setBackgroundColor(CSS_COLOR_MAP.get(EDITOR_UNCHANGED_CODE_BACKGROUND));
            } else if (cssBackground.contains(EDITOR_SYMBOL_HIGHLIGHT_BACKGROUND)) {
                attributes.setBackgroundColor(CSS_COLOR_MAP.get(EDITOR_SYMBOL_HIGHLIGHT_BACKGROUND));
            } else {
                LogManager.warn(TextAttributesProcessor.class, "Unknown css background key: " + cssBackground);
            }
        }
        catch (Exception e) {
            LogManager.warn(TextAttributesProcessor.class, "processCssBackgroundKey error: " + e.getMessage() + " for cssBackground: " + cssBackground);
        }
    }

    public void processTextDecoration(TextAttributes attributes, String textDecoration) {
        if (textDecoration == null || textDecoration.isEmpty()) {
            return;
        }
        try {
            if (textDecoration.contains("background-color: var(--vscode-diffEditor-removedTextBackground)")) {
                attributes.setBackgroundColor(new Color(255, 0, 0, 51));
            }
            if (textDecoration.contains("font-style: italic")) {
                attributes.setFontType(2);
            }
        }
        catch (Exception e) {
            LogManager.warn(TextAttributesProcessor.class, "processTextDecoration error: " + e.getMessage() + " for textDecoration: " + textDecoration);
        }
    }

    private Color parseBorderColor(String cssBorder) {
        if (cssBorder.contains("rgba")) {
            String rgba = cssBorder.substring(cssBorder.indexOf("rgba"));
            return this.parseCssColor(rgba);
        }
        if (cssBorder.contains("rgb")) {
            String rgb = cssBorder.substring(cssBorder.indexOf("rgb"));
            return this.parseCssColor(rgb);
        }
        if (cssBorder.contains("#")) {
            String hex = cssBorder.substring(cssBorder.indexOf("#"));
            return ColorUtil.fromHex((String)hex);
        }
        return null;
    }

    private Color parseCssColor(String cssColor) {
        if (cssColor.startsWith("rgba")) {
            String[] parts = cssColor.substring(5, cssColor.length() - 1).split(",");
            int r = Integer.parseInt(parts[0].trim());
            int g = Integer.parseInt(parts[1].trim());
            int b = Integer.parseInt(parts[2].trim());
            float a = Float.parseFloat(parts[3].trim());
            return new Color(r, g, b, (int)(a * 255.0f));
        }
        if (cssColor.startsWith("rgb")) {
            String[] parts = cssColor.substring(4, cssColor.length() - 1).split(",");
            int r = Integer.parseInt(parts[0].trim());
            int g = Integer.parseInt(parts[1].trim());
            int b = Integer.parseInt(parts[2].trim());
            return new Color(r, g, b);
        }
        if (cssColor.startsWith("#")) {
            return ColorUtil.fromHex((String)cssColor);
        }
        return null;
    }
}

