/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.configuration;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.tencent.code.intel.api.ICopilotSettingsService;
import com.tencent.code.intel.apibridge.configuration.item.ConfigurationBaseItem;
import com.tencent.code.intel.apibridge.extension.extension.configuration.ExtHostConfiguration;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.manager.LogManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SettingService {
    private JSONObject settingContent;
    private List<String> keyList;
    private static SettingService sharedInstance = new SettingService();

    public static SettingService getInstance() {
        return sharedInstance;
    }

    public void update(List<ConfigurationBaseItem> settingContent) {
        try {
            HashMap map = new HashMap();
            ICopilotSettingsService service = CopilotSettingsService.getInstance();
            settingContent.forEach(item -> {
                String[] keyList = item.getSettingKey().split("\\.");
                Map<String, Object> itemMap = map;
                for (int i = 0; i < keyList.length - 1; ++i) {
                    String key = keyList[i];
                    Map<String, Object> tempMap = itemMap.get(key) == null ? new HashMap() : (Map)itemMap.get(key);
                    itemMap.put(key, tempMap);
                    itemMap = tempMap;
                }
                Object value = service.getValueForKey(keyList[keyList.length - 1]);
                itemMap.put(keyList[keyList.length - 1], value == null ? item.getDefaultValue() : value);
            });
            this.keyList = settingContent.stream().map(ConfigurationBaseItem::getSettingKey).collect(Collectors.toList());
            this.settingContent = JSONObject.from(map);
        }
        catch (Exception e) {
            LogManager.warn(SettingService.class, "update setting error:" + String.valueOf(e));
        }
    }

    public void setSettingContent(JSONObject settingContent) {
        this.settingContent = settingContent;
        this.keyList = settingContent.entrySet().stream().flatMap(entry -> {
            JSONObject obj = JSONObject.from(entry.getValue());
            return obj.keySet().stream().map(key -> (String)entry.getKey() + "." + key);
        }).collect(Collectors.toList());
    }

    public JSONObject getSettingContent() {
        return this.settingContent == null ? JSONObject.parseObject((String)"{}") : this.settingContent;
    }

    public List<String> getKeyList() {
        return this.keyList == null ? new ArrayList() : this.keyList;
    }

    public void updateSetting(String key) {
        if (this.settingContent == null) {
            return;
        }
        JSONObject realSetting = this.settingContent.getJSONObject("codingcopilot");
        try {
            if (realSetting.get(key).toString().equals(CopilotSettingsService.getInstance().getValueForKey(key).toString())) {
                return;
            }
        }
        catch (Exception e) {
            LogManager.warn(SettingService.class, "updateSetting error: " + String.valueOf(e));
        }
        realSetting.put((Object)key, CopilotSettingsService.getInstance().getValueForKey(key));
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            ExtHostConfiguration.acceptConfigurationChanged(openProject, List.of(key));
        }
    }
}

