/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.diagnostics;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.tencent.code.intel.apibridge.extension.extension.diagnostics.IMarkerData;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.manager.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExtHostDiagnostics {
    public static void acceptMarkersChange(Project project, VirtualFile file) {
        if (project == null || file == null || !file.isValid()) {
            return;
        }
        try {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null || !psiFile.isValid()) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file);
            if (document == null) {
                return;
            }
            ArrayList allHighlights = new ArrayList();
            DaemonCodeAnalyzerEx.processHighlights((Document)document, (Project)project, (HighlightSeverity)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING, (int)0, (int)document.getTextLength(), (Processor)Processors.cancelableCollectProcessor(allHighlights));
            List markerData = allHighlights.stream().map(info -> ExtHostDiagnostics.convertHighlightToMarkerData(info, psiFile)).collect(Collectors.toList());
            if (NodeRunner.getInstance(project) == null) {
                return;
            }
            NodeRunner.getInstance(project).getRpcChannel().sendReq("ExtHostDiagnostics", "$acceptMarkersChange", List.of(List.of(List.of(file.getPath(), markerData))), object -> {});
        }
        catch (Exception e) {
            LogManager.warn(ExtHostDiagnostics.class, "error Diagnostics" + e.toString());
        }
    }

    private static IMarkerData convertHighlightToMarkerData(HighlightInfo info, PsiFile file) {
        Document doc = file.getViewProvider().getDocument();
        int startOffset = info.startOffset;
        int endOffset = info.endOffset;
        int startLine = doc.getLineNumber(startOffset);
        int startCol = startOffset - doc.getLineStartOffset(startLine);
        int endLine = doc.getLineNumber(endOffset);
        int endCol = endOffset - doc.getLineStartOffset(endLine);
        IMarkerData data = new IMarkerData();
        data.setMessage(info.getDescription());
        data.setStartLineNumber(startLine);
        data.setStartColumn(startCol);
        data.setEndLineNumber(endLine);
        data.setEndColumn(endCol);
        data.setSeverity(1);
        String severity = info.getSeverity().getName().toUpperCase();
        if (severity.contains("ERROR")) {
            data.setSeverity(8);
        } else if (severity.contains("WARN")) {
            data.setSeverity(4);
        } else if (severity.contains("INFO")) {
            data.setSeverity(2);
        }
        return data;
    }
}

