/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.documentsandeditors;

import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.ModelChangedEvent;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util.DocumentToExtHostDataConverter;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import com.tencent.code.intel.manager.LogManager;
import java.util.List;

public class ExtHostDocuments {
    private final RPCProtocol rpcChannel;

    public ExtHostDocuments(RPCProtocol rpcChannel) {
        this.rpcChannel = rpcChannel;
    }

    public void documentChanged(DocumentEvent event) {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile == null) {
            LogManager.warn(ExtHostDocuments.class, "VirtualFile is null");
            return;
        }
        String path = VirtualFileUriBean.from(virtualFile).getUri();
        ModelChangedEvent contentChange = DocumentToExtHostDataConverter.convert(event);
        if (contentChange == null) {
            LogManager.warn(ExtHostDocuments.class, "ModelChangedEvent is null");
            return;
        }
        Boolean isDirty = FileDocumentManager.getInstance().isDocumentUnsaved(event.getDocument());
        this.rpcChannel.sendReq(ExtHostDocuments.class.getSimpleName(), "$acceptModelChanged", List.of(path, contentChange, isDirty), object -> {});
    }

    public void acceptModelSave(String path) {
        this.rpcChannel.sendReq(ExtHostDocuments.class.getSimpleName(), "$acceptModelSaved", List.of(path), object -> {});
    }
}

