/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.documentsandeditors;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.DocumentsAndEditorsDelta;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.ModelAddedData;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.TextEditorAddData;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util.DocumentToExtHostDataConverter;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ExtHostDocumentsAndEditors {
    private final RPCProtocol rpcChannel;
    private final List<Document> hasLoadDocuments = new ArrayList<Document>();
    private Document focusedDocument = null;
    private FileEditor fileEditor = null;
    private VirtualFile file = null;

    public ExtHostDocumentsAndEditors(RPCProtocol rpcChannel) {
        this.rpcChannel = rpcChannel;
    }

    public void addDocument(Document document, Project project) {
        if (document == null) {
            return;
        }
        if (this.hasLoadDocuments.contains(document)) {
            return;
        }
        this.hasLoadDocuments.add(document);
        ModelAddedData documentData = DocumentToExtHostDataConverter.convert(project, document);
        ArrayList<ModelAddedData> documentDataList = new ArrayList<ModelAddedData>();
        if (documentData != null) {
            documentDataList.add(documentData);
        }
        DocumentsAndEditorsDelta delta = new DocumentsAndEditorsDelta();
        delta.setAddedDocuments(documentDataList);
        this.acceptDocumentsAndEditorsDelta(delta);
    }

    public void updateFocusedDocument(@Nullable Document focusedDocument, Project project, Document oldDocument) {
        if (this.focusedDocument == null && focusedDocument == null) {
            return;
        }
        if (focusedDocument != null && focusedDocument.equals(this.focusedDocument)) {
            return;
        }
        this.removeDocument(oldDocument, project);
        this.focusedDocument = focusedDocument;
        this.addDocument(this.focusedDocument, project);
    }

    public void updateEditor(@Nullable FileEditor fileEditor, VirtualFile file, Project project, FileEditor oldEditor, VirtualFile oldFile) {
        if (this.fileEditor == null && fileEditor == null) {
            return;
        }
        if (fileEditor != null && fileEditor.equals(this.fileEditor)) {
            return;
        }
        this.removeEditor(oldEditor, oldFile, project);
        this.fileEditor = fileEditor;
        this.file = file;
        this.addEditor(this.fileEditor, file, project);
    }

    public void forceUpdateEditorAndDocument(Project project, FileEditor fileEditor, Document document, VirtualFile file) {
        if (document != null) {
            this.focusedDocument = null;
            this.hasLoadDocuments.remove(document);
            this.updateFocusedDocument(document, project, null);
        }
        if (fileEditor != null) {
            this.fileEditor = null;
            this.file = null;
            this.updateEditor(fileEditor, file, project, null, null);
        }
    }

    private void addEditor(FileEditor fileEditor, VirtualFile file, Project project) {
        if (fileEditor == null || file == null) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        TextEditorAddData textEditorAddData = DocumentToExtHostDataConverter.convert(fileEditor, document);
        ArrayList<TextEditorAddData> textEditorAddDataList = new ArrayList<TextEditorAddData>();
        DocumentsAndEditorsDelta delta = new DocumentsAndEditorsDelta();
        if (textEditorAddData != null) {
            textEditorAddDataList.add(textEditorAddData);
            delta.setNewActiveEditor(textEditorAddData.getId());
        }
        delta.setAddedEditors(textEditorAddDataList);
        this.acceptDocumentsAndEditorsDelta(delta);
    }

    public void removeEditor(FileEditor fileEditor, VirtualFile file, Project project) {
        if (fileEditor == null || file == null) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        String editorId = DocumentToExtHostDataConverter.getEditorId(fileEditor, document);
        ArrayList<String> removeEditorList = new ArrayList<String>();
        if (!editorId.isEmpty()) {
            removeEditorList.add(editorId);
        }
        DocumentsAndEditorsDelta delta = new DocumentsAndEditorsDelta();
        delta.setRemovedEditors(removeEditorList);
        this.acceptDocumentsAndEditorsDelta(delta);
    }

    public void removeDocument(Document document, Project project) {
        if (document == null) {
            return;
        }
        this.hasLoadDocuments.remove(document);
        ArrayList<String> removeDocumentList = new ArrayList<String>();
        DocumentsAndEditorsDelta delta = new DocumentsAndEditorsDelta();
        delta.setRemovedDocuments(removeDocumentList);
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        if (file != null) {
            String uri = VirtualFileUriBean.from(file).getUri();
            removeDocumentList.add(uri);
        }
        this.acceptDocumentsAndEditorsDelta(delta);
    }

    private void acceptDocumentsAndEditorsDelta(DocumentsAndEditorsDelta delta) {
        this.rpcChannel.sendReq(ExtHostDocumentsAndEditors.class.getSimpleName(), "$acceptDocumentsAndEditorsDelta", List.of(delta), object -> {});
    }

    public Document getFocusedDocument() {
        return this.focusedDocument;
    }

    public FileEditor getFileEditor() {
        return this.fileEditor;
    }
}

