/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.ModelAddedData;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.ModelChangedEvent;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.ModelContentChange;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.data.TextEditorAddData;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util.DocumentsEditorsUtils;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util.LanguageIdUtil;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.model.Range;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.DocumentUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.charset.Charset;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DocumentToExtHostDataConverter {
    public static ModelAddedData convert(Project project, Document document) {
        if (document == null) {
            return null;
        }
        try {
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            String fullText = document.getText();
            String[] lines = fullText.split("\n", -1);
            String EOL = "\n";
            String uri = VirtualFileUriBean.from(file).getUri();
            Long versionId = document.getModificationStamp();
            String languageId = LanguageIdUtil.getLanguageId(file.getName());
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile != null) {
                languageId = DocumentUtils.findLanguageId(psiFile);
            }
            Boolean isDirty = FileDocumentManager.getInstance().isDocumentUnsaved(document);
            Charset charset = file.getCharset();
            String encoding = charset != null ? charset.name() : "UTF-8";
            return new ModelAddedData(uri, versionId, lines, EOL, languageId, isDirty, encoding);
        }
        catch (Exception e) {
            LogManager.error(DocumentToExtHostDataConverter.class, "convert document error:" + e.toString());
            return null;
        }
    }

    public static TextEditorAddData convert(FileEditor fileEditor, Document document) {
        if (fileEditor == null || document == null) {
            return null;
        }
        try {
            TextEditorAddData editorData = new TextEditorAddData();
            String id = DocumentToExtHostDataConverter.getEditorId(fileEditor, document);
            editorData.setId(id);
            VirtualFile file = FileDocumentManager.getInstance().getFile(document);
            String uri = VirtualFileUriBean.from(file).getUri();
            editorData.setDocumentUri(uri);
            if (fileEditor instanceof TextEditor) {
                int tabSize;
                Editor editor = ((TextEditor)fileEditor).getEditor();
                EditorSettings settings = editor.getSettings();
                int indentSize = tabSize = settings.getTabSize(editor.getProject());
                boolean isLineNumbersShown = settings.isLineNumbersShown();
                boolean insertSpaces = settings.isUseTabCharacter(editor.getProject());
                TextEditorAddData.ResolvedTextEditorConfiguration options = new TextEditorAddData.ResolvedTextEditorConfiguration(tabSize, indentSize, indentSize, insertSpaces, 1, isLineNumbersShown);
                editorData.setOptions(options);
                CaretModel caretModel = editor.getCaretModel();
                LogicalPosition caretPos = caretModel.getLogicalPosition();
                int caretLine = caretPos.line + 1;
                int caretCol = caretPos.column + 1;
                SelectionModel selectionModel = editor.getSelectionModel();
                int selectionStartOffset = selectionModel.getSelectionStart();
                LogicalPosition selectionStartPos = editor.offsetToLogicalPosition(selectionStartOffset);
                int selectionStartLine = selectionStartPos.line + 1;
                int selectionStartCol = selectionStartPos.column + 1;
                TextEditorAddData.Selection[] selections = new TextEditorAddData.Selection[]{new TextEditorAddData.Selection(selectionStartLine, selectionStartCol, caretLine, caretCol)};
                editorData.setSelections(selections);
                ScrollingModel scrollingModel = editor.getScrollingModel();
                Rectangle visibleArea = scrollingModel.getVisibleArea();
                int minLine = 1;
                int minCol = 1;
                int maxLine = Math.max(document.getLineCount(), minLine);
                int maxCol = document.getLineCount() > 0 ? document.getLineEndOffset(maxLine - 1) + 1 : minCol;
                LogicalPosition startLogicalPos = editor.xyToLogicalPosition(new Point(visibleArea.x, visibleArea.y));
                LogicalPosition endLogicalPos = editor.xyToLogicalPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
                int startLine = startLogicalPos.line + 1;
                int startCol = startLogicalPos.column + 1;
                int endLine = endLogicalPos.line + 1;
                int endCol = endLogicalPos.column + 1;
                Range[] visibleRanges = new Range[]{new Range(Math.max(startLine, minLine), Math.max(startCol, minCol), Math.min(endLine, maxLine), endCol > maxCol && endLine >= maxLine ? maxCol : endCol)};
                editorData.setVisibleRanges(visibleRanges);
            } else {
                TextEditorAddData.ResolvedTextEditorConfiguration options = new TextEditorAddData.ResolvedTextEditorConfiguration(4, 4, 4, false, 1, true);
                editorData.setOptions(options);
                editorData.setSelections(new TextEditorAddData.Selection[0]);
                editorData.setVisibleRanges(new Range[0]);
            }
            String editorPosition = "left";
            editorData.setEditorPosition(editorPosition);
            return editorData;
        }
        catch (Exception e) {
            LogManager.error(DocumentToExtHostDataConverter.class, "convert editor error:" + e.toString());
            return null;
        }
    }

    public static String getEditorId(FileEditor editor, Document document) {
        if (editor == null || document == null) {
            return "";
        }
        return "document_" + document.hashCode();
    }

    public static ModelChangedEvent convert(@NotNull DocumentEvent event) {
        if (event == null) {
            DocumentToExtHostDataConverter.$$$reportNull$$$0(0);
        }
        try {
            Document document = event.getDocument();
            if (document == null) {
                LogManager.error(DocumentToExtHostDataConverter.class, "convert document error, document is null");
                return null;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                LogManager.error(DocumentToExtHostDataConverter.class, "convert document event, virtualFile is null" + String.valueOf(event.getDocument()));
                return null;
            }
            int offset = event.getOffset();
            int[] startLineAndColumn = DocumentsEditorsUtils.offsetToLineAndColumn(document, offset);
            int[] endLineAndColumn = DocumentsEditorsUtils.offsetToLineAndColumn(document, offset + event.getOldLength());
            Range range = new Range(startLineAndColumn[0], startLineAndColumn[1], endLineAndColumn[0], endLineAndColumn[1]);
            ModelContentChange change = new ModelContentChange(range, event.getNewFragment().toString(), offset + 1, event.getOldLength());
            String eol = "\n";
            Boolean isUndoing = false;
            Boolean isRedoing = false;
            return new ModelChangedEvent(Collections.singletonList(change), eol, document.getModificationStamp(), isUndoing, isRedoing);
        }
        catch (Exception e) {
            LogManager.warn(DocumentToExtHostDataConverter.class, "convert document event error:" + e.toString());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/tencent/code/intel/apibridge/extension/extension/documentsandeditors/util/DocumentToExtHostDataConverter", "convert"));
    }
}

