/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util;

import com.intellij.openapi.editor.Document;

public class DocumentsEditorsUtils {
    public static int getDocumentOffset(Document document, Number lineNumber, Number columnNumber) {
        int lineOffset;
        int offset;
        int line = lineNumber.intValue() - 1;
        if (line > document.getLineCount() - 1) {
            line = Math.max(document.getLineCount() - 1, 0);
        }
        if ((offset = (lineOffset = document.getLineStartOffset(line)) + columnNumber.intValue() - 1) > document.getLineEndOffset(line)) {
            offset = Math.max(document.getLineEndOffset(line), 0);
        }
        return offset;
    }

    public static int[] offsetToLineAndColumn(Document document, int offset) {
        if (offset < 0) {
            offset = 0;
        }
        int lineNumber = document.getLineNumber(offset);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int column = offset - lineStartOffset;
        return new int[]{lineNumber + 1, column + 1};
    }
}

