/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.editortabs;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.EditorTabDto;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.EditorTabGroupDto;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.TabOperation;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.util.EditorTabsConverter;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ExtHostEditorTabs {
    private final RPCProtocol rpcChannel;
    private Map<Integer, EditorTabGroupDto> editorTabGroupDtos = new HashMap<Integer, EditorTabGroupDto>();

    public ExtHostEditorTabs(RPCProtocol rpcChannel) {
        this.rpcChannel = rpcChannel;
    }

    public void initializeEditorTabs(Project project) {
        List<EditorTabGroupDto> editorTabGroupDtosList = this.getEditorTabGroupDtos(project);
        this.acceptEditorTabModel(editorTabGroupDtosList);
    }

    public void updateAllWindows(Project project) {
        HashMap<Integer, EditorTabGroupDto> editorTabGroupDtosMap = new HashMap<Integer, EditorTabGroupDto>();
        List<EditorTabGroupDto> editorTabGroupDtosList = this.getEditorTabGroupDtos(project);
        boolean needCallAcceptEditorTab = false;
        if (editorTabGroupDtosList.size() > this.editorTabGroupDtos.size()) {
            this.acceptEditorTabModel(editorTabGroupDtosList);
        }
        for (EditorTabGroupDto groupDto : editorTabGroupDtosList) {
            Integer groupId = groupDto.getGroupId().intValue();
            if (this.editorTabGroupDtos.get(groupId) != null) {
                EditorTabGroupDto oldGroupDto = this.editorTabGroupDtos.get(groupId);
                if (oldGroupDto.checkNeedUpdate(groupDto)) {
                    this.acceptTabGroupUpdate(groupDto);
                }
                if (oldGroupDto.getTabs().size() != groupDto.getTabs().size()) {
                    needCallAcceptEditorTab = true;
                }
                this.callUpdateTabOperationInNeeded(groupDto, oldGroupDto, oldGroupDto.getTabs().size() != groupDto.getTabs().size());
            } else {
                needCallAcceptEditorTab = true;
            }
            editorTabGroupDtosMap.put(groupId, groupDto);
        }
        if (editorTabGroupDtosList.size() < this.editorTabGroupDtos.size() || needCallAcceptEditorTab && editorTabGroupDtosList.size() == this.editorTabGroupDtos.size()) {
            this.acceptEditorTabModel(editorTabGroupDtosList);
        }
        this.editorTabGroupDtos = editorTabGroupDtosMap;
    }

    public void fileOpen(VirtualFile file, Project project) {
        EditorWindow[] windows;
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        block0: for (EditorWindow window : windows = fileEditorManagerEx.getWindows()) {
            VirtualFile[] files = window.getFiles();
            int groupId = window.hashCode();
            for (int j = 0; j < files.length; ++j) {
                if (files[j] != file) continue;
                TabOperation operation = EditorTabsConverter.convertToTabOperationData(file, window, (FileEditorManager)fileEditorManagerEx, TabOperation.TabModelOperationKind.TAB_OPEN, j, groupId, null);
                this.acceptTabOperation(operation);
                continue block0;
            }
        }
    }

    public void fileClose(VirtualFile file, Project project) {
        EditorWindow[] windows;
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        block0: for (EditorWindow window : windows = fileEditorManagerEx.getWindows()) {
            VirtualFile[] files = window.getFiles();
            int groupId = window.hashCode();
            for (int j = 0; j < files.length; ++j) {
                if (files[j] != file) continue;
                TabOperation operation = EditorTabsConverter.convertToTabOperationData(file, window, (FileEditorManager)fileEditorManagerEx, TabOperation.TabModelOperationKind.TAB_CLOSE, j, groupId, null);
                this.acceptTabOperation(operation);
                continue block0;
            }
        }
    }

    public void tabSwitched(VirtualFile file, Project project) {
        EditorWindow[] windows;
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project);
        for (EditorWindow window : windows = fileEditorManagerEx.getWindows()) {
            VirtualFile[] files = window.getFiles();
            int groupId = window.hashCode();
            for (int j = 0; j < files.length; ++j) {
                if (files[j] != file) continue;
                TabOperation operation = EditorTabsConverter.convertToTabOperationData(file, window, (FileEditorManager)fileEditorManagerEx, TabOperation.TabModelOperationKind.TAB_UPDATE, j, groupId, null);
                this.acceptTabOperation(operation);
                return;
            }
        }
    }

    private List<EditorTabGroupDto> getEditorTabGroupDtos(Project project) {
        EditorWindow[] windows = FileEditorManagerEx.getInstanceEx((Project)project).getWindows();
        ArrayList<EditorTabGroupDto> editorTabGroupDtosList = new ArrayList<EditorTabGroupDto>();
        for (int i = 0; i < windows.length; ++i) {
            int groupId = windows[i].hashCode();
            EditorTabGroupDto groupDto = EditorTabsConverter.convertToDto(windows[i], project, i, groupId);
            editorTabGroupDtosList.add(groupDto);
        }
        return editorTabGroupDtosList;
    }

    private void callUpdateTabOperationInNeeded(EditorTabGroupDto groupDto, EditorTabGroupDto oldGroupDto, boolean hasFileSizeChanged) {
        block0: for (int i = 0; i < groupDto.getTabs().size(); ++i) {
            EditorTabDto tabDto = groupDto.getTabs().get(i);
            for (int j = 0; j < oldGroupDto.getTabs().size(); ++j) {
                boolean isMove;
                EditorTabDto oldTabDto = oldGroupDto.getTabs().get(j);
                if (!tabDto.getId().equals(oldTabDto.getId())) continue;
                boolean bl = isMove = i != j && !hasFileSizeChanged;
                if (tabDto.equals(oldTabDto) && !isMove) continue block0;
                this.fileUpdate(i, tabDto, groupDto.getGroupId(), isMove ? Integer.valueOf(j) : null);
                continue block0;
            }
        }
    }

    private void fileUpdate(Integer index, EditorTabDto dto, Number groupId, @Nullable Number oldIndex) {
        TabOperation operation = new TabOperation();
        if (oldIndex != null) {
            operation.setKind(TabOperation.TabModelOperationKind.TAB_MOVE);
        } else {
            operation.setKind(TabOperation.TabModelOperationKind.TAB_UPDATE);
        }
        operation.setIndex(index);
        operation.setTabDto(dto);
        operation.setGroupId(groupId);
        operation.setOldIndex(oldIndex);
        this.acceptTabOperation(operation);
    }

    private void acceptTabGroupUpdate(EditorTabGroupDto groupDto) {
        this.rpcChannel.sendReq(ExtHostEditorTabs.class.getSimpleName(), "$acceptTabGroupUpdate", List.of(groupDto), object -> {});
    }

    private void acceptEditorTabModel(List<EditorTabGroupDto> tabGroups) {
        this.rpcChannel.sendReq(ExtHostEditorTabs.class.getSimpleName(), "$acceptEditorTabModel", List.of(tabGroups), object -> {});
    }

    private void acceptTabOperation(TabOperation operation) {
        this.rpcChannel.sendReq(ExtHostEditorTabs.class.getSimpleName(), "$acceptTabOperation", List.of(operation), object -> {});
    }
}

