/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.editortabs.util;

import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.EditorTabDto;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.EditorTabGroupDto;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.TabOperation;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.TextDiffInputDto;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.TextInputDto;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.UriComponents;
import com.tencent.code.intel.apibridge.extension.mainthread.command.MainThreadCommandImplementService;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTabsConverter {
    public static EditorTabGroupDto convertToDto(EditorWindow editorWindow, Project project, int groupIndex, int groupId) {
        EditorTabGroupDto dto = new EditorTabGroupDto();
        dto.setIsActive(EditorTabsConverter.isWindowActive(editorWindow, project));
        dto.setViewColumn(groupIndex);
        dto.setGroupId(groupId);
        dto.setTabs(EditorTabsConverter.getTabsFromWindow(editorWindow, project, dto.getGroupId().intValue()));
        return dto;
    }

    public static TabOperation convertToTabOperationData(@NotNull VirtualFile virtualFile, @NotNull EditorWindow window, @NotNull FileEditorManager fileEditorManager, @NotNull TabOperation.TabModelOperationKind operationKind, @NotNull Number index, @NotNull Number groupId, @Nullable Number oldIndex) {
        if (virtualFile == null) {
            EditorTabsConverter.$$$reportNull$$$0(0);
        }
        if (window == null) {
            EditorTabsConverter.$$$reportNull$$$0(1);
        }
        if (fileEditorManager == null) {
            EditorTabsConverter.$$$reportNull$$$0(2);
        }
        if (operationKind == null) {
            EditorTabsConverter.$$$reportNull$$$0(3);
        }
        if (index == null) {
            EditorTabsConverter.$$$reportNull$$$0(4);
        }
        if (groupId == null) {
            EditorTabsConverter.$$$reportNull$$$0(5);
        }
        TabOperation data = new TabOperation();
        data.setKind(operationKind);
        data.setIndex(index);
        data.setGroupId(groupId);
        data.setOldIndex(oldIndex);
        EditorTabDto tabDto = EditorTabsConverter.convertToEditorTabDto(window, virtualFile, fileEditorManager, groupId.intValue());
        data.setTabDto(tabDto);
        return data;
    }

    private static Boolean isWindowActive(EditorWindow editorWindow, Project project) {
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)project);
        return manager.getCurrentWindow() == editorWindow;
    }

    private static List<EditorTabDto> getTabsFromWindow(EditorWindow editorWindow, Project project, Integer groupId) {
        ArrayList<EditorTabDto> tabs = new ArrayList<EditorTabDto>();
        Arrays.stream(editorWindow.getFiles()).forEach(file -> {
            EditorTabDto tabDto = EditorTabsConverter.convertToEditorTabDto(editorWindow, file, FileEditorManager.getInstance((Project)project), groupId);
            tabs.add(tabDto);
        });
        return tabs;
    }

    private static EditorTabDto convertToEditorTabDto(@NotNull EditorWindow window, @NotNull VirtualFile file, @NotNull FileEditorManager fileEditorManager, Integer groupId) {
        if (window == null) {
            EditorTabsConverter.$$$reportNull$$$0(6);
        }
        if (file == null) {
            EditorTabsConverter.$$$reportNull$$$0(7);
        }
        if (fileEditorManager == null) {
            EditorTabsConverter.$$$reportNull$$$0(8);
        }
        EditorTabDto tabDto = new EditorTabDto();
        tabDto.setEditorId("default");
        tabDto.setId(EditorTabsConverter.getTabId(groupId, file.getUrl()));
        tabDto.setLabel(file.getName());
        FileEditor selectedEditor = fileEditorManager.getSelectedEditor(file);
        boolean isActiveWindow = EditorTabsConverter.isWindowActive(window, fileEditorManager.getProject());
        tabDto.setIsActive(isActiveWindow && selectedEditor != null && selectedEditor.equals(fileEditorManager.getSelectedEditor()));
        EditorComposite composite = window.getComposite(file);
        if (composite != null) {
            tabDto.setIsPinned(composite.isPinned());
            tabDto.setIsPreview(composite.isPreview());
        } else {
            tabDto.setIsPinned(false);
            tabDto.setIsPreview(false);
        }
        tabDto.setIsDirty(file.isWritable() && !file.isValid());
        if (file instanceof ChainDiffVirtualFile) {
            ChainDiffVirtualFile diffVirtualFile = (ChainDiffVirtualFile)file;
            UriComponents originalUri = (UriComponents)diffVirtualFile.getUserData(MainThreadCommandImplementService.DIFF_ORIGINAL_URI_KEY);
            UriComponents modifiedUri = (UriComponents)diffVirtualFile.getUserData(MainThreadCommandImplementService.DIFF_MODIFIED_URI_KEY);
            if (originalUri != null && modifiedUri != null) {
                TextDiffInputDto diffInputDto = new TextDiffInputDto(originalUri, modifiedUri);
                tabDto.setInput(diffInputDto);
            }
        } else {
            TextInputDto inputDto = new TextInputDto(VirtualFileUriBean.from(file).getUri());
            tabDto.setInput(inputDto);
        }
        return tabDto;
    }

    public static String getTabId(Integer groupId, String path) {
        return String.format("%d~%s~%s~%s", groupId, "default", "workbench.editors.files.fileEditorInput", path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationKind";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/tencent/code/intel/apibridge/extension/extension/editortabs/util/EditorTabsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToTabOperationData";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "convertToEditorTabDto";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

