/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.filesystem;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.tencent.code.intel.apibridge.extension.extension.filesystem.FileOperation;
import com.tencent.code.intel.apibridge.extension.extension.filesystem.SourceTargetPair;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import java.nio.file.Path;
import java.util.List;

public class ExtHostFileSystemEventService {
    private final RPCProtocol rpcChannel;

    public ExtHostFileSystemEventService(RPCProtocol rpcChannel) {
        this.rpcChannel = rpcChannel;
    }

    public void createFile(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        SourceTargetPair pair = new SourceTargetPair();
        pair.setTarget(VirtualFileUriBean.from(file).getUri());
        this.onWillRunFileOperation(FileOperation.CREATE, List.of(pair));
        this.onDidRunFileOperation(FileOperation.CREATE, List.of(pair));
    }

    public void deleteFile(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        SourceTargetPair pair = new SourceTargetPair();
        pair.setTarget(VirtualFileUriBean.from(file).getUri());
        this.onWillRunFileOperation(FileOperation.DELETE, List.of(pair));
        this.onDidRunFileOperation(FileOperation.DELETE, List.of(pair));
    }

    public void moveFile(VirtualFileMoveEvent event) {
        String fileName = event.getFile().getName();
        Path oldParent = Path.of(event.getOldParent().getPath(), new String[0]);
        Path newParent = Path.of(event.getNewParent().getPath(), new String[0]);
        String oldFileStr = VirtualFileUriBean.from((VirtualFileSystem)LocalFileSystem.getInstance(), oldParent.resolve(fileName).toString()).getUri();
        String newFileStr = VirtualFileUriBean.from((VirtualFileSystem)LocalFileSystem.getInstance(), newParent.resolve(fileName).toString()).getUri();
        SourceTargetPair pair = new SourceTargetPair();
        pair.setTarget(newFileStr);
        pair.setSource(oldFileStr);
        this.onWillRunFileOperation(FileOperation.MOVE, List.of(pair));
        this.onDidRunFileOperation(FileOperation.MOVE, List.of(pair));
    }

    public void copyFile(VirtualFileCopyEvent event) {
        VirtualFile originalFile = event.getOriginalFile();
        VirtualFile createdFile = event.getFile();
        SourceTargetPair pair = new SourceTargetPair();
        pair.setTarget(VirtualFileUriBean.from(createdFile).getUri());
        pair.setSource(VirtualFileUriBean.from(originalFile).getUri());
        this.onWillRunFileOperation(FileOperation.COPY, List.of(pair));
        this.onDidRunFileOperation(FileOperation.COPY, List.of(pair));
    }

    public void renameFile(VirtualFilePropertyEvent event) {
        Path parentPath = Path.of(event.getFile().getParent().getPath(), new String[0]);
        String oldFileStr = (String)event.getOldValue();
        String newFileStr = (String)event.getNewValue();
        oldFileStr = VirtualFileUriBean.from((VirtualFileSystem)LocalFileSystem.getInstance(), parentPath.resolve(oldFileStr).toString()).getUri();
        newFileStr = VirtualFileUriBean.from((VirtualFileSystem)LocalFileSystem.getInstance(), parentPath.resolve(newFileStr).toString()).getUri();
        SourceTargetPair movePair = new SourceTargetPair();
        movePair.setTarget(newFileStr);
        movePair.setSource(oldFileStr);
        this.onWillRunFileOperation(FileOperation.MOVE, List.of(movePair));
        this.onDidRunFileOperation(FileOperation.MOVE, List.of(movePair));
    }

    private void onWillRunFileOperation(FileOperation operation, List<SourceTargetPair> files) {
        Integer timeout = 60000;
        this.rpcChannel.sendReq(ExtHostFileSystemEventService.class.getSimpleName(), "$onWillRunFileOperation", List.of(operation, files, timeout), object -> {});
    }

    private void onDidRunFileOperation(FileOperation operation, List<SourceTargetPair> files) {
        this.rpcChannel.sendReq(ExtHostFileSystemEventService.class.getSimpleName(), "$onDidRunFileOperation", List.of(operation, files), object -> {});
    }
}

