/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.languagefeatures;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.AnimatedIcon;
import com.tencent.code.intel.apibridge.extension.extension.command.CommandDto;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.codelens.CodeLensResult;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LogManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;

public class CodeLensInlayManager {
    private static final Map<Editor, Map<Integer, List<CodeLensResult>>> lastCodeLensMap = new ConcurrentHashMap<Editor, Map<Integer, List<CodeLensResult>>>();
    private static final Map<Editor, Map<Integer, Inlay<?>>> inlayMap = new ConcurrentHashMap();

    public static void renderCodeLens(Editor editor, Map<Integer, List<CodeLensResult>> codeLensMap) {
        try {
            InlayModel inlayModel = editor.getInlayModel();
            Map lastMap = lastCodeLensMap.getOrDefault(editor, new ConcurrentHashMap());
            Map editorInlayMap = inlayMap.computeIfAbsent(editor, k -> new ConcurrentHashMap());
            for (Integer n : lastMap.keySet()) {
                Inlay oldInlay;
                if (codeLensMap.containsKey(n) || (oldInlay = (Inlay)editorInlayMap.remove(n)) == null) continue;
                oldInlay.dispose();
            }
            for (Map.Entry entry : codeLensMap.entrySet()) {
                Inlay inlay;
                int line = (Integer)entry.getKey();
                List newResults = (List)entry.getValue();
                List oldResults = (List)lastMap.get(line);
                boolean needUpdate = oldResults == null || !CodeLensInlayManager.isSameCodeLensList(oldResults, newResults);
                if (!needUpdate) continue;
                Inlay oldInlay = (Inlay)editorInlayMap.remove(line);
                if (oldInlay != null) {
                    oldInlay.dispose();
                }
                int offset = editor.getDocument().getLineStartOffset(line - 1);
                int column = CodeLensInlayManager.calculateIndentColumn(editor, line - 1);
                InlayPresentation presentation = CodeLensInlayManager.createPresentationForCodeLens(editor, newResults, column);
                if (presentation == null || (inlay = inlayModel.addBlockElement(offset, false, true, 0, (EditorCustomElementRenderer)new PresentationRenderer(presentation))) == null) continue;
                editorInlayMap.put(line, inlay);
            }
            lastCodeLensMap.put(editor, new ConcurrentHashMap<Integer, List<CodeLensResult>>(codeLensMap));
        }
        catch (Exception e) {
            LogManager.warn(CodeLensInlayManager.class, "Error rendering CodeLens: " + e.getMessage());
        }
    }

    public static InlayPresentation createPresentationForCodeLens(Editor editor, List<CodeLensResult> results, int column) {
        PresentationFactory factory;
        try {
            factory = (PresentationFactory)PresentationFactory.class.getConstructor(Editor.class).newInstance(editor);
        }
        catch (Exception e) {
            try {
                factory = (PresentationFactory)PresentationFactory.class.getConstructor(EditorImpl.class).newInstance((EditorImpl)editor);
            }
            catch (Exception ex) {
                LogManager.warn(CodeLensInlayManager.class, "Error creating PresentationFactory: " + ex.getMessage());
                return null;
            }
        }
        try {
            ArrayList<InlayPresentation> presentations = new ArrayList<InlayPresentation>();
            presentations.add(factory.textSpacePlaceholder(column, true));
            boolean first = true;
            for (CodeLensResult result : results) {
                if (!first) {
                    presentations.add(factory.smallText(" | "));
                }
                first = false;
                CommandDto commandDto = result.getCommand();
                commandDto.setLabel(commandDto.getTitle());
                List<String> icons = commandDto.getIconLabels();
                InlayPresentation iconPresentation = null;
                if (icons != null && !icons.isEmpty()) {
                    for (int i = 0; i < icons.size(); ++i) {
                        InlayPresentation singleIcon;
                        String iconLabel = icons.get(i);
                        Icon icon = CodeLensInlayManager.getIconByIconLabelStatic(iconLabel);
                        InlayPresentation inlayPresentation = singleIcon = icon != null ? factory.smallScaledIcon(icon) : null;
                        if (singleIcon == null) continue;
                        iconPresentation = iconPresentation == null ? singleIcon : factory.seq(new InlayPresentation[]{iconPresentation, factory.smallText(" "), singleIcon});
                    }
                }
                InlayPresentation textPresentation = factory.smallText(commandDto.getText());
                InlayPresentation combinedPresentation = iconPresentation != null ? factory.seq(new InlayPresentation[]{iconPresentation, textPresentation}) : textPresentation;
                InlayPresentation cmdPresentation = factory.referenceOnHover(combinedPresentation, (event, translated) -> ExtHostCommands.executeDtoCommand(editor.getProject(), result.getCommand(), object -> {}));
                presentations.add(cmdPresentation);
            }
            return new SequencePresentation(presentations);
        }
        catch (Exception e) {
            LogManager.warn(CodeLensInlayManager.class, "Error creating CodeLens presentation: " + e.getMessage());
            return null;
        }
    }

    private static Icon getIconByIconLabelStatic(String iconLabel) {
        Icon icon = null;
        switch (iconLabel) {
            case "coding-copilot-logo-mini": {
                icon = SdkIcons.COPILOT_ACTIVATE;
                break;
            }
            case "sync~spin": {
                icon = AnimatedIcon.Default.INSTANCE;
            }
        }
        return icon;
    }

    public static int calculateIndentColumn(Editor editor, int line) {
        int offset = editor.getDocument().getLineStartOffset(line);
        int endOffset = editor.getDocument().getLineEndOffset(line);
        String fullLine = editor.getDocument().getText(new TextRange(offset, endOffset));
        int column = 0;
        for (int i = 0; i < fullLine.length(); ++i) {
            char c = fullLine.charAt(i);
            if (c == '\t') {
                column += editor.getSettings().getTabSize(editor.getProject());
                continue;
            }
            if (c != ' ') break;
            ++column;
        }
        return column;
    }

    private static boolean isSameCodeLensList(List<CodeLensResult> a, List<CodeLensResult> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null || a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            CodeLensResult ca = a.get(i);
            CodeLensResult cb = b.get(i);
            if (ca.getCommand().getText().equals(cb.getCommand().getText())) continue;
            return false;
        }
        return true;
    }

    public static void clearAllForEditor(Editor editor) {
        Map<Integer, Inlay<?>> editorInlayMap = inlayMap.remove(editor);
        if (editorInlayMap != null) {
            for (Inlay<?> inlay : editorInlayMap.values()) {
                inlay.dispose();
            }
            editorInlayMap.clear();
        }
        lastCodeLensMap.remove(editor);
    }
}

