/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.languagefeatures;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.apibridge.Decoration.DecorationService;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.CodeLensInlayManager;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.InlineCompletionReconciler;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.codelens.CodeLensResult;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.IdentifiableInlineCompletions;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.InlineCompletionContext;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.InlineCompletionProvider;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.Position;
import com.tencent.code.intel.apibridge.extension.mainthread.context.MainThreadContext;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.apibridge.util.EditorUtils;
import com.tencent.code.intel.apibridge.util.FusionCaretListener;
import com.tencent.code.intel.bean.item.TextSegment;
import com.tencent.code.intel.common.EditorCommandName;
import com.tencent.code.intel.handle.CodeUserInputHandler;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.CopilotEditorUtils;
import com.tencent.code.intel.util.JsonRpcUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ExtHostLanguageFeatures {
    private static final Object $LOCK = new Object[0];
    public static Hashtable<Project, Editor> currentEditors = new Hashtable();
    public static Hashtable<Project, String> remainText = new Hashtable();
    public static Hashtable<Project, JSONObject> currentInlineCompletions = new Hashtable();
    private static List<String> inlineKeys = List.of("inlineSuggestionHasIndentationLessThanTabSize", "inlineSuggestionVisible");
    public static Hashtable<String, List<Consumer<Map<Integer, List<CodeLensResult>>>>> pendingReq = new Hashtable();
    private static List<String> editorKeys = List.of("editorHoverFocused", "editorTabMovesFocus", "suggestWidgetVisible");
    private static final Map<String, Timer> codeLensDebounceTimers = new HashMap<String, Timer>();
    private static final int CODELENS_DEBOUNCE_MS = 300;

    public static void setCompletionHint(Project project, Boolean show) {
        inlineKeys.forEach(key -> MainThreadContext.getInstance(project).getContext().put((String)key, show != false ? "True" : "False"));
        editorKeys.forEach(key -> MainThreadContext.getInstance(project).getContext().put((String)key, show != false ? "False" : "True"));
    }

    public static void provideInlineCompletions(Project project, RPCProtocol rpcChannel, String uri, Position position, Editor editor) {
        ExtHostLanguageFeatures.provideInlineCompletions(project, rpcChannel, uri, position, editor, 0, null);
    }

    public static void provideInlineCompletions(Project project, RPCProtocol rpcChannel, String uri, Position position, Editor editor, int triggerKind, Consumer<Object> complete) {
        InlineCompletionContext context = new InlineCompletionContext();
        context.setTriggerKind(triggerKind);
        Long triggerTime = FusionCaretListener.lastChangeTime.get();
        rpcChannel.sendReq(ExtHostLanguageFeatures.class.getSimpleName(), "$provideInlineCompletions", List.of(uri, position, context), object -> {
            if (complete != null) {
                complete.accept(null);
            }
            ExtHostLanguageFeatures.handleCompletionResponse(project, editor, position, object, triggerTime);
        });
    }

    private static void handleCompletionResponse(Project project, Editor editor, Position position, Object object, Long triggerTime) {
        boolean isSelected = (Boolean)ApplicationManager.getApplication().runReadAction(() -> CopilotEditorUtils.isSelectedEditor(editor));
        if (!isSelected || object == null) {
            return;
        }
        IdentifiableInlineCompletions result = JsonRpcUtils.toJavaObject(object, IdentifiableInlineCompletions.class);
        if (result.getItems().isEmpty()) {
            return;
        }
        IdentifiableInlineCompletions.Item firstItem = result.getItems().get(0);
        String insertText = firstItem.getInsertText();
        InlineCompletionContext.IRange range = firstItem.getRange();
        if (insertText == null || insertText.isEmpty()) {
            return;
        }
        com.tencent.code.intel.bean.item.Position itemPos = new com.tencent.code.intel.bean.item.Position();
        itemPos.setLine(position.getLineNumber() - 1);
        itemPos.setCharacter(position.getColumn());
        ApplicationManager.getApplication().runReadAction(() -> ExtHostLanguageFeatures.processCompletionText(project, editor, itemPos, insertText, range, triggerTime, object));
    }

    private static void processCompletionText(Project project, Editor editor, com.tencent.code.intel.bean.item.Position itemPos, String insertText, InlineCompletionContext.IRange range, Long triggerTime, Object object) {
        String currentLineTextAfter;
        int lineStartOffset = editor.getDocument().getLineStartOffset(itemPos.getLine());
        int caretOffset = editor.getCaretModel().getOffset();
        int lineEndOffset = editor.getDocument().getLineEndOffset(itemPos.getLine());
        int caretColumn = caretOffset - lineStartOffset;
        String currentLineText = editor.getDocument().getText().substring(lineStartOffset, caretOffset);
        List<String> segments = InlineCompletionReconciler.computeRenderSegments(insertText, range, caretColumn, currentLineText, currentLineTextAfter = editor.getDocument().getText().substring(caretOffset, lineEndOffset));
        if (segments.isEmpty()) {
            InlayService.getInstance().disposeAllInlays();
            DecorationService.getInstance(project).disposeAll();
            return;
        }
        ExtHostLanguageFeatures.showCompletionSegments(project, editor, itemPos, segments, currentLineTextAfter, triggerTime, object);
    }

    private static void showCompletionSegments(Project project, Editor editor, com.tencent.code.intel.bean.item.Position itemPos, List<String> segments, String currentLineTextAfter, Long triggerTime, Object object) {
        boolean needMultiSegmentDisplay;
        InlayService.getInstance().disposeAllInlays();
        DecorationService.getInstance(project).disposeAll();
        boolean hasSuffix = currentLineTextAfter != null && !currentLineTextAfter.isEmpty();
        boolean bl = needMultiSegmentDisplay = hasSuffix && segments.size() >= 2;
        if (needMultiSegmentDisplay) {
            ArrayList<TextSegment> textSegments = new ArrayList<TextSegment>();
            com.tencent.code.intel.bean.item.Position firstPos = new com.tencent.code.intel.bean.item.Position();
            firstPos.setLine(itemPos.getLine());
            firstPos.setCharacter(itemPos.getCharacter());
            TextSegment firstSegment = new TextSegment(segments.get(0), firstPos, "First segment at cursor");
            textSegments.add(firstSegment);
            String firstSegmentText = segments.get(0);
            long newlineCount = firstSegmentText.chars().filter(ch -> ch == 10).count();
            com.tencent.code.intel.bean.item.Position secondPos = new com.tencent.code.intel.bean.item.Position();
            if (newlineCount > 0L) {
                secondPos.setLine(itemPos.getLine() + (int)newlineCount);
                int lastNewlineIndex = firstSegmentText.lastIndexOf(10);
                String lastLineOfFirst = firstSegmentText.substring(lastNewlineIndex + 1);
                secondPos.setCharacter(lastLineOfFirst.length() + currentLineTextAfter.length());
            } else {
                secondPos.setLine(itemPos.getLine());
                secondPos.setCharacter(itemPos.getCharacter() + firstSegmentText.length() + currentLineTextAfter.length());
            }
            TextSegment secondSegment = new TextSegment(segments.get(1), secondPos, "Second segment after suffix");
            textSegments.add(secondSegment);
            String source = editor.getDocument().getText();
            InlineCompletionProvider.showMultiSegmentCompletion(editor, source, textSegments, triggerTime);
            StringBuilder combinedText = new StringBuilder();
            for (int i = 0; i < segments.size(); ++i) {
                combinedText.append(segments.get(i));
                if (i >= segments.size() - 1) continue;
                combinedText.append(currentLineTextAfter);
            }
            remainText.put(project, combinedText.toString());
        } else {
            StringBuilder allContentBuilder = new StringBuilder();
            for (int i = 0; i < segments.size(); ++i) {
                allContentBuilder.append(segments.get(i));
            }
            String allContent = allContentBuilder.toString();
            String[] contentLines = allContent.split("\n", -1);
            ArrayList<String> lines = new ArrayList<String>();
            for (String line : contentLines) {
                lines.add(line);
            }
            InlineCompletionProvider.showInlineCompletion(editor, itemPos, itemPos, lines, triggerTime);
            remainText.put(project, allContent);
        }
        currentEditors.put(project, editor);
        currentInlineCompletions.put(project, (JSONObject)object);
    }

    private static void showCompletion(Project project, Editor editor, com.tencent.code.intel.bean.item.Position itemPos, String text, Long triggerTime, Object object) {
        InlayService.getInstance().disposeAllInlays();
        DecorationService.getInstance(project).disposeAll();
        ArrayList<String> lines = new ArrayList<String>(List.of(text.split("\n")));
        InlineCompletionProvider.showInlineCompletion(editor, itemPos, itemPos, lines, triggerTime);
        currentEditors.put(project, editor);
        remainText.put(project, text);
        currentInlineCompletions.put(project, (JSONObject)object);
    }

    public static void onDocumentChanged(Project project, FileEditor fileEditor, String uri, String commandName) {
        Editor editor;
        if (project == null || project.isDisposed() || !(fileEditor instanceof TextEditor)) {
            return;
        }
        if (MainThreadContext.getInstance(project) != null) {
            MainThreadContext.getInstance(project).getContext().put("editorTextFocus", "true");
            MainThreadContext.getInstance(project).getContext().put("editorReadonly", "false");
        }
        if (!CopilotEditorUtils.isSelectedEditor(editor = ((TextEditor)fileEditor).getEditor())) {
            return;
        }
        ExtHostLanguageFeatures.debounceProvideCodeLenses(project, editor, uri, commandName);
        ThreadManager.getInstance().runUiThread(() -> {
            boolean isValidInput;
            PsiFile psiFile = CopilotEditorUtils.getPsiFile(editor);
            if (psiFile == null) {
                return;
            }
            if (CodeUserInputHandler.isIgnoreChange(psiFile)) {
                return;
            }
            int caretOffset = editor.getCaretModel().getPrimaryCaret().getOffset();
            if (!CopilotEditorUtils.isEditorReadWrite(editor, caretOffset)) {
                return;
            }
            boolean bl = isValidInput = !EditorCommandName.isIgnored(commandName);
            if (!isValidInput) {
                LogManager.info(ExtHostLanguageFeatures.class, "on document changed isIgnored commandName:" + commandName);
                return;
            }
            Position position = new Position();
            com.tencent.code.intel.bean.item.Position itemPosition = EditorUtils.position(editor.getDocument(), caretOffset);
            position.setColumn(itemPosition.getCharacter() + 1);
            position.setLineNumber(itemPosition.getLine() + 1);
            ExtHostLanguageFeatures.provideInlineCompletions(project, NodeRunner.getInstance(project).getRpcChannel(), uri, position, editor);
        });
    }

    public static void debounceProvideCodeLenses(final Project project, final Editor editor, final String uri, String commandName) {
        boolean isValidInput;
        String key = project.hashCode() + "_" + (editor != null ? editor.hashCode() : 0);
        Timer oldTimer = codeLensDebounceTimers.get(key);
        if (oldTimer != null) {
            oldTimer.cancel();
        }
        boolean bl = isValidInput = !EditorCommandName.isIgnored(commandName);
        if (!isValidInput) {
            return;
        }
        Timer timer = new Timer();
        codeLensDebounceTimers.put(key, timer);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ThreadManager.getInstance().runUiThread(() -> ExtHostLanguageFeatures.provideCodeLenses(project, editor, uri, null));
            }
        }, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void provideCodeLenses(Project project, Editor editor, String uri, Consumer<Map<Integer, List<CodeLensResult>>> complete) {
        Object object2 = $LOCK;
        synchronized (object2) {
            NodeRunner.getInstance(project).getRpcChannel().sendReq(ExtHostLanguageFeatures.class.getSimpleName(), "$provideCodeLenses", List.of(uri), object -> {
                if (object == null) {
                    return;
                }
                JSONArray lenses = JSONObject.from((Object)object).getJSONArray("lenses");
                List<CodeLensResult> codeLenses = lenses.stream().map(lense -> JsonRpcUtils.toJavaObject(lense, CodeLensResult.class)).collect(Collectors.toList());
                HashMap codeLensMap = new HashMap();
                codeLenses.forEach(codeLens -> {
                    if (codeLens.getCommand().getTitle().equals("Close") || codeLens.getCommand().getTitle().equals("\u5173\u95ed")) {
                        return;
                    }
                    ArrayList<CodeLensResult> codeLensList = (ArrayList<CodeLensResult>)codeLensMap.get(codeLens.getRange().getStartLineNumber());
                    if (codeLensList == null) {
                        codeLensList = new ArrayList<CodeLensResult>();
                    }
                    codeLensList.add((CodeLensResult)codeLens);
                    codeLensMap.put(codeLens.getRange().getStartLineNumber(), codeLensList);
                });
                ThreadManager.getInstance().runDelayUiThreadSave(500, () -> CodeLensInlayManager.renderCodeLens(editor, codeLensMap));
            });
        }
    }

    public static void clear(Project project) {
        currentEditors.remove(project);
        remainText.remove(project);
        currentInlineCompletions.remove(project);
    }

    public static Hashtable<String, List<Consumer<Map<Integer, List<CodeLensResult>>>>> getPendingReq() {
        return pendingReq;
    }
}

