/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.languagefeatures;

import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.InlineCompletionContext;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.manager.LogManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.util.TextUtils;

public final class InlineCompletionReconciler {
    private InlineCompletionReconciler() {
    }

    public static List<String> computeRenderSegments(String insertText, InlineCompletionContext.IRange range, int caretColumn, String currentLineText, String currentLineTextAfter) {
        boolean shouldMerge;
        ArrayList<String> segments = new ArrayList<String>();
        if (range == null || TextUtils.isEmpty((CharSequence)insertText)) {
            Position fallbackPos = new Position();
            fallbackPos.setCharacter(caretColumn + 1);
            String singleSegment = InlineCompletionReconciler.computeRenderText(insertText, currentLineText, currentLineTextAfter, fallbackPos);
            if (!TextUtils.isEmpty((CharSequence)singleSegment)) {
                segments.add(singleSegment);
            }
            return segments;
        }
        String fullCurrentLine = currentLineText + (currentLineTextAfter != null ? currentLineTextAfter : "");
        int rangeStartColumn = range.getStartColumn() - 1;
        int rangeEndColumn = range.getEndColumn() - 1;
        boolean isRangeCoveringFullLine = rangeStartColumn <= 8 && rangeEndColumn >= fullCurrentLine.length() - 1;
        boolean isContentMatching = insertText.trim().equals(fullCurrentLine.trim());
        if (isRangeCoveringFullLine && isContentMatching) {
            return new ArrayList<String>();
        }
        int offsetInInsertText = caretColumn - rangeStartColumn;
        if (offsetInInsertText < 0 || offsetInInsertText >= insertText.length()) {
            Position fallbackPos = new Position();
            fallbackPos.setCharacter(caretColumn + 1);
            String singleSegment = InlineCompletionReconciler.computeRenderText(insertText, currentLineText, currentLineTextAfter, fallbackPos);
            if (!TextUtils.isEmpty((CharSequence)singleSegment)) {
                segments.add(singleSegment);
            }
            return segments;
        }
        String textAfterCaret = insertText.substring(offsetInInsertText);
        String suffix = currentLineTextAfter == null ? "" : currentLineTextAfter;
        String firstSegment = InlineCompletionReconciler.computeFirstSegment(textAfterCaret, suffix);
        String secondSegment = InlineCompletionReconciler.computeSecondSegment(textAfterCaret, suffix, firstSegment);
        boolean bl = shouldMerge = !TextUtils.isEmpty((CharSequence)firstSegment) && !TextUtils.isEmpty((CharSequence)secondSegment) && !secondSegment.contains("\n");
        if (shouldMerge && range != null && caretColumn < rangeEndColumn) {
            shouldMerge = false;
        }
        if (shouldMerge) {
            String mergedSegment = firstSegment + suffix + secondSegment;
            segments.add(mergedSegment);
        } else if (!TextUtils.isEmpty((CharSequence)firstSegment) || !TextUtils.isEmpty((CharSequence)secondSegment)) {
            segments.add(firstSegment);
            if (!TextUtils.isEmpty((CharSequence)secondSegment)) {
                segments.add(secondSegment);
            }
        }
        return segments;
    }

    private static String computeFirstSegment(String textAfterCaret, String suffix) {
        String currentLinePartInInsert;
        if (TextUtils.isEmpty((CharSequence)textAfterCaret)) {
            return "";
        }
        int newlineIndex = textAfterCaret.indexOf(10);
        if (textAfterCaret.startsWith("\n")) {
            int nextNewlineIndex = textAfterCaret.indexOf(10, 1);
            return nextNewlineIndex >= 0 ? textAfterCaret.substring(0, nextNewlineIndex) : textAfterCaret;
        }
        String string = currentLinePartInInsert = newlineIndex >= 0 ? textAfterCaret.substring(0, newlineIndex) : textAfterCaret;
        if (TextUtils.isEmpty((CharSequence)suffix)) {
            return currentLinePartInInsert;
        }
        int suffixIndex = currentLinePartInInsert.indexOf(suffix);
        if (suffixIndex >= 0) {
            return currentLinePartInInsert.substring(0, suffixIndex);
        }
        if (suffix.startsWith(currentLinePartInInsert)) {
            return "";
        }
        int commonPrefixLen = 0;
        int maxLen = Math.min(currentLinePartInInsert.length(), suffix.length());
        for (int i = 0; i < maxLen && currentLinePartInInsert.charAt(i) == suffix.charAt(i); ++i) {
            ++commonPrefixLen;
        }
        if (commonPrefixLen > 0 && commonPrefixLen < maxLen) {
            String suffixAfterExtra;
            String remainingInsert = currentLinePartInInsert.substring(commonPrefixLen);
            String remainingSuffix = suffix.substring(commonPrefixLen);
            int extraChars = remainingSuffix.length() - remainingInsert.length();
            if (extraChars > 0 && extraChars <= 2 && (remainingInsert.equals(suffixAfterExtra = remainingSuffix.substring(extraChars)) || remainingInsert.startsWith(suffixAfterExtra))) {
                return "";
            }
        }
        if (commonPrefixLen > 0 && commonPrefixLen >= currentLinePartInInsert.length() - 1) {
            return "";
        }
        if (commonPrefixLen > 0) {
            return currentLinePartInInsert.substring(commonPrefixLen);
        }
        String result = currentLinePartInInsert;
        if (result.endsWith(suffix.trim())) {
            result = result.substring(0, result.length() - suffix.trim().length());
        }
        return result;
    }

    private static String computeSecondSegment(String textAfterCaret, String suffix, String firstSegment) {
        if (TextUtils.isEmpty((CharSequence)textAfterCaret)) {
            return "";
        }
        int newlineIndex = textAfterCaret.indexOf(10);
        String currentLinePartInInsert = newlineIndex >= 0 ? textAfterCaret.substring(0, newlineIndex) : textAfterCaret;
        boolean suffixCovered = false;
        int suffixEndPosition = -1;
        if (!TextUtils.isEmpty((CharSequence)suffix)) {
            int suffixIndex = currentLinePartInInsert.indexOf(suffix);
            if (suffixIndex >= 0 && firstSegment.length() == suffixIndex) {
                suffixCovered = true;
                suffixEndPosition = suffixIndex + suffix.length();
            }
        } else {
            suffixCovered = true;
            suffixEndPosition = firstSegment.length();
        }
        if (!suffixCovered) {
            return "";
        }
        String secondPart = newlineIndex >= 0 ? (firstSegment.contains("\n") ? (firstSegment.length() < textAfterCaret.length() ? textAfterCaret.substring(firstSegment.length()) : "") : textAfterCaret.substring(newlineIndex)) : (suffixEndPosition < currentLinePartInInsert.length() ? currentLinePartInInsert.substring(suffixEndPosition) : "");
        return secondPart;
    }

    public static String computeRenderText(String insertText, String currentLineText, String currentLineTextAfter, Position itemPos) {
        String currentLower;
        String insertLower;
        int matchPosition;
        String currentWithoutIndent;
        String afterTextTrimmed = currentLineTextAfter == null ? "" : currentLineTextAfter.trim();
        boolean containsAfterText = !afterTextTrimmed.isEmpty() && !TextUtils.isEmpty((CharSequence)insertText) && insertText.endsWith(afterTextTrimmed);
        String string = currentWithoutIndent = currentLineText == null ? "" : currentLineText.replaceFirst("^\\s+", "");
        if (!TextUtils.isEmpty((CharSequence)insertText) && !TextUtils.isEmpty((CharSequence)currentWithoutIndent) && (matchPosition = (insertLower = insertText.toLowerCase()).indexOf(currentLower = currentWithoutIndent.toLowerCase())) >= 0) {
            String result;
            int cut = matchPosition + currentWithoutIndent.length();
            String string2 = result = cut < insertText.length() ? insertText.substring(cut) : "";
            if (containsAfterText && result.endsWith(afterTextTrimmed)) {
                result = result.substring(0, result.length() - afterTextTrimmed.length());
            }
            LogManager.info(InlineCompletionReconciler.class, "Matched prefix (strip-leading-indent), remaining: '" + result + "'");
            return result;
        }
        int from = Math.max(0, Math.min(insertText.length(), itemPos.getCharacter() - 1));
        String result = insertText.substring(from);
        if (containsAfterText && result.endsWith(afterTextTrimmed)) {
            result = result.substring(0, result.length() - afterTextTrimmed.length());
        }
        LogManager.info(InlineCompletionReconciler.class, "Fallback to character-based substring. Result: '" + result + "'");
        return result;
    }

    public static AcceptPlan computeAcceptPlan(String renderText, String textBeforeCaret, String textAfterCaret) {
        int overlap;
        if (!TextUtils.isEmpty((CharSequence)renderText) && !TextUtils.isEmpty((CharSequence)textAfterCaret)) {
            int max = Math.min(renderText.length(), textAfterCaret.length());
            for (overlap = 0; overlap < max && renderText.charAt(overlap) == textAfterCaret.charAt(overlap); ++overlap) {
            }
        }
        return new AcceptPlan(overlap);
    }

    public static final class AcceptPlan {
        public final int deleteAfterCount;

        public AcceptPlan(int deleteAfterCount) {
            this.deleteAfterCount = deleteAfterCount;
        }
    }
}

