/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.apibridge.util.FusionCaretListener;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.TextSegment;
import com.tencent.code.intel.common.InlayAcceptMode;
import com.tencent.code.intel.common.InlayDisplayMode;
import com.tencent.code.intel.impl.GFCopilotService;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.CopilotEditorUtils;
import java.util.List;

public class InlineCompletionProvider {
    public static void showInlineCompletion(Editor editor, Position start, Position end, List<String> content, Long triggerTime) {
        if (triggerTime.longValue() != FusionCaretListener.lastChangeTime.get()) {
            return;
        }
        if (editor == null || editor.isDisposed()) {
            return;
        }
        if (!CopilotEditorUtils.isSelectedEditor(editor)) {
            return;
        }
        ThreadManager.getInstance().runUiThread(() -> {
            Editor focusedEditor = GFCopilotService.getInstance().getEditorIncludeSplit(editor);
            String source = focusedEditor.getDocument().getText();
            int offset = focusedEditor.getDocument().getLineStartOffset(start.getLine()) + start.getCharacter() - 1;
            if (focusedEditor == null || focusedEditor.isDisposed()) {
                return;
            }
            Project project = focusedEditor.getProject();
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                int tabSize = focusedEditor.getSettings().getTabSize(project);
                ExtHostLanguageFeatures.setCompletionHint(project, true);
                InlayDisplayMode inlayDisplayMode = InlayService.getInstance().getInlayDisplayMode(focusedEditor, start.getLine(), content.size());
                InlayService.getInstance().display(focusedEditor, source, offset, content, inlayDisplayMode, InlayAcceptMode.ALL, tabSize, false);
            });
        });
    }

    public static void showMultiSegmentCompletion(Editor editor, String source, List<TextSegment> segments, Long triggerTime) {
        if (triggerTime.longValue() != FusionCaretListener.lastChangeTime.get()) {
            return;
        }
        if (editor == null || editor.isDisposed()) {
            return;
        }
        if (!CopilotEditorUtils.isSelectedEditor(editor)) {
            return;
        }
        ThreadManager.getInstance().runUiThread(() -> {
            Editor focusedEditor = GFCopilotService.getInstance().getEditorIncludeSplit(editor);
            if (focusedEditor == null || focusedEditor.isDisposed()) {
                return;
            }
            Project project = focusedEditor.getProject();
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                int tabSize = focusedEditor.getSettings().getTabSize(project);
                ExtHostLanguageFeatures.setCompletionHint(project, true);
                InlayService.getInstance().displayMultiSegment(focusedEditor, source, segments, InlayAcceptMode.ALL, tabSize, false);
            });
        });
    }
}

