/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.textEditors;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util.DocumentToExtHostDataConverter;
import com.tencent.code.intel.apibridge.extension.extension.textEditors.data.EditorPropertiesChangeData;
import com.tencent.code.intel.apibridge.extension.extension.textEditors.data.TextEditorSelectionChangeKind;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.util.Arrays;
import java.util.List;

public class ExtHostEditors {
    private final RPCProtocol rpcChannel;

    public ExtHostEditors(RPCProtocol rpcChannel) {
        this.rpcChannel = rpcChannel;
    }

    public void selectionModelChanged(Editor editor, TextEditorSelectionChangeKind selectionChangeKind) {
        try {
            Project project = editor.getProject();
            if (project == null || project.isDisposed() || editor.isDisposed()) {
                return;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(editor.getDocument());
            if (virtualFile == null || !virtualFile.isValid()) {
                return;
            }
            FileEditor fileEditor = fileEditorManager.getSelectedEditor(virtualFile);
            ThreadManager.getInstance().runUiThread(() -> {
                SelectionModel selectionModel = editor.getSelectionModel();
                Document document = editor.getDocument();
                int offset = editor.getCaretModel().getOffset();
                int selectionStartLineNumber = document.getLineNumber(offset) + 1;
                int selectionStartColumn = offset - document.getLineStartOffset(selectionStartLineNumber - 1) + 1;
                int positionLineNumber = selectionStartLineNumber;
                int positionColumn = selectionStartColumn;
                if (selectionModel.hasSelection()) {
                    selectionStartLineNumber = editor.getDocument().getLineNumber(selectionModel.getSelectionStart()) + 1;
                    selectionStartColumn = selectionModel.getSelectionStart() - editor.getDocument().getLineStartOffset(selectionStartLineNumber - 1) + 1;
                    positionLineNumber = editor.getDocument().getLineNumber(selectionModel.getSelectionEnd()) + 1;
                    positionColumn = selectionModel.getSelectionEnd() - editor.getDocument().getLineStartOffset(positionLineNumber - 1) + 1;
                }
                EditorPropertiesChangeData editorPropertiesChangeData = EditorPropertiesChangeData.toEditorSelectionChangeData(selectionChangeKind, selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn);
                this.editorPropertiesChanged(fileEditor, editor, editorPropertiesChangeData);
            });
        }
        catch (Exception e) {
            LogManager.warn(ExtHostEditors.class, "selectionModelChanged: " + String.valueOf(e));
        }
    }

    public void editorPropertiesChanged(FileEditor fileEditor, Editor editor, EditorPropertiesChangeData editorPropertiesChangeData) {
        try {
            this.rpcChannel.sendReq(ExtHostEditors.class.getSimpleName(), "$acceptEditorPropertiesChanged", List.of(DocumentToExtHostDataConverter.getEditorId(fileEditor, editor.getDocument()), editorPropertiesChangeData), object -> {});
        }
        catch (Exception e) {
            LogManager.warn(ExtHostEditors.class, "selectionModelChanged: " + String.valueOf(e));
        }
    }

    public void activeTextEditorChanged(String oldEditorPath, String newEditorPath) {
        try {
            this.rpcChannel.sendReq(ExtHostEditors.class.getSimpleName(), "$acceptActiveTextEditorChanged", Arrays.asList(oldEditorPath, newEditorPath), object -> {});
        }
        catch (Exception e) {
            LogManager.warn(ExtHostEditors.class, "activeTextEditorChanged error: " + String.valueOf(e));
        }
    }
}

