/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.textEditors.data;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.tencent.code.intel.apibridge.extension.extension.textEditors.data.TextEditorSelectionChangeKind;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public class EditorPropertiesChangeData {
    private ResolvedTextEditorConfiguration options;
    private SelectionChangeEvent selections;
    private List<Range> visibleRanges;

    public static EditorPropertiesChangeData toEditorSelectionChangeData(TextEditorSelectionChangeKind source, int selectionStartLineNumber, int selectionStartColumn, int positionLineNumber, int positionColumn) {
        EditorPropertiesChangeData editorPropertiesChangeData = new EditorPropertiesChangeData();
        SelectionChangeEvent selectionChangeEvent = new SelectionChangeEvent();
        selectionChangeEvent.setSelections(List.of(new Selection(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn)));
        selectionChangeEvent.setSource(String.valueOf(source.getValue()));
        editorPropertiesChangeData.setSelections(selectionChangeEvent);
        return editorPropertiesChangeData;
    }

    public static EditorPropertiesChangeData toEditorVisibleRangesChangeData(Editor editor) {
        EditorPropertiesChangeData editorPropertiesChangeData = new EditorPropertiesChangeData();
        editorPropertiesChangeData.setVisibleRanges(EditorPropertiesChangeData.getVisibleRanges(editor));
        return editorPropertiesChangeData;
    }

    public static List<Range> getVisibleRanges(Editor editor) {
        if (editor == null || editor.isDisposed()) {
            return List.of();
        }
        Document document = editor.getDocument();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        Rectangle visibleArea = scrollingModel.getVisibleArea();
        int minLine = 1;
        int minCol = 1;
        int maxLine = Math.max(document.getLineCount(), minLine);
        int maxCol = document.getLineCount() > 0 ? document.getLineEndOffset(maxLine - 1) + 1 : minCol;
        LogicalPosition startLogicalPos = editor.xyToLogicalPosition(new Point(visibleArea.x, visibleArea.y));
        LogicalPosition endLogicalPos = editor.xyToLogicalPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
        int startLine = startLogicalPos.line + 1;
        int startCol = startLogicalPos.column + 1;
        int endLine = endLogicalPos.line + 1;
        int endCol = endLogicalPos.column + 1;
        Range[] visibleRanges = new Range[]{new Range(Math.max(startLine, minLine), Math.max(startCol, minCol), Math.min(endLine, maxLine), endCol > maxCol && endLine >= maxLine ? maxCol : endCol)};
        return List.of(visibleRanges);
    }

    public ResolvedTextEditorConfiguration getOptions() {
        return this.options;
    }

    public SelectionChangeEvent getSelections() {
        return this.selections;
    }

    public List<Range> getVisibleRanges() {
        return this.visibleRanges;
    }

    public void setOptions(ResolvedTextEditorConfiguration options) {
        this.options = options;
    }

    public void setSelections(SelectionChangeEvent selections) {
        this.selections = selections;
    }

    public void setVisibleRanges(List<Range> visibleRanges) {
        this.visibleRanges = visibleRanges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditorPropertiesChangeData)) {
            return false;
        }
        EditorPropertiesChangeData other = (EditorPropertiesChangeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResolvedTextEditorConfiguration this$options = this.getOptions();
        ResolvedTextEditorConfiguration other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        SelectionChangeEvent this$selections = this.getSelections();
        SelectionChangeEvent other$selections = other.getSelections();
        if (this$selections == null ? other$selections != null : !((Object)this$selections).equals(other$selections)) {
            return false;
        }
        List<Range> this$visibleRanges = this.getVisibleRanges();
        List<Range> other$visibleRanges = other.getVisibleRanges();
        return !(this$visibleRanges == null ? other$visibleRanges != null : !((Object)this$visibleRanges).equals(other$visibleRanges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditorPropertiesChangeData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResolvedTextEditorConfiguration $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        SelectionChangeEvent $selections = this.getSelections();
        result = result * 59 + ($selections == null ? 43 : ((Object)$selections).hashCode());
        List<Range> $visibleRanges = this.getVisibleRanges();
        result = result * 59 + ($visibleRanges == null ? 43 : ((Object)$visibleRanges).hashCode());
        return result;
    }

    public String toString() {
        return "EditorPropertiesChangeData(options=" + String.valueOf(this.getOptions()) + ", selections=" + String.valueOf(this.getSelections()) + ", visibleRanges=" + String.valueOf(this.getVisibleRanges()) + ")";
    }

    public static class Selection {
        private int selectionStartLineNumber;
        private int selectionStartColumn;
        private int positionLineNumber;
        private int positionColumn;

        public int getSelectionStartLineNumber() {
            return this.selectionStartLineNumber;
        }

        public int getSelectionStartColumn() {
            return this.selectionStartColumn;
        }

        public int getPositionLineNumber() {
            return this.positionLineNumber;
        }

        public int getPositionColumn() {
            return this.positionColumn;
        }

        public void setSelectionStartLineNumber(int selectionStartLineNumber) {
            this.selectionStartLineNumber = selectionStartLineNumber;
        }

        public void setSelectionStartColumn(int selectionStartColumn) {
            this.selectionStartColumn = selectionStartColumn;
        }

        public void setPositionLineNumber(int positionLineNumber) {
            this.positionLineNumber = positionLineNumber;
        }

        public void setPositionColumn(int positionColumn) {
            this.positionColumn = positionColumn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Selection)) {
                return false;
            }
            Selection other = (Selection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSelectionStartLineNumber() != other.getSelectionStartLineNumber()) {
                return false;
            }
            if (this.getSelectionStartColumn() != other.getSelectionStartColumn()) {
                return false;
            }
            if (this.getPositionLineNumber() != other.getPositionLineNumber()) {
                return false;
            }
            return this.getPositionColumn() == other.getPositionColumn();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Selection;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSelectionStartLineNumber();
            result = result * 59 + this.getSelectionStartColumn();
            result = result * 59 + this.getPositionLineNumber();
            result = result * 59 + this.getPositionColumn();
            return result;
        }

        public String toString() {
            return "EditorPropertiesChangeData.Selection(selectionStartLineNumber=" + this.getSelectionStartLineNumber() + ", selectionStartColumn=" + this.getSelectionStartColumn() + ", positionLineNumber=" + this.getPositionLineNumber() + ", positionColumn=" + this.getPositionColumn() + ")";
        }

        public Selection(int selectionStartLineNumber, int selectionStartColumn, int positionLineNumber, int positionColumn) {
            this.selectionStartLineNumber = selectionStartLineNumber;
            this.selectionStartColumn = selectionStartColumn;
            this.positionLineNumber = positionLineNumber;
            this.positionColumn = positionColumn;
        }

        public Selection() {
        }
    }

    public static class Range {
        private int startLineNumber;
        private int startColumn;
        private int endLineNumber;
        private int endColumn;

        public int getStartLineNumber() {
            return this.startLineNumber;
        }

        public int getStartColumn() {
            return this.startColumn;
        }

        public int getEndLineNumber() {
            return this.endLineNumber;
        }

        public int getEndColumn() {
            return this.endColumn;
        }

        public void setStartLineNumber(int startLineNumber) {
            this.startLineNumber = startLineNumber;
        }

        public void setStartColumn(int startColumn) {
            this.startColumn = startColumn;
        }

        public void setEndLineNumber(int endLineNumber) {
            this.endLineNumber = endLineNumber;
        }

        public void setEndColumn(int endColumn) {
            this.endColumn = endColumn;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartLineNumber() != other.getStartLineNumber()) {
                return false;
            }
            if (this.getStartColumn() != other.getStartColumn()) {
                return false;
            }
            if (this.getEndLineNumber() != other.getEndLineNumber()) {
                return false;
            }
            return this.getEndColumn() == other.getEndColumn();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Range;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartLineNumber();
            result = result * 59 + this.getStartColumn();
            result = result * 59 + this.getEndLineNumber();
            result = result * 59 + this.getEndColumn();
            return result;
        }

        public String toString() {
            return "EditorPropertiesChangeData.Range(startLineNumber=" + this.getStartLineNumber() + ", startColumn=" + this.getStartColumn() + ", endLineNumber=" + this.getEndLineNumber() + ", endColumn=" + this.getEndColumn() + ")";
        }

        public Range(int startLineNumber, int startColumn, int endLineNumber, int endColumn) {
            this.startLineNumber = startLineNumber;
            this.startColumn = startColumn;
            this.endLineNumber = endLineNumber;
            this.endColumn = endColumn;
        }

        public Range() {
        }
    }

    public static class SelectionChangeEvent {
        private List<Selection> selections;
        private String source;

        public List<Selection> getSelections() {
            return this.selections;
        }

        public String getSource() {
            return this.source;
        }

        public void setSelections(List<Selection> selections) {
            this.selections = selections;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SelectionChangeEvent)) {
                return false;
            }
            SelectionChangeEvent other = (SelectionChangeEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Selection> this$selections = this.getSelections();
            List<Selection> other$selections = other.getSelections();
            if (this$selections == null ? other$selections != null : !((Object)this$selections).equals(other$selections)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            return !(this$source == null ? other$source != null : !this$source.equals(other$source));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SelectionChangeEvent;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Selection> $selections = this.getSelections();
            result = result * 59 + ($selections == null ? 43 : ((Object)$selections).hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            return result;
        }

        public String toString() {
            return "EditorPropertiesChangeData.SelectionChangeEvent(selections=" + String.valueOf(this.getSelections()) + ", source=" + this.getSource() + ")";
        }
    }

    public static class ResolvedTextEditorConfiguration {
        private int tabSize;
        private int indentSize;
        private Object originalIndentSize;
        private boolean insertSpaces;

        public int getTabSize() {
            return this.tabSize;
        }

        public int getIndentSize() {
            return this.indentSize;
        }

        public Object getOriginalIndentSize() {
            return this.originalIndentSize;
        }

        public boolean isInsertSpaces() {
            return this.insertSpaces;
        }

        public void setTabSize(int tabSize) {
            this.tabSize = tabSize;
        }

        public void setIndentSize(int indentSize) {
            this.indentSize = indentSize;
        }

        public void setOriginalIndentSize(Object originalIndentSize) {
            this.originalIndentSize = originalIndentSize;
        }

        public void setInsertSpaces(boolean insertSpaces) {
            this.insertSpaces = insertSpaces;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResolvedTextEditorConfiguration)) {
                return false;
            }
            ResolvedTextEditorConfiguration other = (ResolvedTextEditorConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTabSize() != other.getTabSize()) {
                return false;
            }
            if (this.getIndentSize() != other.getIndentSize()) {
                return false;
            }
            if (this.isInsertSpaces() != other.isInsertSpaces()) {
                return false;
            }
            Object this$originalIndentSize = this.getOriginalIndentSize();
            Object other$originalIndentSize = other.getOriginalIndentSize();
            return !(this$originalIndentSize == null ? other$originalIndentSize != null : !this$originalIndentSize.equals(other$originalIndentSize));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResolvedTextEditorConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTabSize();
            result = result * 59 + this.getIndentSize();
            result = result * 59 + (this.isInsertSpaces() ? 79 : 97);
            Object $originalIndentSize = this.getOriginalIndentSize();
            result = result * 59 + ($originalIndentSize == null ? 43 : $originalIndentSize.hashCode());
            return result;
        }

        public String toString() {
            return "EditorPropertiesChangeData.ResolvedTextEditorConfiguration(tabSize=" + this.getTabSize() + ", indentSize=" + this.getIndentSize() + ", originalIndentSize=" + String.valueOf(this.getOriginalIndentSize()) + ", insertSpaces=" + this.isInsertSpaces() + ")";
        }
    }
}

