/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.window;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LogManager;
import java.util.List;

public class ExtHostWindow {
    private final RPCProtocol rpcChannel;

    public ExtHostWindow(RPCProtocol rpcChannel) {
        this.rpcChannel = rpcChannel;
    }

    public void focusChanged(boolean focused) {
        try {
            this.rpcChannel.sendReq(ExtHostWindow.class.getSimpleName(), "$onDidChangeWindowFocus", List.of(Boolean.valueOf(focused)), object -> {});
        }
        catch (Exception e) {
            LogManager.warn(ExtHostWindow.class, "focusChanged error: " + String.valueOf(e));
        }
    }

    public static void onDidChangeWindowFocus(Project project, boolean focused) {
        try {
            NodeRunner nodeRunner;
            if (!focused) {
                InlayService.getInstance().disposeAllInlays();
            }
            if ((nodeRunner = NodeRunner.getInstance(project)) != null && nodeRunner.getWindow() != null) {
                nodeRunner.getWindow().focusChanged(focused);
            }
        }
        catch (Exception e) {
            LogManager.warn(ExtHostWindow.class, "onDidChangeWindowFocus error: " + String.valueOf(e));
        }
    }
}

