/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.extension.workspace;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.extension.workspace.WorkspaceFolder;
import com.tencent.code.intel.apibridge.extension.extension.workspace.WorkspaceFolderData;
import com.tencent.code.intel.apibridge.rpcprotocol.RPCProtocol;
import com.tencent.code.intel.manager.ThreadManager;
import java.io.File;
import java.nio.file.Path;
import java.util.List;

public class ExtHostWorkspace {
    public static void initializeWorkspace(Project project, RPCProtocol rpcChannel) {
        ThreadManager.getInstance().runUiThreadSave(() -> {
            String path = ExtHostWorkspace.getWorkspacePath(project);
            rpcChannel.sendReq(ExtHostWorkspace.class.getSimpleName(), "$initializeWorkspace", List.of(new WorkspaceFolderData(List.of(new WorkspaceFolder(Path.of(path, new String[0]).toUri().toString().replaceAll("/$", ""), project.getName(), 0))), ExtHostWorkspace.checkProjectTrusted(project)), result -> {});
        });
    }

    private static Boolean checkProjectTrusted(Project project) {
        try {
            if (project == null || project.isDisposed()) {
                return false;
            }
            String basePath = ExtHostWorkspace.getWorkspacePath(project);
            if (basePath == null) {
                return false;
            }
            return new File(String.format("%s/.idea/trusted.xml", basePath)).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getWorkspacePath(Project project) {
        return project.getBasePath();
    }
}

