/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.clipboard;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.manager.LogManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadClipboard
extends MainThreadBaseProxy {
    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$readText": {
                this.handleReadText(complete);
                break;
            }
            case "$writeText": {
                this.handleWriteText(args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void handleReadText(Consumer<Object> complete) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            if (contents != null) {
                complete.accept(contents.getTransferData(DataFlavor.stringFlavor));
            } else {
                complete.accept(null);
            }
        }
        catch (Exception e) {
            LogManager.warn(MainThreadClipboard.class, "handleReadText error:" + String.valueOf(e));
            complete.accept(null);
        }
    }

    private void handleWriteText(List<Object> args, Consumer<Object> complete) {
        if (args.isEmpty()) {
            LogManager.warn(MainThreadClipboard.class, "handleReadText error: args is empty");
            complete.accept(null);
            return;
        }
        StringSelection selection = new StringSelection(args.get(0).toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, null);
        complete.accept(null);
    }
}

