/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.command;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.data.UriComponents;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadCommandImplementService
extends MainThreadBaseProxy {
    public static final Key<VirtualFile> DIFF_VIRTUAL_FILE_KEY = Key.create((String)"diffVirtualFile");
    public static final Key<UriComponents> DIFF_ORIGINAL_URI_KEY = Key.create((String)"diffOriginalUri");
    public static final Key<UriComponents> DIFF_MODIFIED_URI_KEY = Key.create((String)"diffModifiedUri");
    private static volatile ChainDiffVirtualFile lastOpenedDiffFile;

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$openDiffEditor": {
                ThreadManager.getInstance().runUiThread(() -> this.handleOpenDiffEditor(project, args, complete));
                break;
            }
            case "$openChangesView": {
                ThreadManager.getInstance().runUiThread(() -> this.handleOpenChangesView(project, args, complete));
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private String getContentFromUri(Project project, JSONObject uriObj) {
        if ("file".equalsIgnoreCase(uriObj.getString("scheme"))) {
            Document document;
            String path = uriObj.getString("path");
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
                return document.getText();
            }
        }
        try {
            byte[] bytes = Base64.getDecoder().decode(uriObj.getString("query"));
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    private void handleOpenDiffEditor(Project project, List<Object> args, Consumer<Object> complete) {
        VirtualFile[] openFiles;
        if (args.size() < 2) {
            LogManager.warn(MainThreadCommandImplementService.class, "handleOpenDiffEditor args less than 2");
            complete.accept(false);
            return;
        }
        JSONArray jsonArray = JSONArray.parse((String)args.get(0).toString(), (JSONReader.Feature[])new JSONReader.Feature[0]);
        if (jsonArray.size() < 3) {
            LogManager.warn(MainThreadCommandImplementService.class, "handleOpenDiffEditor jsonArray size less than 3");
            complete.accept(false);
            return;
        }
        JSONObject originalUri = jsonArray.getJSONObject(0);
        JSONObject modifiedUri = jsonArray.getJSONObject(1);
        String origContent = this.getContentFromUri(project, originalUri);
        String rightContent = this.getContentFromUri(project, modifiedUri);
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        DocumentContent leftContent = contentFactory.create(project, origContent);
        DocumentContent rightDiffContent = contentFactory.create(project, rightContent);
        SimpleDiffRequest request = new SimpleDiffRequest(jsonArray.get(2).toString(), (DiffContent)leftContent, (DiffContent)rightDiffContent, "left", "right");
        SimpleDiffRequestChain chain = new SimpleDiffRequestChain((DiffRequest)request);
        String path = modifiedUri.getString("path");
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        ChainDiffVirtualFile file = new ChainDiffVirtualFile((DiffRequestChain)chain, jsonArray.get(2).toString());
        file.putUserData(DIFF_VIRTUAL_FILE_KEY, (Object)virtualFile);
        file.putUserData(DIFF_ORIGINAL_URI_KEY, (Object)((UriComponents)JSONObject.parseObject((String)originalUri.toJSONString(new JSONWriter.Feature[0]), UriComponents.class)));
        file.putUserData(DIFF_MODIFIED_URI_KEY, (Object)((UriComponents)JSONObject.parseObject((String)modifiedUri.toJSONString(new JSONWriter.Feature[0]), UriComponents.class)));
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (lastOpenedDiffFile != null) {
            try {
                VirtualFile[] openFiles2;
                for (VirtualFile openFile : openFiles2 = fileEditorManager.getOpenFiles()) {
                    if (openFile != lastOpenedDiffFile) continue;
                    fileEditorManager.closeFile(openFile);
                    break;
                }
            }
            catch (Exception e) {
                LogManager.warn(MainThreadCommandImplementService.class, "close previous diff failed: " + e.getMessage());
            }
        }
        String diffTitle = jsonArray.get(2).toString();
        for (VirtualFile openFile : openFiles = fileEditorManager.getOpenFiles()) {
            if (!(openFile instanceof ChainDiffVirtualFile) || !diffTitle.equals(openFile.getName())) continue;
            fileEditorManager.closeFile(openFile);
            break;
        }
        fileEditorManager.openFile((VirtualFile)file, false);
        lastOpenedDiffFile = file;
        complete.accept(true);
    }

    private void handleOpenChangesView(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 2) {
            LogManager.warn(MainThreadCommandImplementService.class, "handleOpenChangesView args less than 2");
            complete.accept(false);
            return;
        }
        JSONArray resourcesArray = JSONArray.parse((String)args.get(0).toString(), (JSONReader.Feature[])new JSONReader.Feature[0]);
        String title = args.get(1).toString();
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        ArrayList<SimpleDiffRequest> requests = new ArrayList<SimpleDiffRequest>();
        for (int i = 0; i < resourcesArray.size(); ++i) {
            JSONArray item = resourcesArray.getJSONArray(i);
            if (item.size() < 3) continue;
            String labelPath = ((JSONObject)item.get(0)).getString("path");
            String label = labelPath != null && !labelPath.isEmpty() ? (labelPath.lastIndexOf(47) >= 0 ? labelPath.substring(labelPath.lastIndexOf(47) + 1) : labelPath) : "";
            JSONObject originalUri = item.getJSONObject(1);
            JSONObject modifiedUri = item.getJSONObject(2);
            String leftContent = this.getContentFromUri(project, originalUri);
            String rightContent = this.getContentFromUri(project, modifiedUri);
            DocumentContent left = contentFactory.create(project, leftContent);
            DocumentContent right = contentFactory.create(project, rightContent);
            SimpleDiffRequest request = new SimpleDiffRequest(label, (DiffContent)left, (DiffContent)right, "left", "right");
            requests.add(request);
        }
        if (requests.isEmpty()) {
            LogManager.warn(MainThreadCommandImplementService.class, "handleOpenChangesView no valid diff requests");
            complete.accept(false);
            return;
        }
        SimpleDiffRequestChain chain = new SimpleDiffRequestChain(requests);
        String displayTitle = String.format("%s (%d files)", title, resourcesArray.size());
        ChainDiffVirtualFile file = new ChainDiffVirtualFile((DiffRequestChain)chain, displayTitle);
        FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file, false);
        complete.accept(true);
    }
}

