/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.command;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.impl.ui.KeymapPanel;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.util.UpdatePluginTask;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.manager.code.completion.CompletionItemsProviderV2;
import com.tencent.code.intel.settings.ApplicationConfigurable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;

public class MainThreadCommands
extends MainThreadBaseProxy {
    private final String EXECUTE_COMMAND = "$executeCommand";
    private final String GET_COMMANDS = "$getCommands";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$executeCommand": {
                List commandArgs = args.get(1) instanceof List ? (List)args.get(1) : null;
                this.executeCommand(project, args.get(0).toString(), commandArgs, complete);
                break;
            }
            case "$getCommands": {
                complete.accept(List.of("workbench.action.openSettings", "workbench.action.openGlobalKeybindings"));
                break;
            }
            default: {
                complete.accept(null);
            }
        }
    }

    private void executeCommand(Project project, String command, List<Object> args, Consumer<Object> complete) {
        try {
            switch (command) {
                case "workbench.action.openSettings": {
                    ThreadManager.getInstance().runUiThread(() -> ShowSettingsUtil.getInstance().showSettingsDialog(project, ApplicationConfigurable.class));
                    complete.accept(true);
                    break;
                }
                case "workbench.action.openGlobalKeybindings": {
                    ThreadManager.getInstance().runUiThreadSave(() -> ShowSettingsUtil.getInstance().showSettingsDialog(project, KeymapPanel.class));
                    complete.accept(true);
                    break;
                }
                case "workbench.extensions.installExtension": {
                    UpdatePluginTask task = new UpdatePluginTask(((JSONObject)args.get(0)).getString("path"), result -> {
                        if (result == null) {
                            complete.accept(false);
                            return;
                        }
                        complete.accept(Boolean.valueOf(result));
                    });
                    task.queue();
                    break;
                }
                case "workbench.action.reloadWindow": {
                    ApplicationManager.getApplication().restart();
                    complete.accept(true);
                    break;
                }
                case "_workbench.open": {
                    Object virtualFile;
                    JSONObject uriObject = (JSONObject)args.get(0);
                    String uriString = uriObject.getString("external");
                    if (uriString != null) {
                        URI uri = URI.create(uriString);
                        virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(uri.getPath());
                    } else {
                        String path;
                        virtualFile = "file".equalsIgnoreCase(uriObject.getString("scheme")) ? ((path = uriObject.getString("path")) != null ? LocalFileSystem.getInstance().findFileByPath(path) : null) : null;
                    }
                    JSONObject rangeObject = args.get(1) instanceof JSONArray ? (JSONObject)((JSONArray)args.get(1)).get(1) : (JSONObject)args.get(1);
                    ThreadManager.getInstance().runUiThread(() -> this.lambda$executeCommand$3(project, (VirtualFile)virtualFile, rangeObject));
                    complete.accept(true);
                    break;
                }
                case "workbench.action.closeAllEditors": {
                    ThreadManager.getInstance().runUiThread(() -> {
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                        for (VirtualFile file : fileEditorManager.getOpenFiles()) {
                            fileEditorManager.closeFile(file);
                        }
                    });
                    complete.accept(true);
                    break;
                }
                case "workbench.action.closeActiveEditor": {
                    ThreadManager.getInstance().runUiThread(() -> {
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                        VirtualFile[] selectedFiles = fileEditorManager.getSelectedFiles();
                        if (selectedFiles.length > 0) {
                            fileEditorManager.closeFile(selectedFiles[0]);
                        }
                    });
                    complete.accept(true);
                    break;
                }
                case "workbench.action.terminal.selectAll": {
                    complete.accept(true);
                    break;
                }
                case "workbench.action.terminal.copySelection": {
                    ThreadManager.getInstance().runUiThread(() -> {
                        String selectedText;
                        ShellTerminalWidget widget = this.getActiveTerminalWidget(project);
                        if (widget != null && (selectedText = widget.getTerminalTextBuffer().getScreenLines()) != null) {
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            clipboard.setContents(new StringSelection(selectedText), null);
                        }
                        complete.accept(true);
                    });
                    break;
                }
                case "workbench.action.terminal.clearSelection": {
                    complete.accept(true);
                    break;
                }
                case "editor.action.formatSelection": {
                    this.formatSelection(project);
                    complete.accept(null);
                    break;
                }
                case "vscode.executeCompletionItemProvider": {
                    JSONObject uriObject = (JSONObject)args.get(0);
                    JSONObject positionObject = (JSONObject)args.get(1);
                    String triggerCharacter = args.size() > 2 && args.get(2) != null ? args.get(2).toString() : null;
                    Integer itemResolveCount = args.size() > 3 && args.get(3) != null ? (Integer)args.get(3) : 20;
                    LogManager.info(MainThreadCommands.class, "[MainThreadCommands] Starting completion request for: " + uriObject.getString("path"));
                    CompletionItemsProviderV2 provider = new CompletionItemsProviderV2(project);
                    provider.getCompletionItems(uriObject.getString("path"), positionObject.getInteger("line"), positionObject.getInteger("character"), triggerCharacter, itemResolveCount, result -> {
                        LogManager.info(MainThreadCommands.class, "[MainThreadCommands] Received result from CompletionItemsProvider: " + (result != null ? result.getClass().getSimpleName() : "null"));
                        complete.accept(result);
                    });
                    break;
                }
                default: {
                    LogManager.info(MainThreadCommands.class, "command not found: " + command);
                    complete.accept(false);
                    break;
                }
            }
        }
        catch (Exception e) {
            LogManager.warn(MainThreadCommands.class, "executeCommand error: " + e.getMessage());
        }
    }

    private ShellTerminalWidget getActiveTerminalWidget(Project project) {
        ToolWindow terminalToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
        if (terminalToolWindow == null) {
            return null;
        }
        Content selectedContent = terminalToolWindow.getContentManager().getSelectedContent();
        if (selectedContent == null) {
            return null;
        }
        JComponent component = selectedContent.getComponent();
        ShellTerminalWidget found = this.findShellTerminalWidget(component);
        if (found != null) {
            return found;
        }
        return null;
    }

    private ShellTerminalWidget findShellTerminalWidget(Component comp) {
        if (comp instanceof ShellTerminalWidget) {
            return (ShellTerminalWidget)comp;
        }
        if (comp instanceof Container) {
            for (Component child : ((Container)comp).getComponents()) {
                ShellTerminalWidget result = this.findShellTerminalWidget(child);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void openFileWithSelection(Project project, VirtualFile virtualFile, JSONObject rangeObject) {
        if (virtualFile == null) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile);
        if (rangeObject != null && rangeObject.getJSONObject("selection") != null) {
            JSONObject selection = rangeObject.getJSONObject("selection");
            int startLineNumber = selection.getInteger("startLineNumber");
            int startColumn = selection.getInteger("startColumn");
            int endLineNumber = selection.getInteger("endLineNumber");
            int endColumn = selection.getInteger("endColumn");
            openFileDescriptor = new OpenFileDescriptor(project, virtualFile, startLineNumber - 1, startColumn - 1);
            Editor editor = fileEditorManager.openTextEditor(openFileDescriptor, true);
            if (editor != null) {
                int startOffset = editor.getDocument().getLineStartOffset(startLineNumber - 1) + startColumn - 1;
                int endOffset = editor.getDocument().getLineStartOffset(endLineNumber - 1) + endColumn - 1;
                SelectionModel selectionModel = editor.getSelectionModel();
                selectionModel.setSelection(startOffset, endOffset);
                editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            }
        } else {
            fileEditorManager.openTextEditor(openFileDescriptor, true);
        }
    }

    private void formatSelection(Project project) {
        ThreadManager.getInstance().runUiThread(() -> {
            try {
                PsiFile psiFile;
                int end;
                SelectionModel selectionModel;
                int start;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                Editor editor = fileEditorManager.getSelectedTextEditor();
                if (editor != null && (start = (selectionModel = editor.getSelectionModel()).getSelectionStart()) != (end = selectionModel.getSelectionEnd()) && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) != null) {
                    TextRange range = new TextRange(start, end);
                    ReformatCodeProcessor processor = new ReformatCodeProcessor(project, psiFile, range, false);
                    processor.run();
                }
            }
            catch (Exception e) {
                LogManager.warn(MainThreadCommands.class, "formatSelection error: " + e.getMessage());
            }
        });
    }

    private /* synthetic */ void lambda$executeCommand$3(Project project, VirtualFile virtualFile, JSONObject rangeObject) {
        this.openFileWithSelection(project, virtualFile, rangeObject);
    }
}

