/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.comments;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.bean.item.CodeReviewComment;
import com.tencent.code.intel.bean.item.CodeReviewFunction;
import com.tencent.code.intel.bean.item.CodeReviewResult;
import com.tencent.code.intel.bean.item.CodeReviewTask;
import com.tencent.code.intel.bean.request.Rpc.cr.CodeReviewTriggerResultRpcRequest;
import com.tencent.code.intel.impl.CodeReviewCommentInLayService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.sidebar.conversation.chat.store.AICRCommentsPersistState;
import com.tencent.code.intel.util.FileUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MainThreadComments
extends MainThreadBaseProxy {
    private static final String CREATE_COMMENT_THREAD = "$createCommentThread";
    private static final String REGISTER_COMMENT_CONTROLLER = "$registerCommentController";
    private static final String UPDATE_COMMENT_THREAD = "$updateCommentThread";
    private static final String DELETE_COMMENT_THREAD = "$deleteCommentThread";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$createCommentThread": {
                this.createCommentThread(project, args, complete);
                break;
            }
            case "$registerCommentController": {
                this.registerCommentController(project, args, complete);
                break;
            }
            case "$updateCommentThread": {
                this.updateCommentThread(project, args, complete);
                break;
            }
            case "$deleteCommentThread": {
                this.deleteCommentThread(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    void createCommentThread(Project project, List<Object> args, Consumer<Object> complete) {
        ThreadManager.getInstance().runUiThread(() -> {
            CodeReviewComment comment = this.generateComment(project, args);
            AICRCommentsPersistState.getInstance().addComment(comment);
            if (comment.getEditor() != null) {
                List<CodeReviewComment> currentFileComments = AICRCommentsPersistState.getInstance().getCommentsByFilePath(comment.getFunction().getFilePath());
                CodeReviewCommentInLayService.getInstance().initGutterAndOpenInlay(currentFileComments, comment.getEditor(), comment);
            }
        });
        super.handleReq(project, CREATE_COMMENT_THREAD, args, complete);
    }

    void updateCommentThread(Project project, List<Object> args, Consumer<Object> complete) {
        super.handleReq(project, UPDATE_COMMENT_THREAD, args, complete);
    }

    void deleteCommentThread(Project project, List<Object> args, Consumer<Object> complete) {
        ThreadManager.getInstance().runUiThread(() -> {
            CodeReviewCommentInLayService.getInstance().ignoreAllComments();
            AICRCommentsPersistState.getInstance().clearAllComments();
        });
        super.handleReq(project, DELETE_COMMENT_THREAD, args, complete);
    }

    void registerCommentController(Project project, List<Object> args, Consumer<Object> complete) {
        int handleId = (Integer)args.get(0);
        int commentThreadId = (Integer)args.get(1);
        LogManager.info(MainThreadComments.class, "register comment controller[" + handleId + ":" + commentThreadId + "]");
        super.handleReq(project, REGISTER_COMMENT_CONTROLLER, args, complete);
    }

    private CodeReviewComment generateComment(Project project, List<Object> args) {
        int handleId = (Integer)args.get(1);
        String filePath = (String)((JSONObject)args.get(3)).get("path");
        JSONObject positionObj = (JSONObject)args.get(4);
        String content = (String)((JSONObject)((JSONObject)((JSONArray)args.get(5)).get(0)).get("body")).get("value");
        CodeReviewResult result = new CodeReviewResult();
        result.setStartLine(positionObj.getInteger("startLineNumber"));
        result.setEndLine(positionObj.getInteger("endLineNumber"));
        result.setStartColumn(positionObj.getInteger("startColumn"));
        result.setEndColumn(positionObj.getInteger("endColumn"));
        result.setContent(content);
        VirtualFile file = FileUtils.findFileByPath(project, filePath);
        CodeReviewFunction function = new CodeReviewFunction(file.getUrl());
        CodeReviewTask task = new CodeReviewTask("", "");
        CodeReviewComment comment = new CodeReviewComment(function, task, result);
        comment.setId(String.valueOf(handleId));
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        comment.setTriggerChannel(CodeReviewTriggerResultRpcRequest.TriggerChannel.TAB_FILES);
        List editors = Arrays.stream(fileEditorManager.getAllEditors()).filter(editor -> editor instanceof TextEditor).map(editor -> ((TextEditor)editor).getEditor()).collect(Collectors.toList());
        for (Editor editor2 : editors) {
            EditorImpl editorImpl;
            if (!(editor2 instanceof EditorImpl) || !(editorImpl = (EditorImpl)editor2).getVirtualFile().getUrl().equals(function.getFilePath())) continue;
            comment.setEditor(editor2);
        }
        return comment;
    }
}

