/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.configuration;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.configuration.SettingService;
import com.tencent.code.intel.apibridge.configuration.item.ConfigurationBaseItem;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.util.JsonRpcUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MainThreadConfiguration
extends MainThreadBaseProxy {
    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$updateConfigurationOption": {
                this.updateConfigurationOption(project, args.get(1).toString(), args.get(2));
                complete.accept(null);
                break;
            }
            case "$removeConfigurationOption": {
                this.updateConfigurationOption(project, args.get(1).toString(), null);
                complete.accept(null);
                break;
            }
            case "$initExtensionConfiguration": {
                this.initExtConfig(args);
                complete.accept(null);
            }
        }
    }

    private void initExtConfig(List<Object> args) {
        try {
            JSONObject config = JSONObject.from((Object)args.get(0));
            List<ConfigurationBaseItem> items = config.entrySet().stream().map(entry -> {
                ConfigurationBaseItem item = JsonRpcUtils.toJavaObject(entry.getValue(), ConfigurationBaseItem.class);
                item.setSettingKey((String)entry.getKey());
                return item;
            }).collect(Collectors.toList());
            SettingService.getInstance().update(items);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateConfigurationOption(Project project, String key, Object value) {
        CopilotSettingsService.getInstance().updateKey(key, value);
        JSONObject settingContent = SettingService.getInstance().getSettingContent();
        List<String> keys = List.of(key.split("\\."));
        JSONObject filed = settingContent;
        for (int i = 0; i < keys.size(); ++i) {
            if (i != keys.size() - 1) {
                filed = settingContent.getJSONObject(keys.get(i));
                continue;
            }
            if (value != null) {
                filed.put((Object)keys.get(i), value);
                continue;
            }
            filed.remove((Object)keys.get(i));
        }
        SettingService.getInstance().setSettingContent(settingContent);
    }
}

