/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.dialogs;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class MainThreadDialogs
extends MainThreadBaseProxy {
    private static final String SHOW_SAVE_DIALOG = "$showSaveDialog";
    private static final String SHOW_OPEN_DIALOG = "$showOpenDialog";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$showOpenDialog": {
                ThreadManager.getInstance().runUiThread(() -> this.showOpenDialog(project, args, complete));
                break;
            }
            case "$showSaveDialog": {
                ThreadManager.getInstance().runUiThread(() -> this.showSaveDialog(project, args, complete));
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void showOpenDialog(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            VirtualFile[] chosen;
            if (args.isEmpty() || !(args.get(0) instanceof Map)) {
                LogManager.error(MainThreadDialogs.class, "Expected options object as first argument");
            }
            Map options = (Map)args.get(0);
            boolean canSelectFiles = options.getOrDefault("canSelectFiles", true);
            boolean canSelectFolders = options.getOrDefault("canSelectFolders", false);
            boolean canSelectMany = options.getOrDefault("canSelectMany", false);
            Map filters = options.getOrDefault("filters", new HashMap());
            HashSet<String> allowedExts = new HashSet<String>();
            for (List exts : filters.values()) {
                for (String ext : exts) {
                    String e;
                    if (ext == null || (e = ext.startsWith(".") ? ext.substring(1) : ext).isEmpty()) continue;
                    allowedExts.add(e.toLowerCase());
                }
            }
            String initialDirPath = null;
            Object uriObj = options.get("defaultUri");
            if (uriObj != null) {
                if (uriObj instanceof Map) {
                    Map uriMap = (Map)uriObj;
                    String path = (String)uriMap.get("path");
                    if (path != null && !path.isEmpty()) {
                        Path p = Paths.get(path = this.normalizePath(path), new String[0]);
                        initialDirPath = p.toFile().isDirectory() ? p.toString() : (p.getParent() != null ? p.getParent().toString() : null);
                    }
                } else {
                    String path = this.normalizePath(uriObj.toString());
                    Path p = Paths.get(path, new String[0]);
                    initialDirPath = p.toFile().isDirectory() ? p.toString() : (p.getParent() != null ? p.getParent().toString() : null);
                }
            }
            String openLabel = options.getOrDefault("openLabel", "Open");
            FileChooserDescriptor descriptor = new FileChooserDescriptor(canSelectFiles, canSelectFolders, false, false, false, canSelectMany);
            descriptor.setTitle(openLabel);
            if (!allowedExts.isEmpty()) {
                descriptor = descriptor.withFileFilter(vf -> {
                    if (vf.isDirectory()) {
                        return canSelectFolders;
                    }
                    String ext = vf.getExtension();
                    return ext != null && allowedExts.contains(ext.toLowerCase());
                });
            }
            VirtualFile initialDir = null;
            if (initialDirPath != null && !initialDirPath.isEmpty()) {
                initialDir = LocalFileSystem.getInstance().findFileByPath(initialDirPath);
            }
            if ((chosen = FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, initialDir)) != null && chosen.length > 0) {
                ArrayList result = new ArrayList(chosen.length);
                for (VirtualFile vf2 : chosen) {
                    String path = vf2.getPath();
                    File file = new File(path);
                    String fileUri = this.normalizeFileUri(file.toURI().toString());
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("fsPath", file.getAbsolutePath());
                    item.put("external", fileUri);
                    item.put("path", file.getAbsolutePath());
                    item.put("scheme", "file");
                    result.add(item);
                }
                complete.accept(result);
            } else {
                complete.accept(null);
            }
        }
        catch (Exception e) {
            LogManager.error(MainThreadDialogs.class, e.getMessage());
            complete.accept(null);
        }
    }

    private void showSaveDialog(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            VirtualFileWrapper result;
            if (args.isEmpty() || !(args.get(0) instanceof Map)) {
                throw new IllegalArgumentException("Expected options object as first argument");
            }
            Map options = (Map)args.get(0);
            Map filters = options.getOrDefault("filters", new HashMap());
            String[] extensions = (String[])filters.values().stream().flatMap(Collection::stream).map(ext -> ext.startsWith(".") ? ext.substring(1) : ext).toArray(String[]::new);
            String defaultFileName = "untitled";
            String initialDirPath = null;
            Object uriObj = options.get("defaultUri");
            if (uriObj != null) {
                if (uriObj instanceof Map) {
                    Map uriMap = (Map)uriObj;
                    String path = (String)uriMap.get("path");
                    if (path != null && !path.isEmpty()) {
                        path = this.normalizePath(path);
                        Path filePath = Paths.get(path, new String[0]);
                        defaultFileName = filePath.getFileName().toString();
                        initialDirPath = filePath.getParent() != null ? filePath.getParent().toString() : null;
                    }
                } else {
                    String path = this.normalizePath(uriObj.toString());
                    Path filePath = Paths.get(path, new String[0]);
                    defaultFileName = filePath.getFileName().toString();
                    initialDirPath = filePath.getParent() != null ? filePath.getParent().toString() : null;
                }
            }
            String saveLabel = options.getOrDefault("saveLabel", "Save");
            FileSaverDescriptor descriptor = new FileSaverDescriptor(saveLabel, "\u9009\u62e9\u4fdd\u5b58\u4f4d\u7f6e", extensions);
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            VirtualFile initialDir = null;
            if (initialDirPath != null && !initialDirPath.isEmpty()) {
                initialDir = LocalFileSystem.getInstance().findFileByPath(initialDirPath);
            }
            if ((result = dialog.save(initialDir, defaultFileName)) != null) {
                File file = result.getFile();
                String fileUri = this.normalizeFileUri(file.toURI().toString());
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("fsPath", file.getAbsolutePath());
                resultMap.put("external", fileUri);
                resultMap.put("scheme", "file");
                complete.accept(resultMap);
            } else {
                complete.accept(null);
            }
        }
        catch (Exception e) {
            HashMap<String, String> errorMap = new HashMap<String, String>();
            errorMap.put("error", e.getMessage());
            complete.accept(errorMap);
        }
    }

    private String normalizePath(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.startsWith("file://")) {
            path = path.substring(7);
        }
        if (path.startsWith("/") && path.length() > 3 && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            path = path.replace('/', '\\');
        }
        return path;
    }

    private String normalizeFileUri(String uri) {
        if (uri == null || ((String)uri).isEmpty()) {
            return uri;
        }
        if (((String)uri).startsWith("file:/") && !((String)uri).startsWith("file:///")) {
            uri = ((String)uri).startsWith("file://") ? "file:///" + ((String)uri).substring("file://".length()) : "file:///" + ((String)uri).substring("file:/".length());
        }
        return uri;
    }
}

