/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.documents;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.LanguageUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.util.TextUtils;

public class MainThreadDocumentsService
extends MainThreadBaseProxy {
    private static final String TRY_CREATE_DOCUMENT = "$tryCreateDocument";
    private static final String TRY_OPEN_DOCUMENT = "$tryOpenDocument";
    private static final String TRY_SAVE_DOCUMENT = "$trySaveDocument";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$tryCreateDocument": {
                ThreadManager.getInstance().runUiThread(() -> this.tryCreateDocument(project, args, complete));
                break;
            }
            case "$tryOpenDocument": {
                ThreadManager.getInstance().runUiThread(() -> this.tryOpenDocument(project, args, complete));
                break;
            }
            case "$trySaveDocument": {
                ThreadManager.getInstance().runUiThread(() -> this.trySaveDocument(project, args, complete));
                break;
            }
            default: {
                LogManager.warn(MainThreadDocumentsService.class, "req:" + name + " is not implemented");
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void tryCreateDocument(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.isEmpty()) {
            LogManager.warn(MainThreadDocumentsService.class, "tryCreateDocument: args size is less than 1");
            complete.accept(false);
            return;
        }
        if (project == null) {
            LogManager.warn(MainThreadDocumentsService.class, "tryCreateDocument: project is null");
            complete.accept(false);
            return;
        }
        try {
            JSONObject payload = JSONObject.parseObject((String)args.get(0).toString());
            String language = payload.getString("language");
            String content = payload.getString("content");
            VirtualFile baseDir = this.getDir(project);
            Object suggestedName = "untitled";
            String suffix = LanguageUtils.getGfSpLanguageSuffix(language);
            if (!TextUtils.isEmpty((CharSequence)suffix)) {
                suggestedName = (String)suggestedName + "." + suffix;
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save As", "\u9009\u62e9\u4fdd\u5b58\u4f4d\u7f6e", new String[0]);
            FileSaverDialog dialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            VirtualFileWrapper result = dialog.save(baseDir, (String)suggestedName);
            if (result == null) {
                complete.accept(null);
                return;
            }
            File targetFile = result.getFile();
            if (targetFile == null) {
                complete.accept(null);
                return;
            }
            Path targetPath = targetFile.toPath();
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                try {
                    Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    Files.write(targetPath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    this.notifyAddDocument(project, targetPath);
                    VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(targetPath);
                    if (vf != null) {
                        vf.refresh(false, false);
                        FileEditorManager.getInstance((Project)project).openFile(vf, false);
                        complete.accept(VirtualFileUriBean.from(vf).getUri());
                    } else {
                        complete.accept(null);
                    }
                }
                catch (IOException ioException) {
                    LogManager.warn(MainThreadDocumentsService.class, "tryCreateDocument: write file failed: " + ioException.getMessage());
                    complete.accept(null);
                }
            });
        }
        catch (Exception e) {
            LogManager.warn(MainThreadDocumentsService.class, "tryCreateDocument: error:" + e.getMessage());
            complete.accept(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryOpenDocument(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 2) {
            LogManager.warn(MainThreadDocumentsService.class, "tryOpenDocument: args size is less than 2");
            complete.accept(false);
            return;
        }
        try {
            JSONObject payload = JSONObject.parseObject((String)args.get(0).toString());
            String external = payload.getString("external");
            String scheme = payload.getString("scheme");
            if (external == null || external.isEmpty()) {
                LogManager.warn(MainThreadDocumentsService.class, "tryOpenDocument: fsPath is empty");
                complete.accept(null);
                return;
            }
            Path path = null;
            if (external.startsWith("untitled:")) {
                String fileName = external.substring("untitled:".length());
                String basePath = project.getBasePath();
                if (basePath == null) {
                    LogManager.warn(MainThreadDocumentsService.class, "tryOpenDocument: project base path is null");
                    complete.accept(null);
                    return;
                }
                path = Paths.get(basePath, fileName);
            } else if (external.startsWith("file://")) {
                try {
                    URI fileUri = URI.create(external);
                    path = Paths.get(fileUri);
                }
                catch (Exception e) {
                    LogManager.warn(MainThreadDocumentsService.class, "tryOpenDocument: failed to parse file URI: " + e.getMessage());
                    complete.accept(null);
                    return;
                }
            } else if (scheme != null && !scheme.isEmpty()) {
                if (!"file".equalsIgnoreCase(scheme)) {
                    LogManager.warn(MainThreadDocumentsService.class, "tryOpenDocument: unsupported scheme = " + scheme);
                    complete.accept(null);
                    return;
                }
                path = Paths.get(external, new String[0]);
            } else {
                path = Paths.get(external, new String[0]);
            }
            if (!Files.exists(path, new LinkOption[0])) {
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.createFile(path, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LogManager.warn(MainThreadDocumentsService.class, "tryOpenDocument: create file failed:" + e.getMessage());
                }
            }
            this.notifyAddDocument(project, path);
            complete.accept(external);
            return;
        }
        catch (Exception e) {
            LogManager.warn(MainThreadDocumentsService.class, "tryOpenDocument: error:" + e.getMessage());
            complete.accept(null);
        }
    }

    private void trySaveDocument(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.isEmpty()) {
            LogManager.warn(MainThreadDocumentsService.class, "trySaveDocument: args size is less than 1");
            complete.accept(false);
            return;
        }
        JSONObject payload = JSONObject.parseObject((String)args.get(0).toString());
        URI uri = URI.create(payload.getString("external"));
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(uri.getPath());
        if (virtualFile == null) {
            LogManager.warn(MainThreadDocumentsService.class, "trySaveDocument: virtual file not found");
            complete.accept(false);
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            LogManager.warn(MainThreadDocumentsService.class, "trySaveDocument: document not found");
            complete.accept(false);
            return;
        }
        FileDocumentManager.getInstance().saveDocument(document);
        complete.accept(true);
    }

    private VirtualFile getDir(Project project) {
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByNioFile(Paths.get(basePath, new String[0]));
        if (baseDir == null) {
            return null;
        }
        VirtualFile[] files = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (files.length > 0) {
            baseDir = files[0].getParent();
        }
        return baseDir;
    }

    private String getNewFileName(String language, VirtualFile baseDir) {
        String baseFilename = "untitled";
        String suffix = LanguageUtils.getGfSpLanguageSuffix(language);
        Object extension = TextUtils.isEmpty((CharSequence)suffix) ? "" : "." + suffix;
        int i = 0;
        String filename;
        while (baseDir.findChild(filename = baseFilename + String.valueOf(i == 0 ? "" : Integer.valueOf(i)) + (String)extension) != null) {
            ++i;
        }
        return filename;
    }

    private VirtualFile createFile(Project project, String text, String filename, VirtualFile baseDir) {
        try {
            VirtualFile vf = baseDir.createChildData((Object)project, filename);
            vf.setBinaryContent(text.getBytes(StandardCharsets.UTF_8));
            return vf;
        }
        catch (Exception e) {
            LogManager.error(MainThreadDocumentsService.class, "create file error" + String.valueOf(e));
            return null;
        }
    }

    private void notifyAddDocument(Project project, Path path) {
        if (path == null) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            LogManager.warn(MainThreadDocumentsService.class, "notifyAddDocument: path not exists: " + String.valueOf(path));
            return;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile virtualFile = lfs.refreshAndFindFileByNioFile(path);
        if (virtualFile == null) {
            LogManager.warn(MainThreadDocumentsService.class, "notifyAddDocument: virtual file not found for path: " + String.valueOf(path));
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            LogManager.warn(MainThreadDocumentsService.class, "notifyAddDocument: document is null for " + virtualFile.getPath());
            return;
        }
        NodeRunner.getInstance(project).getDocumentsAndEditors().addDocument(document, project);
    }
}

