/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.editors;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.tencent.code.intel.apibridge.Decoration.bean.ContentDecorationRenderOptions;
import com.tencent.code.intel.apibridge.Decoration.bean.DecorationInstanceRenderOptions;
import com.tencent.code.intel.apibridge.Decoration.bean.Range;
import com.tencent.code.intel.manager.LogManager;

public class DecorationOptionsParser {
    public static Range parseRange(JSONObject rangeObj) {
        if (rangeObj == null) {
            return null;
        }
        JSONObject startObj = rangeObj.getJSONObject("start");
        JSONObject endObj = rangeObj.getJSONObject("end");
        if (startObj != null && endObj != null) {
            return DecorationOptionsParser.parseNestedRange(startObj, endObj);
        }
        return DecorationOptionsParser.parseFlatRange(rangeObj);
    }

    private static Range parseNestedRange(JSONObject startObj, JSONObject endObj) {
        try {
            Integer startLine = startObj.getInteger("line");
            Integer startCharacter = startObj.getInteger("character");
            Integer endLine = endObj.getInteger("line");
            Integer endCharacter = endObj.getInteger("character");
            if (startLine != null && startCharacter != null && endLine != null && endCharacter != null) {
                return new Range(startLine + 1, startCharacter + 1, endLine + 1, endCharacter + 1);
            }
        }
        catch (Exception e) {
            LogManager.warn(DecorationOptionsParser.class, "Failed to parse nested range format: " + e.getMessage());
        }
        return null;
    }

    private static Range parseFlatRange(JSONObject rangeObj) {
        try {
            Integer startLineNumber = rangeObj.getInteger("startLineNumber");
            Integer startColumn = rangeObj.getInteger("startColumn");
            Integer endLineNumber = rangeObj.getInteger("endLineNumber");
            Integer endColumn = rangeObj.getInteger("endColumn");
            if (startLineNumber != null && startColumn != null && endLineNumber != null && endColumn != null) {
                return new Range(startLineNumber, startColumn, endLineNumber, endColumn);
            }
        }
        catch (Exception e) {
            LogManager.warn(DecorationOptionsParser.class, "Failed to parse flat range format: " + e.getMessage());
        }
        return null;
    }

    public static DecorationInstanceRenderOptions parseRenderOptions(JSONObject renderOptionsObj) {
        if (renderOptionsObj == null) {
            return null;
        }
        try {
            ContentDecorationRenderOptions after;
            JSONObject afterObj;
            ContentDecorationRenderOptions before;
            DecorationInstanceRenderOptions renderOptions = new DecorationInstanceRenderOptions();
            JSONObject beforeObj = renderOptionsObj.getJSONObject("before");
            if (beforeObj != null && (before = DecorationOptionsParser.parseContentDecorationRenderOptions(beforeObj)) != null) {
                renderOptions.setBefore(before);
            }
            if ((afterObj = renderOptionsObj.getJSONObject("after")) != null && (after = DecorationOptionsParser.parseContentDecorationRenderOptions(afterObj)) != null) {
                renderOptions.setAfter(after);
            }
            return renderOptions;
        }
        catch (Exception e) {
            LogManager.warn(DecorationOptionsParser.class, "Failed to parse renderOptions: " + e.getMessage());
            return null;
        }
    }

    private static ContentDecorationRenderOptions parseContentDecorationRenderOptions(JSONObject contentObj) {
        try {
            return (ContentDecorationRenderOptions)JSONObject.parseObject((String)contentObj.toJSONString(new JSONWriter.Feature[0]), ContentDecorationRenderOptions.class);
        }
        catch (Exception e) {
            LogManager.warn(DecorationOptionsParser.class, "Failed to parse content decoration render options: " + e.getMessage());
            return null;
        }
    }

    public static boolean isValidRange(Range range) {
        if (range == null) {
            return false;
        }
        try {
            return range.getStartLineNumber() > 0 && range.getStartColumn() > 0 && range.getEndLineNumber() > 0 && range.getEndColumn() > 0 && range.getStartLineNumber() <= range.getEndLineNumber();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean hasValidContent(DecorationInstanceRenderOptions renderOptions) {
        if (renderOptions == null) {
            return false;
        }
        try {
            boolean hasBefore = renderOptions.getBefore() != null && renderOptions.getBefore().getContentText() != null && !renderOptions.getBefore().getContentText().trim().isEmpty();
            boolean hasAfter = renderOptions.getAfter() != null && renderOptions.getAfter().getContentText() != null && !renderOptions.getAfter().getContentText().trim().isEmpty();
            return hasBefore || hasAfter;
        }
        catch (Exception e) {
            return false;
        }
    }
}

