/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.editors;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util.DocumentsEditorsUtils;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.model.Range;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.model.TextEditDto;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.model.WorkspaceEditDto;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadBulkEditsService
extends MainThreadBaseProxy {
    private static final String TRY_APPLY_WORKSPACE_EDIT = "$tryApplyWorkspaceEdit";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$tryApplyWorkspaceEdit": {
                ThreadManager.getInstance().runUiThread(() -> this.handleApplyEdit(project, args, complete));
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void handleApplyEdit(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 3) {
            LogManager.warn(MainThreadBulkEditsService.class, "MainThreadBulkEditsService requires at least three arguments");
            return;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)args.get(0).toString());
            WorkspaceEditDto dto = (WorkspaceEditDto)JSONObject.parseObject((String)jsonObject.getString("value"), WorkspaceEditDto.class);
            WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                for (TextEditDto editDto : dto.getEdits()) {
                    URI uri = URI.create(editDto.getResourcePath());
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(uri.getPath());
                    if (virtualFile == null) {
                        LogManager.warn(MainThreadBulkEditsService.class, "virtual file is null, " + editDto.getResourcePath());
                        continue;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
                    if (document == null) {
                        LogManager.warn(MainThreadBulkEditsService.class, "document is null, " + editDto.getResourcePath());
                        continue;
                    }
                    TextEditDto.TextEdit textEdit = editDto.getTextEdit();
                    Range range = textEdit.getRange();
                    int startOffset = DocumentsEditorsUtils.getDocumentOffset(document, range.startLineNumber, range.startColumn);
                    int endOffset = DocumentsEditorsUtils.getDocumentOffset(document, range.endLineNumber, range.endColumn);
                    String replaceText = textEdit.getText().replaceAll("\r\n", "\n");
                    document.replaceString(startOffset, endOffset, (CharSequence)replaceText);
                }
            });
            complete.accept(true);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadBulkEditsService.class, "handleApplyEdit error: " + String.valueOf(e));
            complete.accept(false);
        }
    }
}

