/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.editors;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.tencent.code.intel.apibridge.Decoration.DecorationService;
import com.tencent.code.intel.apibridge.Decoration.bean.DecorationInstanceRenderOptions;
import com.tencent.code.intel.apibridge.Decoration.bean.DecorationOptions;
import com.tencent.code.intel.apibridge.Decoration.bean.DecorationRenderOptions;
import com.tencent.code.intel.apibridge.Decoration.bean.Range;
import com.tencent.code.intel.apibridge.extension.extension.documentsandeditors.util.DocumentToExtHostDataConverter;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.DecorationOptionsParser;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.model.DocumentEdit;
import com.tencent.code.intel.apibridge.extension.mainthread.editors.model.TextDocumentShowOptions;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.common.EditorCommandName;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.CollectionUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.util.TextUtils;

public class MainThreadEditorsService
extends MainThreadBaseProxy {
    private static final String TRY_SHOW_TEXT_DOCUMENT = "$tryShowTextDocument";
    private static final String TRY_APPLY_EDITS = "$tryApplyEdits";
    private static final String SET_DECORATIONS = "$setDecorations";
    private static final String SET_DECORATIONS_FAST = "$setDecorationsFast";
    private static final String REVEAL_RANGE = "$revealRange";
    private static final String DISPOSE_DECORATION = "$disposeDecoration";
    private static final String REGISTER_TEXT_EDITOR_DECORATION_TYPE = "$registerTextEditorDecorationType";
    private static final String TRY_SET_SELECTIONS = "$trySetSelections";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$tryShowTextDocument": {
                ThreadManager.getInstance().runUiThread(() -> this.handleTryShowTextDocument(project, args, complete));
                break;
            }
            case "$tryApplyEdits": {
                ThreadManager.getInstance().runUiThread(() -> this.handleTryApplyEdits(project, args, complete));
                break;
            }
            case "$setDecorations": {
                ThreadManager.getInstance().runUiThread(() -> this.handleSetDecorations(project, args, complete));
                break;
            }
            case "$setDecorationsFast": {
                ThreadManager.getInstance().runUiThread(() -> this.handleSetDecorationsFast(project, args, complete));
                break;
            }
            case "$revealRange": {
                ThreadManager.getInstance().runUiThread(() -> this.handleRevealRange(project, args, complete));
                break;
            }
            case "$disposeDecoration": {
                ThreadManager.getInstance().runUiThread(() -> this.handleDisposeDecoration(project, args, complete));
                break;
            }
            case "$registerTextEditorDecorationType": {
                this.handleRegisterTextEditorDecorationType(project, args, complete);
                break;
            }
            case "$trySetSelections": {
                ThreadManager.getInstance().runUiThread(() -> this.handleTrySetSelections(project, args, complete));
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void handleTryShowTextDocument(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 2) {
            LogManager.warn(MainThreadEditorsService.class, "tryShowTextDocument: args size < 2");
            complete.accept(null);
            return;
        }
        try {
            List fileEditors;
            JSONObject payload = JSONObject.parseObject((String)args.get(0).toString());
            URI uri = URI.create(payload.getString("external"));
            String path = uri.getPath();
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
            if (virtualFile == null) {
                LogManager.warn(MainThreadEditorsService.class, "tryShowTextDocument: virtualFile is null:" + path);
                complete.accept(null);
                return;
            }
            TextDocumentShowOptions options = (TextDocumentShowOptions)JSONObject.parseObject((String)args.get(1).toString(), TextDocumentShowOptions.class);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile);
            boolean focueEditor = true;
            if (options != null) {
                if (options.pinned != null) {
                    descriptor.setUsePreviewTab(options.pinned == false);
                }
                if (options.preserveFocus != null) {
                    focueEditor = options.preserveFocus == false;
                    descriptor.setUseCurrentWindow(options.preserveFocus == false);
                }
            }
            if ((fileEditors = FileEditorManager.getInstance((Project)project).openEditor(descriptor, focueEditor)).isEmpty()) {
                LogManager.warn(MainThreadEditorsService.class, "tryShowTextDocument: editor is null:" + path);
                complete.accept(null);
                return;
            }
            FileEditor editor = (FileEditor)fileEditors.get(0);
            Document document = null;
            if (editor instanceof TextEditor) {
                document = ((TextEditor)editor).getEditor().getDocument();
                NodeRunner.getInstance(project).updateFocusEditorAndDocument(editor, document, virtualFile, project, null);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
            complete.accept(DocumentToExtHostDataConverter.getEditorId(editor, document));
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "tryShowTextDocument: " + String.valueOf(e));
        }
    }

    private void handleTryApplyEdits(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            if (!(fileEditor instanceof TextEditor)) {
                complete.accept(false);
                return;
            }
            JSONArray editsArr = JSONArray.parseArray((String)args.get(2).toString(), (JSONReader.Feature[])new JSONReader.Feature[0]);
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            Document document = editor.getDocument();
            ArrayList documentEdits = new ArrayList();
            editsArr.forEach(edit -> {
                JSONObject editObj = (JSONObject)edit;
                JSONObject rangeObj = editObj.getJSONObject("range");
                int startLineNumber = rangeObj.getInteger("startLineNumber");
                int startColumn = rangeObj.getInteger("startColumn");
                int endLineNumber = rangeObj.getInteger("endLineNumber");
                int endColumn = rangeObj.getInteger("endColumn");
                String text = editObj.getString("text");
                if (TextUtils.isEmpty((CharSequence)text)) {
                    text = "";
                }
                int startOffset = document.getLineStartOffset(startLineNumber - 1) + startColumn - 1;
                int endOffset = document.getLineStartOffset(endLineNumber - 1) + endColumn - 1;
                documentEdits.add(new DocumentEdit(startOffset, endOffset, text));
            });
            documentEdits.sort((a, b) -> Integer.compare(b.getStartOffset(), a.getStartOffset()));
            WriteCommandAction.runWriteCommandAction((Project)project, (String)EditorCommandName.IGNORE_COMPLETION.TYR_APPLY_EDITS.getName(), (String)"", () -> {
                try {
                    CaretModel caretModel = editor.getCaretModel();
                    int finalCaretOffset = -1;
                    for (int i = 0; i < documentEdits.size(); ++i) {
                        DocumentEdit editItem = (DocumentEdit)documentEdits.get(i);
                        int currentStartOffset = editItem.getStartOffset();
                        int currentEndOffset = editItem.getEndOffset();
                        String currentText = editItem.getText();
                        document.replaceString(currentStartOffset, currentEndOffset, (CharSequence)currentText);
                        if (i != documentEdits.size() - 1) continue;
                        finalCaretOffset = currentStartOffset + currentText.length();
                    }
                    if (finalCaretOffset != -1) {
                        caretModel.moveToOffset(finalCaretOffset);
                    }
                    document.getText();
                    complete.accept(true);
                }
                catch (Exception e) {
                    LogManager.warn(MainThreadEditorsService.class, "tryApplyEdits error: " + String.valueOf(e));
                    complete.accept(false);
                }
            }, (PsiFile[])new PsiFile[0]);
        }
        catch (Exception e) {
            complete.accept(false);
            LogManager.warn(MainThreadEditorsService.class, "tryApplyEdits: " + String.valueOf(e));
        }
    }

    private List<DecorationOptions> parseDecorationOptions(String decorationType, String decorationsJson) {
        ArrayList<DecorationOptions> decorationsList = new ArrayList<DecorationOptions>();
        try {
            JSONArray jsonArray = JSONArray.parseArray((String)decorationsJson, (JSONReader.Feature[])new JSONReader.Feature[0]);
            for (Object item : jsonArray) {
                JSONObject renderOptionsObj;
                DecorationInstanceRenderOptions renderOptions;
                JSONObject decorationObj = (JSONObject)item;
                DecorationOptions decoration = new DecorationOptions();
                JSONObject rangeObj = decorationObj.getJSONObject("range");
                Range range = DecorationOptionsParser.parseRange(rangeObj);
                if (range != null) {
                    decoration.setRange(range);
                }
                if ((renderOptions = DecorationOptionsParser.parseRenderOptions(renderOptionsObj = decorationObj.getJSONObject("renderOptions"))) != null) {
                    decoration.setRenderOptions(renderOptions);
                }
                decorationsList.add(decoration);
            }
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "parseDecorationOptions error for " + decorationType + ": " + String.valueOf(e));
        }
        return decorationsList;
    }

    private synchronized void handleSetDecorations(Project project, List<Object> args, Consumer<Object> complete) {
        complete.accept(null);
        try {
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            if (!(fileEditor instanceof TextEditor)) {
                return;
            }
            if (args.size() < 2) {
                LogManager.warn(MainThreadEditorsService.class, "handleSetDecorations: args size < 2");
                return;
            }
            String decorationType = args.get(0).toString();
            List decorationsList = JSONArray.parseArray((String)args.get(1).toString(), DecorationOptions.class);
            DecorationService.getInstance(project).showDecorations(((TextEditor)fileEditor).getEditor(), decorationType, decorationsList);
        }
        catch (NoClassDefFoundError e) {
            LogManager.warn(MainThreadEditorsService.class, "handleSetDecorations (first-open skip): " + String.valueOf(e));
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "handleSetDecorations: " + String.valueOf(e));
        }
    }

    private synchronized void handleSetDecorationsFast(Project project, List<Object> args, Consumer<Object> complete) {
        complete.accept(null);
        try {
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            if (!(fileEditor instanceof TextEditor)) {
                return;
            }
            if (args.size() < 2) {
                LogManager.warn(MainThreadEditorsService.class, "handleSetDecorationsFast: args size < 2");
                return;
            }
            String decorationType = args.get(0).toString();
            JSONArray jsonArray = JSONArray.parseArray((String)args.get(1).toString(), (JSONReader.Feature[])new JSONReader.Feature[0]);
            int[] rangeNums = jsonArray.stream().mapToInt(obj -> ((Number)obj).intValue()).toArray();
            ArrayList<Range> ranges = new ArrayList<Range>();
            int len = Math.floorDiv(rangeNums.length, 4);
            for (int i = 0; i < len; ++i) {
                ranges.add(new Range(rangeNums[4 * i], rangeNums[4 * i + 1], rangeNums[4 * i + 2], rangeNums[4 * i + 3]));
            }
            DecorationService.getInstance(project).showDecorationsFast(((TextEditor)fileEditor).getEditor(), decorationType, ranges);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "handleSetDecorationsFast: " + String.valueOf(e));
        }
    }

    private void handleRevealRange(Project project, List<Object> args, Consumer<Object> complete) {
        complete.accept(null);
        try {
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            if (!(fileEditor instanceof TextEditor)) {
                return;
            }
            String scrollTypeValue = args.get(1).toString();
            JSONObject rangeObj = JSONObject.parseObject((String)args.get(0).toString());
            Editor editor = ((TextEditor)fileEditor).getEditor();
            int startLineNumber = rangeObj.getInteger("startLineNumber") - 1;
            LogicalPosition logicalPosition = new LogicalPosition(startLineNumber, 0);
            ScrollType scrollType = ScrollType.RELATIVE;
            if (scrollTypeValue.equals("1")) {
                scrollType = ScrollType.CENTER;
            }
            editor.getScrollingModel().scrollTo(logicalPosition, scrollType);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "handleRevealRange: " + String.valueOf(e));
        }
    }

    private void handleDisposeDecoration(Project project, List<Object> args, Consumer<Object> complete) {
        complete.accept(null);
        try {
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            if (!(fileEditor instanceof TextEditor)) {
                return;
            }
            String decorationType = args.get(0).toString();
            DecorationService.getInstance(project).dispose(decorationType);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "handleDisposeDecoration: " + String.valueOf(e));
        }
    }

    private void handleRegisterTextEditorDecorationType(Project project, List<Object> args, Consumer<Object> complete) {
        complete.accept(null);
        try {
            if (args.size() < 1) {
                LogManager.warn(MainThreadEditorsService.class, "handleRegisterTextEditorDecorationType: args size < 1");
                return;
            }
            String decorationType = args.get(0).toString();
            DecorationRenderOptions renderOptions = (DecorationRenderOptions)JSONObject.parseObject((String)args.get(1).toString(), DecorationRenderOptions.class);
            DecorationService.getInstance(project).registerTextEditorDecorationType(decorationType, renderOptions);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "handleRegisterTextEditorDecorationType: " + String.valueOf(e));
        }
    }

    private void handleTrySetSelections(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            JSONArray selections;
            if (args.size() < 2) {
                LogManager.warn(MainThreadEditorsService.class, "handleTrySetSelections: args size < 1");
                return;
            }
            FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
            if (!(fileEditor instanceof TextEditor)) {
                return;
            }
            TextEditor textEditor = (TextEditor)fileEditor;
            Editor editor = textEditor.getEditor();
            Document document = editor.getDocument();
            Object arg1 = args.get(1);
            if (arg1 == null) {
                LogManager.warn(MainThreadEditorsService.class, "handleTrySetSelections: args[1] is null");
                return;
            }
            try {
                selections = JSONArray.parseArray((String)arg1.toString(), (JSONReader.Feature[])new JSONReader.Feature[0]);
            }
            catch (Exception e) {
                LogManager.warn(MainThreadEditorsService.class, "handleTrySetSelections: failed to parse selections JSON: " + e.getMessage());
                return;
            }
            if (CollectionUtils.isEmpty((Collection)selections)) {
                return;
            }
            CaretModel caretModel = editor.getCaretModel();
            SelectionModel selectionModel = editor.getSelectionModel();
            caretModel.removeSecondaryCarets();
            JSONObject firstSelection = this.getSelectionObject(selections, 0);
            if (firstSelection == null) {
                return;
            }
            int startOffset = this.calculateOffset(document, firstSelection, "selectionStartLineNumber", "selectionStartColumn");
            int endOffset = this.calculateOffset(document, firstSelection, "positionLineNumber", "positionColumn");
            if (startOffset == -1 || endOffset == -1) {
                LogManager.warn(MainThreadEditorsService.class, "Invalid line/column numbers in first selection");
                return;
            }
            caretModel.moveToOffset(endOffset);
            selectionModel.setSelection(startOffset, endOffset);
            for (int i = 1; i < selections.size(); ++i) {
                JSONObject selectionObj = this.getSelectionObject(selections, i);
                if (selectionObj == null) continue;
                int sOffset = this.calculateOffset(document, selectionObj, "selectionStartLineNumber", "selectionStartColumn");
                int eOffset = this.calculateOffset(document, selectionObj, "positionLineNumber", "positionColumn");
                if (sOffset == -1 || eOffset == -1) {
                    LogManager.warn(MainThreadEditorsService.class, "Invalid line/column numbers in selection index " + i);
                    continue;
                }
                Caret caret = caretModel.addCaret(editor.offsetToVisualPosition(eOffset));
                if (caret == null) continue;
                caret.setSelection(sOffset, eOffset);
            }
            complete.accept(null);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorsService.class, "handleTrySetSelections: " + String.valueOf(e));
        }
    }

    private JSONObject getSelectionObject(JSONArray selections, int index) {
        if (index < 0 || index >= selections.size()) {
            return null;
        }
        Object obj = selections.get(index);
        if (!(obj instanceof JSONObject)) {
            LogManager.warn(MainThreadEditorsService.class, "Selection at index " + index + " is not a JSONObject");
            return null;
        }
        return (JSONObject)obj;
    }

    private int calculateOffset(Document document, JSONObject selectionObj, String lineKey, String columnKey) {
        int lineEndOffset;
        Integer line = selectionObj.getInteger(lineKey);
        Integer column = selectionObj.getInteger(columnKey);
        if (line == null || column == null) {
            return -1;
        }
        int lineIndex = line - 1;
        int columnIndex = column - 1;
        if (lineIndex < 0 || lineIndex >= document.getLineCount()) {
            return -1;
        }
        int lineStartOffset = document.getLineStartOffset(lineIndex);
        int offset = lineStartOffset + columnIndex;
        if (offset > (lineEndOffset = document.getLineEndOffset(lineIndex))) {
            offset = lineEndOffset;
        }
        return offset;
    }
}

