/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.editortabs;

import com.alibaba.fastjson2.JSONArray;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.extension.editortabs.util.EditorTabsConverter;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadEditorTabsService
extends MainThreadBaseProxy {
    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$closeTab": {
                ThreadManager.getInstance().runUiThread(() -> this.handleCloseTab(project, args, complete));
                break;
            }
            case "$closeGroup": {
                ThreadManager.getInstance().runUiThread(() -> this.handleCloseGroup(project, args, complete));
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void handleCloseTab(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            EditorWindow[] windows;
            if (args.isEmpty()) {
                LogManager.warn(MainThreadEditorTabsService.class, "handleCloseTab args is empty");
                complete.accept(false);
                return;
            }
            List tabIds = JSONArray.parseArray((String)args.get(0).toString(), String.class);
            boolean preserveFocus = false;
            if (args.size() > 1 && args.get(1) != null) {
                preserveFocus = Boolean.parseBoolean(args.get(1).toString());
            }
            for (EditorWindow window : windows = FileEditorManagerEx.getInstanceEx((Project)project).getWindows()) {
                int groupId = window.hashCode();
                Arrays.stream(window.getFiles()).forEach(file -> {
                    String tabId = EditorTabsConverter.getTabId(groupId, file.getUrl());
                    if (tabIds.contains(tabId)) {
                        window.closeFile(file);
                    }
                });
            }
            complete.accept(true);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorTabsService.class, "handleCloseTab error: " + e.getMessage());
            complete.accept(false);
        }
    }

    private void handleCloseGroup(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            EditorWindow[] windows;
            if (args.isEmpty()) {
                LogManager.warn(MainThreadEditorTabsService.class, "handleCloseGroup args is empty");
                complete.accept(false);
                return;
            }
            List groupIds = JSONArray.parseArray((String)args.get(0).toString(), Number.class);
            boolean preserveFocus = false;
            if (args.size() > 1 && args.get(1) != null) {
                preserveFocus = Boolean.parseBoolean(args.get(1).toString());
            }
            for (EditorWindow window : windows = FileEditorManagerEx.getInstanceEx((Project)project).getWindows()) {
                Integer groupId = window.hashCode();
                if (!groupIds.contains(groupId)) continue;
                Arrays.stream(window.getFiles()).forEach(file -> window.closeFile(file));
                complete.accept(true);
                return;
            }
            complete.accept(false);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadEditorTabsService.class, "handleCloseGroup error: " + e.getMessage());
            complete.accept(false);
        }
    }
}

