/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.explorer;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.action.base.BaseAnAction;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.context.contextexpression.ContextExpression;
import com.tencent.code.intel.apibridge.extension.mainthread.explorer.ExplorerMenuContext;
import com.tencent.code.intel.apibridge.util.UriComponentConverter;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.JsonRpcUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MainThreadExplorerMenusService
extends MainThreadBaseProxy {
    private static final String REGISTER_EXPLORER_MENUS = "$registerExplorerMenus";
    private static final Map<Project, Set<String>> PROJECT_ACTIONS = new ConcurrentHashMap<Project, Set<String>>();
    private static final Map<Project, Set<String>> PROJECT_MENU_GROUPS = new ConcurrentHashMap<Project, Set<String>>();
    private static final String GROUP_ID_PREFIX = "ExplorerMenu_";

    public MainThreadExplorerMenusService() {
        ProjectManager.getInstance().addProjectManagerListener(new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                MainThreadExplorerMenusService.this.cleanupProjectActions(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/tencent/code/intel/apibridge/extension/mainthread/explorer/MainThreadExplorerMenusService$1", "projectClosed"));
            }
        });
    }

    private void cleanupProjectActions(Project project) {
        Set<String> projectMenuGroups;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup projectViewPopupMenu = (DefaultActionGroup)actionManager.getAction("ProjectViewPopupMenu");
        Set<String> projectActions = PROJECT_ACTIONS.remove(project);
        if (projectActions != null) {
            for (String actionId : projectActions) {
                AnAction action = actionManager.getAction(actionId);
                if (action == null) continue;
                actionManager.unregisterAction(actionId);
            }
        }
        if ((projectMenuGroups = PROJECT_MENU_GROUPS.remove(project)) != null) {
            for (String groupId : projectMenuGroups) {
                AnAction group = actionManager.getAction(groupId);
                if (projectViewPopupMenu != null && group != null && projectViewPopupMenu.containsAction(group)) {
                    projectViewPopupMenu.remove(group);
                }
                if (group == null) continue;
                actionManager.unregisterAction(groupId);
            }
        }
        LogManager.info(MainThreadExplorerMenusService.class, "\u5df2\u6e05\u7406\u9879\u76ee " + project.getName() + " \u7684\u6240\u6709 actions \u548c\u83dc\u5355");
    }

    private String getProjectGroupId(Project project, String baseGroupId) {
        return GROUP_ID_PREFIX + baseGroupId + "_" + project.getLocationHash();
    }

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        if (name.equals(REGISTER_EXPLORER_MENUS)) {
            this.registerExplorerMenus(project, args, complete);
        }
        super.handleReq(project, name, args, complete);
    }

    private void registerExplorerMenus(final Project project, List<Object> menus, Consumer<Object> complete) {
        try {
            if (menus == null || menus.isEmpty()) {
                complete.accept(false);
                return;
            }
            List explorerMenusContext = menus.stream().filter(keybinding -> keybinding instanceof List).flatMap(items -> ((List)items).stream()).map(menu -> {
                ExplorerMenuContext menuContext = JsonRpcUtils.toJavaObject(menu, ExplorerMenuContext.class);
                menuContext.setProject(project);
                return menuContext;
            }).collect(Collectors.toList());
            ThreadManager.getInstance().runUiThread(() -> {
                ActionManager actionManager = ActionManager.getInstance();
                DefaultActionGroup projectViewPopupMenu = (DefaultActionGroup)actionManager.getAction("ProjectViewPopupMenu");
                Set<String> oldGroups = PROJECT_MENU_GROUPS.remove(project);
                if (oldGroups != null) {
                    for (String groupId : oldGroups) {
                        AnAction group = actionManager.getAction(groupId);
                        if (projectViewPopupMenu != null && group != null && projectViewPopupMenu.containsAction(group)) {
                            projectViewPopupMenu.remove(group);
                        }
                        if (group == null) continue;
                        actionManager.unregisterAction(groupId);
                    }
                }
                HashSet<String> newGroups = new HashSet<String>();
                PROJECT_MENU_GROUPS.put(project, newGroups);
                for (final ExplorerMenuContext explorerMenuContext : explorerMenusContext) {
                    String baseGroupId = explorerMenuContext.getGroup();
                    String projectGroupId = this.getProjectGroupId(project, baseGroupId);
                    DefaultActionGroup menuGroup = new DefaultActionGroup(explorerMenuContext.getTitle(), true){

                        public void update(@NotNull AnActionEvent e) {
                            Project currentProject;
                            if (e == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                                e.getPresentation().setEnabled(false);
                                e.getPresentation().setVisible(false);
                                return;
                            }
                            e.getPresentation().setText(explorerMenuContext.getTitle());
                            e.getPresentation().setEnabled(explorerMenuContext.getRealRule().evaluate());
                        }

                        @NotNull
                        public ActionUpdateThread getActionUpdateThread() {
                            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                            if (actionUpdateThread == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            return actionUpdateThread;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 1: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 1: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "e";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/tencent/code/intel/apibridge/extension/mainthread/explorer/MainThreadExplorerMenusService$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/explorer/MainThreadExplorerMenusService$2";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getActionUpdateThread";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "update";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 1: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    };
                    List<ExplorerMenuContext.ExplorerMenu> submenus = explorerMenuContext.getSubmenus();
                    for (ExplorerMenuContext.ExplorerMenu submenu : submenus) {
                        submenu.setProject(project);
                        BaseAnAction action = this.createMenuAction(project, submenu.getCommand(), submenu.getTitle(), submenu.getRealRule());
                        if (action == null) continue;
                        menuGroup.add((AnAction)action);
                    }
                    actionManager.registerAction(projectGroupId, (AnAction)menuGroup);
                    newGroups.add(projectGroupId);
                    if (projectViewPopupMenu == null) continue;
                    projectViewPopupMenu.add((AnAction)menuGroup, Constraints.FIRST);
                }
                complete.accept(true);
            });
        }
        catch (Exception e) {
            LogManager.info(MainThreadExplorerMenusService.class, "register explorer menus failed" + e.getMessage());
            complete.accept(false);
        }
    }

    private BaseAnAction createMenuAction(final Project project, final String command, String title, final ContextExpression rule) {
        String projectActionId = "explore." + command + "_" + project.getLocationHash();
        ActionManager actionManager = ActionManager.getInstance();
        rule.setProject(project);
        if (actionManager.getAction(projectActionId) != null) {
            actionManager.unregisterAction(projectActionId);
        }
        BaseAnAction projectAction = new BaseAnAction(title){

            public void update(@NotNull AnActionEvent e) {
                Project currentProject;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                    e.getPresentation().setEnabled(false);
                    return;
                }
                e.getPresentation().setEnabled(rule.evaluate());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project currentProject;
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                    return;
                }
                ArrayList uri = new ArrayList();
                VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
                if (files == null || files.length == 0) {
                    return;
                }
                List uris = Arrays.stream(files).map(file -> UriComponentConverter.getUriComponents(file)).collect(Collectors.toList());
                ExtHostCommands.executeCommand(currentProject, command, List.of(uri, uris), jsonObject -> {});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/explorer/MainThreadExplorerMenusService$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        actionManager.registerAction(projectActionId, (AnAction)projectAction);
        PROJECT_ACTIONS.computeIfAbsent(project, k -> new HashSet()).add(projectActionId);
        return projectAction;
    }

    private VirtualFile getCurrTestFile(@NotNull AnActionEvent e) {
        VirtualFile[] fileList;
        if (e == null) {
            MainThreadExplorerMenusService.$$$reportNull$$$0(0);
        }
        if ((fileList = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || fileList.length == 0) {
            return null;
        }
        return fileList[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/apibridge/extension/mainthread/explorer/MainThreadExplorerMenusService", "getCurrTestFile"));
    }
}

