/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.extensions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.extensions.RepoModel.Branch;
import com.tencent.code.intel.apibridge.extension.mainthread.extensions.RepoModel.Remote;
import com.tencent.code.intel.apibridge.extension.mainthread.extensions.RepoModel.Repository;
import com.tencent.code.intel.apibridge.extension.mainthread.extensions.RepoModel.RepositoryState;
import com.tencent.code.intel.apibridge.extension.mainthread.extensions.RepoModel.UpstreamRef;
import com.tencent.code.intel.bean.item.CodeReviewDiffContext;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.ProjectDiffUtils;
import git4idea.GitUtil;
import git4idea.repo.GitRepositoryManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadVscodeGitService
extends MainThreadBaseProxy {
    private static final String GET_REPOSITORY_INFO = "$getRepositoryInfo";
    private static final String GET_REPOSITORIES = "$getRepositories";
    private static final String INIT = "$init";
    private static final String DIFF = "$diff";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$getRepositoryInfo": 
            case "$getRepositories": {
                this.getRepositories(project, complete);
                break;
            }
            case "$diff": {
                this.diff(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    void getRepositories(Project project, Consumer<Object> complete) {
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)project);
        List repositories = repositoryManager.getRepositories();
        LogManager.info(MainThreadVscodeGitService.class, "get repositories count: " + String.valueOf(repositories));
        if (CollectionUtils.isEmpty(repositories)) {
            complete.accept(Collections.emptyList());
            return;
        }
        try {
            Object[] repos = (Repository[])repositories.stream().map(repo -> {
                Remote[] remotes = (Remote[])repo.getRemotes().stream().map(remote -> {
                    String[] pushUrls = (String[])remote.getPushUrls().toArray(String[]::new);
                    String pushUrl = pushUrls[0];
                    return new Remote(remote.getName(), remote.getFirstUrl(), pushUrl);
                }).toArray(Remote[]::new);
                UpstreamRef upstreamRef = new UpstreamRef("", "");
                Branch head = new Branch(upstreamRef, repo.getCurrentBranchName(), repo.getCurrentRevision());
                RepositoryState state = new RepositoryState(head, remotes, repo.getInfo().getState().equals((Object)Repository.State.REBASING));
                Repository repository = new Repository(repo.getRoot().getPath(), state);
                return repository;
            }).toArray(Repository[]::new);
            LogManager.info(MainThreadVscodeGitService.class, "repos info:" + Arrays.toString(repos));
            complete.accept(repos);
        }
        catch (Exception e) {
            complete.accept(Collections.emptyList());
            LogManager.warn(MainThreadVscodeGitService.class, "repo diff error with message " + e.getMessage());
        }
    }

    void diff(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            CodeReviewDiffContext diffCtx = ProjectDiffUtils.getAICodeReviewDiff(project, false);
            CharSequence[] diffContent = (String[])diffCtx.getDiffFiles().stream().map(diffFile -> diffFile.getDiff()).toArray(String[]::new);
            String diffString = String.join((CharSequence)"\n", diffContent);
            complete.accept(diffString);
        }
        catch (Exception e) {
            complete.accept(null);
            LogManager.warn(MainThreadVscodeGitService.class, "repo diff error with message " + e.getMessage());
        }
    }
}

