/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.filesystem;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadFileSystem
extends MainThreadBaseProxy {
    public final String ENSURE_ACTIVATION = "$ensureActivation";
    public final String WRITE_FILE = "$writeFile";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$ensureActivation": {
                ThreadManager.getInstance().runUiThread(() -> {
                    String basePath = project.getBasePath();
                    if (basePath != null) {
                        VirtualFile baseFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath);
                        if (baseFile != null) {
                            baseFile.refresh(true, true);
                        } else {
                            LogManager.warn(MainThreadFileSystem.class, "\u65e0\u6cd5\u627e\u5230\u9879\u76ee\u6839\u76ee\u5f55: " + basePath);
                            complete.accept(null);
                        }
                    }
                });
                complete.accept(null);
                break;
            }
            case "$writeFile": {
                this.writeFile(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void writeFile(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            if (args.size() != 2) {
                complete.accept(null);
                return;
            }
            String path = ((JSONObject)args.get(0)).get("fsPath").toString();
            String contentType = ((JSONObject)((JSONObject)args.get(1)).get("buffer")).get("type").toString();
            if (contentType.equals("Buffer") && path != null) {
                JSONArray content = (JSONArray)((JSONObject)((JSONObject)args.get(1)).get("buffer")).get("data");
                byte[] bytes = new byte[content.size()];
                for (int i = 0; i < content.size(); ++i) {
                    int value = content.getIntValue(i);
                    bytes[i] = (byte)value;
                }
                ThreadManager.getInstance().runUiThread(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    VirtualFile file = FileUtils.createNewFile(path);
                    if (file == null) {
                        LogManager.warn(MainThreadFileSystem.class, "Failed to create or locate VirtualFile: " + path);
                        complete.accept(null);
                        return;
                    }
                    if (file.isWritable()) {
                        MainThreadFileSystem.writeBytesOptimized(file, bytes);
                        LogManager.info(MainThreadFileSystem.class, "File write success:" + path);
                        complete.accept(null);
                    } else {
                        LogManager.warn(MainThreadFileSystem.class, "VirtualFile is not writable: " + path);
                        complete.accept(null);
                    }
                }));
            }
        }
        catch (Exception e) {
            complete.accept(null);
            LogManager.warn(MainThreadFileSystem.class, "write file error:" + e.getMessage());
        }
    }

    private static void writeBytesOptimized(VirtualFile vf, byte[] data) {
        if (data.length < 0xA00000) {
            MainThreadFileSystem.writeWithBuffer(vf, data);
        } else if (MainThreadFileSystem.isMemoryMappingSupported(vf)) {
            MainThreadFileSystem.writeWithMemoryMapping(vf, data);
        } else {
            MainThreadFileSystem.writeWithOutputStream(vf, data);
        }
    }

    private static void writeWithBuffer(VirtualFile vf, byte[] data) {
        try (BufferedOutputStream os = new BufferedOutputStream(vf.getOutputStream(null));){
            os.write(data);
        }
        catch (IOException e) {
            MainThreadFileSystem.handleException(e);
        }
    }

    private static void writeWithMemoryMapping(VirtualFile vf, byte[] data) {
        try {
            Path path = MainThreadFileSystem.getPathFromVirtualFile(vf);
            if (path == null) {
                throw new IOException("NIO path not available");
            }
            try (FileChannel channel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, data.length);
                buffer.put(data);
                buffer.force();
            }
        }
        catch (IOException e) {
            MainThreadFileSystem.handleException(e);
        }
    }

    private static void writeWithOutputStream(VirtualFile vf, byte[] data) {
        try (OutputStream os = vf.getOutputStream(null);){
            int length;
            int chunkSize = 65536;
            for (int offset = 0; offset < data.length; offset += length) {
                length = Math.min(chunkSize, data.length - offset);
                os.write(data, offset, length);
            }
        }
        catch (IOException e) {
            MainThreadFileSystem.handleException(e);
        }
    }

    private static boolean isMemoryMappingSupported(VirtualFile vf) {
        try {
            Path path = MainThreadFileSystem.getPathFromVirtualFile(vf);
            if (path == null) {
                return false;
            }
            return Files.isWritable(path);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Path getPathFromVirtualFile(VirtualFile vf) {
        try {
            if (vf instanceof VirtualFileWithId) {
                return Paths.get(vf.getPath(), new String[0]);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void handleException(IOException e) {
        LogManager.warn(MainThreadFileSystem.class, "\u6587\u4ef6\u5199\u5165\u9519\u8bef: " + e.getMessage());
    }
}

