/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.keybinding;

import com.alibaba.fastjson2.annotation.JSONField;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.tencent.code.intel.apibridge.extension.mainthread.context.contextexpression.ContextExpression;
import com.tencent.code.intel.bean.BaseBean;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.util.JsonRpcUtils;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Locale;
import javax.swing.KeyStroke;

public class KeyBindingRule
extends BaseBean {
    private String key;
    private String win;
    private String mac;
    private String linux;
    private String jbMac;
    private String jbWin;
    private String command;
    private String when;
    private String title;
    private Object args;
    @JSONField(serialize=false)
    private ContextExpression realRule;
    @JSONField(serialize=false)
    private Project project;

    public ContextExpression getRealRule() {
        if (this.realRule == null) {
            this.realRule = JsonRpcUtils.parseObject(this.when, ContextExpression.class);
            this.realRule.setProject(this.project);
        }
        return this.realRule;
    }

    public KeyStroke getKeyStroke() {
        String key = this.getKey();
        if (SystemInfo.isMac && this.getJbMac() != null) {
            key = this.getJbMac();
        } else if (SystemInfo.isMac && this.getMac() != null) {
            key = this.getMac();
        } else if (SystemInfo.isWindows && this.getJbWin() != null) {
            key = this.getJbWin();
        } else if (SystemInfo.isWindows && this.getWin() != null) {
            key = this.getWin();
        } else if (this.getLinux() != null) {
            key = this.getLinux();
        }
        try {
            return this.parse(key);
        }
        catch (Exception e) {
            LogManager.info(KeyBindingRule.class, "parse key binding failed: " + key + e.getMessage());
            return null;
        }
    }

    public KeyStroke parse(String shortcutStr) {
        String[] parts = shortcutStr.split("\\+");
        if (parts.length == 0) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u5feb\u6377\u952e\u683c\u5f0f: " + shortcutStr);
        }
        int modifiers = 0;
        String keyStr = parts[parts.length - 1];
        block13: for (int i = 0; i < parts.length - 1; ++i) {
            String modifier;
            switch (modifier = parts[i].trim().toLowerCase(Locale.ROOT)) {
                case "cmd": 
                case "meta": {
                    modifiers |= 0x100;
                    continue block13;
                }
                case "ctrl": {
                    modifiers |= 0x80;
                    continue block13;
                }
                case "shift": {
                    modifiers |= 0x40;
                    continue block13;
                }
                case "alt": {
                    modifiers |= 0x200;
                    continue block13;
                }
                default: {
                    throw new IllegalArgumentException("\u672a\u77e5\u4fee\u9970\u7b26: " + modifier);
                }
            }
        }
        int keyCode = this.parseKeyCode(keyStr.trim());
        return KeyStroke.getKeyStroke(keyCode, modifiers);
    }

    private int parseKeyCode(String keyStr) {
        if (keyStr.length() == 1 && Character.isLetterOrDigit(keyStr.charAt(0))) {
            return keyStr.toUpperCase(Locale.ROOT).charAt(0);
        }
        try {
            String fieldName = "VK_" + keyStr.toUpperCase(Locale.ROOT);
            Field field = KeyEvent.class.getDeclaredField(fieldName);
            return field.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u6309\u952e: " + keyStr);
        }
    }

    public String getId() {
        return this.command;
    }

    public String getTitle() {
        return this.title.isEmpty() ? this.command : this.title;
    }

    public String getKey() {
        return this.key;
    }

    public String getWin() {
        return this.win;
    }

    public String getMac() {
        return this.mac;
    }

    public String getLinux() {
        return this.linux;
    }

    public String getJbMac() {
        return this.jbMac;
    }

    public String getJbWin() {
        return this.jbWin;
    }

    public String getCommand() {
        return this.command;
    }

    public String getWhen() {
        return this.when;
    }

    public Object getArgs() {
        return this.args;
    }

    public Project getProject() {
        return this.project;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setWin(String win) {
        this.win = win;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setLinux(String linux) {
        this.linux = linux;
    }

    public void setJbMac(String jbMac) {
        this.jbMac = jbMac;
    }

    public void setJbWin(String jbWin) {
        this.jbWin = jbWin;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setWhen(String when) {
        this.when = when;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setArgs(Object args) {
        this.args = args;
    }

    public void setRealRule(ContextExpression realRule) {
        this.realRule = realRule;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String toString() {
        return "KeyBindingRule(key=" + this.getKey() + ", win=" + this.getWin() + ", mac=" + this.getMac() + ", linux=" + this.getLinux() + ", jbMac=" + this.getJbMac() + ", jbWin=" + this.getJbWin() + ", command=" + this.getCommand() + ", when=" + this.getWhen() + ", title=" + this.getTitle() + ", args=" + String.valueOf(this.getArgs()) + ", realRule=" + String.valueOf(this.getRealRule()) + ", project=" + String.valueOf(this.getProject()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyBindingRule)) {
            return false;
        }
        KeyBindingRule other = (KeyBindingRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$win = this.getWin();
        String other$win = other.getWin();
        if (this$win == null ? other$win != null : !this$win.equals(other$win)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$linux = this.getLinux();
        String other$linux = other.getLinux();
        if (this$linux == null ? other$linux != null : !this$linux.equals(other$linux)) {
            return false;
        }
        String this$jbMac = this.getJbMac();
        String other$jbMac = other.getJbMac();
        if (this$jbMac == null ? other$jbMac != null : !this$jbMac.equals(other$jbMac)) {
            return false;
        }
        String this$jbWin = this.getJbWin();
        String other$jbWin = other.getJbWin();
        if (this$jbWin == null ? other$jbWin != null : !this$jbWin.equals(other$jbWin)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$when = this.getWhen();
        String other$when = other.getWhen();
        if (this$when == null ? other$when != null : !this$when.equals(other$when)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        Object this$args = this.getArgs();
        Object other$args = other.getArgs();
        if (this$args == null ? other$args != null : !this$args.equals(other$args)) {
            return false;
        }
        ContextExpression this$realRule = this.getRealRule();
        ContextExpression other$realRule = other.getRealRule();
        if (this$realRule == null ? other$realRule != null : !((Object)this$realRule).equals(other$realRule)) {
            return false;
        }
        Project this$project = this.getProject();
        Project other$project = other.getProject();
        return !(this$project == null ? other$project != null : !this$project.equals(other$project));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyBindingRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $win = this.getWin();
        result = result * 59 + ($win == null ? 43 : $win.hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $linux = this.getLinux();
        result = result * 59 + ($linux == null ? 43 : $linux.hashCode());
        String $jbMac = this.getJbMac();
        result = result * 59 + ($jbMac == null ? 43 : $jbMac.hashCode());
        String $jbWin = this.getJbWin();
        result = result * 59 + ($jbWin == null ? 43 : $jbWin.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $when = this.getWhen();
        result = result * 59 + ($when == null ? 43 : $when.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        Object $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : $args.hashCode());
        ContextExpression $realRule = this.getRealRule();
        result = result * 59 + ($realRule == null ? 43 : ((Object)$realRule).hashCode());
        Project $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        return result;
    }
}

