/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.keybinding;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.tencent.code.intel.action.base.BaseAnAction;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.keybinding.KeyBindingRule;
import com.tencent.code.intel.apibridge.extension.mainthread.keybinding.MenuRule;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.impl.CopilotSettingsService;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.listener.CopilotLookupManagerListener;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class KeyBindingService
extends MainThreadBaseProxy {
    private static final Map<Project, Set<String>> PROJECT_ACTIONS = new ConcurrentHashMap<Project, Set<String>>();
    private static final Map<Project, Set<String>> PROJECT_MENU_GROUPS = new ConcurrentHashMap<Project, Set<String>>();
    private static final Map<Project, Map<String, KeyBindingRule>> RULES_BY_PROJECT = new ConcurrentHashMap<Project, Map<String, KeyBindingRule>>();
    private static final Set<String> GLOBAL_ACTIONS = ConcurrentHashMap.newKeySet();
    private static final Set<String> KEYMAP_BOUND = ConcurrentHashMap.newKeySet();
    private static final String CODE_BUDDY_MENU_ID_PREFIX = "CodeBuddyEditorMenu_";
    private static final String CODE_BUDDY_MENU_TITLE = LocaleManager.get("plugin.copilot.name");
    private static final PluginId PLUGIN_ID = PluginId.getId((String)LocaleManager.get("plugin.id"));
    private static final Disposable GLOBAL_DISPOSABLE = Disposer.newDisposable((String)"KeyBindingService");

    public KeyBindingService() {
        ProjectManager.getInstance().addProjectManagerListener(new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                KeyBindingService.this.cleanupProjectActions(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/tencent/code/intel/apibridge/extension/mainthread/keybinding/KeyBindingService$1", "projectClosed"));
            }
        });
    }

    private void cleanupProjectActions(Project project) {
        Set<String> projectMenuGroups;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorPopupMenu = (DefaultActionGroup)actionManager.getAction("EditorPopupMenu");
        RULES_BY_PROJECT.remove(project);
        Set<String> projectActions = PROJECT_ACTIONS.remove(project);
        if (projectActions != null) {
            for (String actionId : projectActions) {
                AnAction action;
                if (!actionId.contains("_" + project.getLocationHash()) || (action = actionManager.getAction(actionId)) == null) continue;
                actionManager.unregisterAction(actionId);
            }
        }
        if ((projectMenuGroups = PROJECT_MENU_GROUPS.remove(project)) != null) {
            for (String groupId : projectMenuGroups) {
                AnAction group = actionManager.getAction(groupId);
                if (editorPopupMenu != null && group != null && editorPopupMenu.containsAction(group)) {
                    editorPopupMenu.remove(group);
                }
                if (group == null) continue;
                actionManager.unregisterAction(groupId);
            }
        }
        LogManager.info(KeyBindingService.class, "\u5df2\u6e05\u7406\u9879\u76ee " + project.getName() + " \u7684\u6240\u6709 actions \u548c\u83dc\u5355");
    }

    private KeyBindingRule getProjectRule(Project project, String actionId) {
        Map<String, KeyBindingRule> rules = RULES_BY_PROJECT.get(project);
        return rules == null ? null : rules.get(actionId);
    }

    private String getProjectMenuId(Project project) {
        return CODE_BUDDY_MENU_ID_PREFIX + project.getLocationHash();
    }

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$updateKeyBindings": {
                this.registerKeyBindingActions(project, args, complete);
                break;
            }
            case "$updateMenu": {
                this.registerRightMenuActions(project, args, complete);
                break;
            }
            case "$updatePackageInfo": {
                this.registerPackageInfo(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void registerPackageInfo(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            if (args == null || args.isEmpty()) {
                complete.accept(false);
                return;
            }
            String publisher = ((JSONObject)args.get(0)).getString("publisher");
            FusionActionUtils.setPublisher(publisher);
            complete.accept(true);
        }
        catch (Exception e) {
            LogManager.info(KeyBindingService.class, "register publisher failed: " + e.getMessage());
            complete.accept(false);
        }
    }

    private void registerRightMenuActions(final Project project, List<Object> menus, Consumer<Object> complete) {
        try {
            if (menus == null || menus.isEmpty()) {
                complete.accept(false);
                return;
            }
            List<MenuRule> menuRules = menus.stream().filter(menu -> menu instanceof List).flatMap(menu -> ((List)menu).stream()).map(menu -> (MenuRule)JSONObject.from((Object)menu).toJavaObject(MenuRule.class, new JSONReader.Feature[0])).collect(Collectors.toList());
            menuRules.forEach(menu -> menu.setProject(project));
            ThreadManager.getInstance().runUiThreadSave(() -> {
                ActionManager actionManager = ActionManager.getInstance();
                DefaultActionGroup editorPopupMenu = (DefaultActionGroup)actionManager.getAction("EditorPopupMenu");
                String projectMenuId = this.getProjectMenuId(project);
                DefaultActionGroup codeBuddyMenu = new DefaultActionGroup(CODE_BUDDY_MENU_TITLE, true){

                    public void update(@NotNull AnActionEvent e) {
                        Project currentProject;
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                            e.getPresentation().setEnabled(false);
                            e.getPresentation().setVisible(false);
                            return;
                        }
                        e.getPresentation().setEnabled(true);
                        e.getPresentation().setText(CODE_BUDDY_MENU_TITLE);
                    }

                    @NotNull
                    public ActionUpdateThread getActionUpdateThread() {
                        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                        if (actionUpdateThread == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return actionUpdateThread;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "e";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/tencent/code/intel/apibridge/extension/mainthread/keybinding/KeyBindingService$2";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/keybinding/KeyBindingService$2";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getActionUpdateThread";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "update";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                menuRules.sort((menu1, menu2) -> {
                    if (menu1.getRealGroup().equals(menu2.getRealGroup())) {
                        return menu1.getPriority() >= menu2.getPriority() ? -1 : 1;
                    }
                    return menu2.getRealGroup().compareTo(menu1.getRealGroup());
                });
                AtomicReference<Object> group = new AtomicReference<Object>((menuRules.isEmpty() ? null : ((MenuRule)menuRules.get(0)).getRealGroup()));
                for (MenuRule menuRule : menuRules) {
                    if (group.get() != null && !menuRule.getRealGroup().equals(group.get())) {
                        codeBuddyMenu.add((AnAction)Separator.create());
                    }
                    group.set(menuRule.getRealGroup());
                    AnAction action = this.traitMenuAction(project, menuRule);
                    codeBuddyMenu.add(action);
                }
                codeBuddyMenu.getTemplatePresentation().setText(CODE_BUDDY_MENU_TITLE);
                codeBuddyMenu.setPopup(true);
                AnAction existingMenu = actionManager.getAction(projectMenuId);
                if (existingMenu != null) {
                    if (editorPopupMenu != null && editorPopupMenu.containsAction(existingMenu)) {
                        editorPopupMenu.remove(existingMenu);
                    }
                    actionManager.unregisterAction(projectMenuId);
                }
                actionManager.registerAction(projectMenuId, (AnAction)codeBuddyMenu);
                if (editorPopupMenu != null) {
                    editorPopupMenu.add((AnAction)codeBuddyMenu, Constraints.FIRST);
                }
                PROJECT_MENU_GROUPS.computeIfAbsent(project, k -> new HashSet()).add(projectMenuId);
                complete.accept(true);
            });
        }
        catch (Exception e) {
            LogManager.info(KeyBindingService.class, "register menu rule failed" + e.getMessage());
            complete.accept(false);
        }
    }

    public void registerKeyBindingActions(Project project, List<Object> keybindings, Consumer<Object> complete) {
        try {
            if (keybindings == null || keybindings.isEmpty()) {
                complete.accept(false);
                return;
            }
            List<KeyBindingRule> rules = keybindings.stream().filter(keybinding -> keybinding instanceof List).flatMap(keybinding -> ((List)keybinding).stream()).map(keybinding -> (KeyBindingRule)JSONObject.from((Object)keybinding).toJavaObject(KeyBindingRule.class, new JSONReader.Feature[0])).collect(Collectors.toList());
            rules.forEach(rule -> rule.setProject(project));
            Map ruleMap = RULES_BY_PROJECT.computeIfAbsent(project, p -> new ConcurrentHashMap());
            for (KeyBindingRule rule2 : rules) {
                ruleMap.put(rule2.getId(), rule2);
            }
            ThreadManager.getInstance().runUiThreadSave(() -> {
                rules.forEach(rule -> this.registerKeyBindingRule(project, (KeyBindingRule)rule));
                complete.accept(true);
            });
        }
        catch (Exception e) {
            LogManager.info(KeyBindingService.class, "register rule failed: " + e.getMessage());
            complete.accept(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerKeyBindingRule(Project project, KeyBindingRule rule) {
        ActionManager actionManager = ActionManager.getInstance();
        final String actionId = rule.getId();
        String command = rule.getCommand();
        final String acceptAllCommand = FusionActionUtils.getInternalCommandId("codingcopilot.completions.accept.all");
        if (!GLOBAL_ACTIONS.contains(actionId)) {
            Set<String> set = GLOBAL_ACTIONS;
            synchronized (set) {
                if (!GLOBAL_ACTIONS.contains(actionId)) {
                    if (actionManager.getAction(actionId) != null) {
                        actionManager.unregisterAction(actionId);
                    }
                    BaseAnAction action = new BaseAnAction(rule.getTitle()){

                        public void update(@NotNull AnActionEvent e) {
                            Project currentProject;
                            if (e == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            if ((currentProject = e.getProject()) == null || currentProject.isDisposed()) {
                                e.getPresentation().setEnabled(false);
                                return;
                            }
                            KeyBindingRule projectRule = KeyBindingService.this.getProjectRule(currentProject, actionId);
                            if (projectRule == null) {
                                e.getPresentation().setEnabled(false);
                                return;
                            }
                            boolean ruleEnabled = projectRule.getRealRule().evaluate();
                            if (acceptAllCommand.equals(projectRule.getCommand()) && ruleEnabled) {
                                Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
                                boolean hasInlay = !CollectionUtils.isEmpty(InlayService.getInstance().getAllInlays());
                                boolean isSideBySide = CopilotSettingsService.getInstance().isSideBySideEnable();
                                if (hasInlay && isSideBySide && editor != null && CopilotLookupManagerListener.hasLookUp(editor)) {
                                    boolean preferInlineCompletionEnable = CopilotSettingsService.getInstance().isPreferInlineCompletionEnable();
                                    e.getPresentation().setEnabled(preferInlineCompletionEnable);
                                } else {
                                    e.getPresentation().setEnabled(hasInlay);
                                }
                                return;
                            }
                            e.getPresentation().setEnabled(ruleEnabled);
                        }

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            Project currentProject;
                            if (e == null) {
                                3.$$$reportNull$$$0(1);
                            }
                            if ((currentProject = e.getProject()) == null || currentProject.isDisposed()) {
                                return;
                            }
                            KeyBindingRule projectRule = KeyBindingService.this.getProjectRule(currentProject, actionId);
                            if (projectRule == null) {
                                return;
                            }
                            List<Object> args = projectRule.getArgs() == null ? Collections.emptyList() : List.of(projectRule.getArgs());
                            ExtHostCommands.executeCommand(currentProject, projectRule.getCommand(), args, jsonObject -> {});
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = "e";
                            objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/keybinding/KeyBindingService$3";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "update";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "actionPerformed";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    actionManager.registerAction(actionId, (AnAction)action, PLUGIN_ID);
                    GLOBAL_ACTIONS.add(actionId);
                }
            }
        }
        PROJECT_ACTIONS.computeIfAbsent(project, k -> new HashSet()).add(actionId);
        KeyStroke keyStroke = rule.getKeyStroke();
        if (keyStroke != null && !KEYMAP_BOUND.contains(actionId)) {
            Set<String> set = KEYMAP_BOUND;
            synchronized (set) {
                if (!KEYMAP_BOUND.contains(actionId)) {
                    KeymapManagerEx km = KeymapManagerEx.getInstanceEx();
                    for (Keymap keymap : km.getAllKeymaps()) {
                        KeyboardShortcut shortcut = new KeyboardShortcut(keyStroke, null);
                        boolean already = Arrays.stream(keymap.getShortcuts(actionId)).anyMatch(s -> s.equals(shortcut));
                        if (already) continue;
                        keymap.addShortcut(actionId, (Shortcut)shortcut);
                    }
                    KEYMAP_BOUND.add(actionId);
                    if (acceptAllCommand.equals(command) && keyStroke.getKeyCode() == 9) {
                        this.ensureTabEditorBinding(actionId, keyStroke);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureTabEditorBinding(String actionId, KeyStroke keyStroke) {
        String tabEditorKey = "tab_editor_" + actionId;
        if (KEYMAP_BOUND.contains(tabEditorKey)) {
            return;
        }
        Set<String> set = KEYMAP_BOUND;
        synchronized (set) {
            Editor[] editors;
            if (KEYMAP_BOUND.contains(tabEditorKey)) {
                return;
            }
            final AnAction action = ActionManager.getInstance().getAction(actionId);
            if (action == null) {
                return;
            }
            CustomShortcutSet shortcutSet = new CustomShortcutSet(keyStroke);
            for (Editor editor : editors = EditorFactory.getInstance().getAllEditors()) {
                this.bindTabToEditor(action, (ShortcutSet)shortcutSet, editor, actionId);
            }
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener((ShortcutSet)shortcutSet, actionId){
                final /* synthetic */ ShortcutSet val$shortcutSet;
                final /* synthetic */ String val$actionId;
                {
                    this.val$shortcutSet = shortcutSet;
                    this.val$actionId = string;
                }

                public void editorCreated(@NotNull EditorFactoryEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    KeyBindingService.this.bindTabToEditor(action, this.val$shortcutSet, event.getEditor(), this.val$actionId);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/tencent/code/intel/apibridge/extension/mainthread/keybinding/KeyBindingService$4", "editorCreated"));
                }
            }, GLOBAL_DISPOSABLE);
            KEYMAP_BOUND.add(tabEditorKey);
        }
    }

    private void bindTabToEditor(AnAction action, ShortcutSet shortcutSet, Editor editor, String actionId) {
        try {
            String propertyKey;
            if (editor == null) {
                return;
            }
            JComponent editorComponent = editor.getContentComponent();
            Object mark = editorComponent.getClientProperty(propertyKey = "cb.tab.bound." + actionId);
            if (Boolean.TRUE.equals(mark)) {
                return;
            }
            AnAction wrappedAction = EmptyAction.wrap((AnAction)action);
            wrappedAction.registerCustomShortcutSet(shortcutSet, editorComponent);
            editorComponent.putClientProperty(propertyKey, Boolean.TRUE);
            LogManager.info(KeyBindingService.class, "Tab shortcut bound to editor for action: " + actionId + ", project: " + (editor.getProject() != null ? editor.getProject().getName() : "null"));
        }
        catch (Exception e) {
            LogManager.error(KeyBindingService.class, "Failed to bind Tab shortcut to editor: " + e.getMessage());
        }
    }

    private AnAction traitMenuAction(final Project project, final MenuRule rule) {
        String projectActionId = "menuAction." + rule.getCommand() + "_" + project.getLocationHash();
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager.getAction(projectActionId) != null) {
            actionManager.unregisterAction(projectActionId);
        }
        BaseAnAction projectAction = new BaseAnAction(rule.getTitle()){

            public void update(@NotNull AnActionEvent e) {
                Project currentProject;
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setVisible(false);
                    return;
                }
                e.getPresentation().setEnabled(rule.getRealRule().evaluate());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project currentProject;
                if (e == null) {
                    5.$$$reportNull$$$0(1);
                }
                if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                    return;
                }
                VirtualFile file = KeyBindingService.this.getCurrTestFile(e);
                if (file == null) {
                    return;
                }
                if (file.isDirectory()) {
                    return;
                }
                ExtHostCommands.executeCommand(currentProject, rule.getCommand(), null, jsonObject -> {});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/keybinding/KeyBindingService$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        actionManager.registerAction(projectActionId, (AnAction)projectAction);
        PROJECT_ACTIONS.computeIfAbsent(project, k -> new HashSet()).add(projectActionId);
        return projectAction;
    }

    private VirtualFile getCurrTestFile(@NotNull AnActionEvent e) {
        VirtualFile[] fileList;
        if (e == null) {
            KeyBindingService.$$$reportNull$$$0(0);
        }
        if ((fileList = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) == null || fileList.length == 0) {
            return null;
        }
        return fileList[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/apibridge/extension/mainthread/keybinding/KeyBindingService", "getCurrTestFile"));
    }
}

