/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.languagefeature;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.tencent.code.intel.apibridge.extension.extension.command.CommandDto;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.ExtHostLanguageFeatures;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.IdentifiableInlineCompletions;
import com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.InlineCompletionContext;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.util.EditorUtils;
import com.tencent.code.intel.apibridge.util.PsiConverter;
import com.tencent.code.intel.bean.item.Position;
import com.tencent.code.intel.bean.item.VirtualFileUriBean;
import com.tencent.code.intel.common.EditorCommandName;
import com.tencent.code.intel.common.InlayAcceptMode;
import com.tencent.code.intel.common.InlayDisplayMode;
import com.tencent.code.intel.impl.InlayService;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.CollectionUtils;
import com.tencent.code.intel.util.CopilotEditorUtils;
import com.tencent.code.intel.util.JsonRpcUtils;
import com.tencent.code.intel.util.RegexUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.http.util.TextUtils;
import org.eclipse.lsp4j.DocumentSymbol;

public class MainThreadLanguageFeaturesService
extends MainThreadBaseProxy {
    private PsiConverter converter = new PsiConverter();
    private final String acceptInlineCompletion = "$acceptInlineCompletion";
    private final String provideDocumentSymbols = "$provideDocumentSymbols";
    private final String acceptInlineCompletionByLine = "$acceptInlineCompletionByLine";
    private final String acceptInlineCompletionByWord = "$acceptInlineCompletionByWord";
    private final String triggerInlineCompletions = "$triggerInlineCompletions";
    private final String provideCodeLenses = "$provideCodeLenses";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$acceptInlineCompletion": {
                this.acceptAll(ExtHostLanguageFeatures.currentEditors.get(project), project);
                super.handleReq(project, name, args, complete);
                break;
            }
            case "$acceptInlineCompletionByLine": {
                this.acceptByLine(ExtHostLanguageFeatures.currentEditors.get(project), project);
                super.handleReq(project, name, args, complete);
                break;
            }
            case "$acceptInlineCompletionByWord": {
                this.acceptByWord(ExtHostLanguageFeatures.currentEditors.get(project), project);
                super.handleReq(project, name, args, complete);
                break;
            }
            case "$provideDocumentSymbols": {
                String uri = (String)((JSONObject)args.get(0)).get("fsPath");
                ThreadManager.getInstance().runUiThreadSave(() -> {
                    VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + uri);
                    if (virtualFile == null || !virtualFile.exists()) {
                        complete.accept(null);
                        return;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    List<DocumentSymbol> documentSymbols = this.converter.convertPsiToDocumentSymbols(psiFile);
                    complete.accept(documentSymbols);
                });
                break;
            }
            case "$triggerInlineCompletions": {
                FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
                if (editor == null) {
                    LogManager.warn(MainThreadLanguageFeaturesService.class, "triggerInlineCompletions editor is null");
                    complete.accept(null);
                    return;
                }
                String uri = EditorUtils.getFilePath(editor.getFile());
                if (TextUtils.isEmpty((CharSequence)uri)) {
                    LogManager.warn(MainThreadLanguageFeaturesService.class, "triggerInlineCompletions uri is empty");
                    complete.accept(null);
                    return;
                }
                ThreadManager.getInstance().runUiThread(() -> this.handleManualTriggerCompletions(project, editor, uri, complete));
                break;
            }
            case "$provideCodeLenses": {
                FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor();
                if (fileEditor instanceof TextEditor) {
                    Editor editor = ((TextEditor)fileEditor).getEditor();
                    String uri = VirtualFileUriBean.from(fileEditor.getFile()).getUri();
                    ExtHostLanguageFeatures.debounceProvideCodeLenses(project, editor, uri, null);
                }
                complete.accept(null);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    public void acceptAll(Editor editor, Project project) {
        if (project == null || editor == null) {
            return;
        }
        try {
            String remainText = ExtHostLanguageFeatures.remainText.get(project);
            if (TextUtils.isEmpty((CharSequence)remainText)) {
                return;
            }
            JSONObject currItem = this.getCurrCompletionsItem(project);
            InlineCompletionContext.IRange itemRange = null;
            IdentifiableInlineCompletions.Item inlineItem = null;
            if (currItem != null && (inlineItem = JsonRpcUtils.toJavaObject(currItem, IdentifiableInlineCompletions.Item.class)) != null) {
                itemRange = inlineItem.getRange();
            }
            if (itemRange == null) {
                LogManager.warn(this.getClass(), "item range is null,cannot accept all text");
                return;
            }
            InlineCompletionContext.IRange finalRange = itemRange;
            IdentifiableInlineCompletions.Item finalInlineItem = inlineItem;
            WriteCommandAction.runWriteCommandAction((Project)project, (String)EditorCommandName.TRIGGER_COMPLETION.ACCEPT_COMPLETION.getName(), (String)"", () -> {
                Document document = editor.getDocument();
                int startOffset = this.toOffset(document, finalRange.getStartLineNumber(), finalRange.getStartColumn());
                int endOffset = this.toOffset(document, finalRange.getEndLineNumber(), finalRange.getEndColumn());
                if (endOffset < startOffset) {
                    int tmp = startOffset;
                    startOffset = endOffset;
                    endOffset = tmp;
                }
                String textToApply = finalInlineItem.getInsertText() != null ? finalInlineItem.getInsertText() : remainText;
                document.replaceString(startOffset, endOffset, (CharSequence)textToApply);
                editor.getCaretModel().getPrimaryCaret().moveToOffset(startOffset + textToApply.length());
                InlayService.getInstance().disposePreviewInsertionHint(true);
                InlayService.getInstance().disposeAllInlays();
                try {
                    CommandDto commandDto = JsonRpcUtils.toJavaObject(currItem.getJSONObject("command"), CommandDto.class);
                    ExtHostCommands.executeDtoCommand(project, commandDto, object -> {});
                }
                catch (Exception ex) {
                    LogManager.warn(MainThreadLanguageFeaturesService.class, "accept all report, " + String.valueOf(ex));
                }
            }, (PsiFile[])new PsiFile[0]);
            ExtHostLanguageFeatures.clear(project);
            return;
        }
        catch (Exception e) {
            LogManager.warn(MainThreadLanguageFeaturesService.class, "accept all , " + String.valueOf(e));
            return;
        }
    }

    private int toOffset(Document document, Integer lineNumber1Based, Integer column1Based) {
        if (document == null) {
            return 0;
        }
        int lineIndex = lineNumber1Based != null ? lineNumber1Based - 1 : 0;
        lineIndex = Math.max(0, Math.min(lineIndex, document.getLineCount() - 1));
        int columnIndex = column1Based != null ? column1Based - 1 : 0;
        columnIndex = Math.max(0, columnIndex);
        int lineStart = document.getLineStartOffset(lineIndex);
        int lineEnd = document.getLineEndOffset(lineIndex);
        return Math.min(lineStart + columnIndex, lineEnd);
    }

    public void acceptByLine(Editor editor, Project project) {
        if (project == null || editor == null) {
            return;
        }
        try {
            String remainText = ExtHostLanguageFeatures.remainText.get(project);
            if (TextUtils.isEmpty((CharSequence)remainText)) {
                return;
            }
            String contentToAccept = this.findContentToAccept(remainText);
            if (TextUtils.isEmpty((CharSequence)contentToAccept) || contentToAccept.equals("\n")) {
                return;
            }
            String newRemainText = remainText.substring(contentToAccept.length());
            ExtHostLanguageFeatures.remainText.put(project, newRemainText);
            String finalContentToAccept = contentToAccept;
            String finalRemainText = newRemainText;
            WriteCommandAction.runWriteCommandAction((Project)project, (String)EditorCommandName.IGNORE_COMPLETION.ACCEPT_COMPLETION_BY_LINE.getName(), (String)"", () -> {
                Document document = editor.getDocument();
                int caretOffset = editor.getCaretModel().getPrimaryCaret().getOffset();
                document.insertString(caretOffset, (CharSequence)finalContentToAccept);
                int newCaretOffset = caretOffset + finalContentToAccept.length();
                editor.getCaretModel().getPrimaryCaret().moveToOffset(newCaretOffset);
                if (TextUtils.isEmpty((CharSequence)finalRemainText)) {
                    InlayService.getInstance().disposePreviewInsertionHint(true);
                    InlayService.getInstance().disposeAllInlays();
                    ExtHostLanguageFeatures.clear(project);
                } else {
                    int tabSize = editor.getSettings().getTabSize(editor.getProject());
                    List<String> lays = Arrays.asList(finalRemainText.split("\n"));
                    ThreadManager.getInstance().runUiThread(() -> InlayService.getInstance().display(editor, document.getText(), newCaretOffset, lays, InlayDisplayMode.AfterLineAndBlock, InlayAcceptMode.LINE, tabSize, false));
                }
            }, (PsiFile[])new PsiFile[0]);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadLanguageFeaturesService.class, "accept by line v2, " + String.valueOf(e));
        }
    }

    private String findContentToAccept(String remainText) {
        if (TextUtils.isEmpty((CharSequence)remainText)) {
            return "";
        }
        String text = remainText;
        while (text.startsWith("\n")) {
            text = text.substring(1);
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        int newlineIndex = text.indexOf(10);
        String contentToAccept = newlineIndex > 0 ? text.substring(0, newlineIndex) : text;
        if (TextUtils.isEmpty((CharSequence)contentToAccept.trim())) {
            return "";
        }
        String prefixToSkip = remainText.substring(0, remainText.indexOf(text));
        String actualContentToAccept = prefixToSkip + contentToAccept;
        if (newlineIndex > 0 && newlineIndex < text.length() - 1) {
            actualContentToAccept = actualContentToAccept + "\n";
        }
        return actualContentToAccept;
    }

    public void acceptByWord(Editor editor, Project project) {
        if (project == null || editor == null) {
            return;
        }
        try {
            String remainText = ExtHostLanguageFeatures.remainText.get(project);
            if (TextUtils.isEmpty((CharSequence)remainText)) {
                return;
            }
            Document document = editor.getDocument();
            List<String> words = RegexUtils.splitCompletionTextByWord(remainText);
            String acceptWord = "";
            if (!words.isEmpty()) {
                acceptWord = remainText.substring(0, remainText.indexOf(words.get(0)) + words.get(0).length());
                String indentString = RegexUtils.getLeadingIndentation(acceptWord);
                if (!TextUtils.isEmpty((CharSequence)indentString)) {
                    acceptWord = remainText.substring(0, indentString.length());
                }
                ExtHostLanguageFeatures.remainText.put(project, remainText.substring(acceptWord.length()));
            }
            String insertContent = acceptWord;
            String remainContent = ExtHostLanguageFeatures.remainText.get(project);
            WriteCommandAction.runWriteCommandAction((Project)project, (String)EditorCommandName.IGNORE_COMPLETION.ACCEPT_COMPLETION_BY_WORD.getName(), (String)"", () -> {
                int indexOffset = editor.getCaretModel().getPrimaryCaret().getOffset();
                int tabSize = editor.getSettings().getTabSize(editor.getProject());
                document.insertString(indexOffset, (CharSequence)insertContent);
                editor.getCaretModel().getPrimaryCaret().moveToOffset(indexOffset += insertContent.length());
                if (TextUtils.isEmpty((CharSequence)remainContent)) {
                    InlayService.getInstance().disposePreviewInsertionHint(true);
                    InlayService.getInstance().disposeAllInlays();
                    ExtHostLanguageFeatures.clear(project);
                } else {
                    int finalIndexOffset = indexOffset;
                    List<String> lays = Arrays.asList(remainContent.split("\n"));
                    InlayDisplayMode inlayDisplayMode = lays.size() == 1 ? InlayDisplayMode.AfterLine : InlayDisplayMode.AfterLineAndBlock;
                    ThreadManager.getInstance().runUiThread(() -> InlayService.getInstance().display(editor, document.getText(), finalIndexOffset, lays, inlayDisplayMode, InlayAcceptMode.WORD, tabSize, false));
                }
            }, (PsiFile[])new PsiFile[0]);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadLanguageFeaturesService.class, "accept by word, " + String.valueOf(e));
        }
    }

    public JSONObject getCurrCompletionsItem(Project project) {
        JSONObject completions = ExtHostLanguageFeatures.currentInlineCompletions.get(project);
        JSONArray completionsItems = (JSONArray)completions.get("items");
        if (CollectionUtils.isEmpty((Collection)completionsItems)) {
            return null;
        }
        return (JSONObject)completionsItems.get(0);
    }

    private void handleManualTriggerCompletions(Project project, FileEditor fileEditor, String uri, Consumer<Object> complete) {
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        if (!CopilotEditorUtils.isSelectedEditor(editor)) {
            return;
        }
        PsiFile psiFile = CopilotEditorUtils.getPsiFile(editor);
        if (psiFile == null) {
            return;
        }
        int caretOffset = editor.getCaretModel().getPrimaryCaret().getOffset();
        if (!CopilotEditorUtils.isEditorReadWrite(editor, caretOffset)) {
            return;
        }
        com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.Position position = new com.tencent.code.intel.apibridge.extension.extension.languagefeatures.inlinecompletion.Position();
        Position itemPosition = EditorUtils.position(editor.getDocument(), caretOffset);
        position.setColumn(itemPosition.getCharacter() + 1);
        position.setLineNumber(itemPosition.getLine() + 1);
        ExtHostLanguageFeatures.provideInlineCompletions(project, NodeRunner.getInstance(project).getRpcChannel(), uri, position, editor, 1, complete);
    }
}

