/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.lifecycle;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.configuration.SettingService;
import com.tencent.code.intel.apibridge.extension.extension.configuration.ExtHostConfiguration;
import com.tencent.code.intel.apibridge.extension.extension.lifecycle.ExtHostLifeCycle;
import com.tencent.code.intel.apibridge.extension.extension.workspace.ExtHostWorkspace;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.report.FusionTelemetryMeterEvent;
import com.tencent.code.intel.apibridge.report.FusionTelemetryMeterService;
import com.tencent.code.intel.apibridge.report.FusionTelemetrySpanService;
import com.tencent.code.intel.apibridge.report.model.Event;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadLifeCycle
extends MainThreadBaseProxy {
    public final String RPC_READY = "$onRPCReady";
    public final String EXT_READY = "$onExtensionReady";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$onRPCReady": {
                this.setupRPCMap(project, args);
                ExtHostLifeCycle.onConfigReady(project);
                complete.accept(null);
                NodeRunner.getInstance(project).rpcChannelReady();
                ExtHostWorkspace.initializeWorkspace(project, NodeRunner.getInstance(project).getRpcChannel());
                this.reportRpcReady(project);
                break;
            }
            case "$onExtensionReady": {
                ExtHostConfiguration.acceptConfigurationChanged(project, SettingService.getInstance().getKeyList());
                complete.accept(null);
                this.reportExtReady(project);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void setupRPCMap(Project project, List<Object> args) {
        if (args.size() < 2) {
            return;
        }
        NodeRunner.getInstance(project).getRpcChannel().configRPCMap(args.get(0), args.get(1));
    }

    private void reportRpcReady(Project project) {
        FusionTelemetrySpanService spanService;
        Event event = new Event();
        FusionTelemetryMeterService meterService = FusionTelemetryMeterService.getInstance(project);
        if (meterService != null) {
            meterService.report(FusionTelemetryMeterEvent.NODE_EVENT_LOAD_SUCCESS, event);
        }
        if ((spanService = FusionTelemetrySpanService.getInstance(project)) != null) {
            spanService.reportLog("RPC Ready");
        }
    }

    private void reportExtReady(Project project) {
        FusionTelemetrySpanService spanService;
        Event event = new Event();
        FusionTelemetryMeterService meterService = FusionTelemetryMeterService.getInstance(project);
        if (meterService != null) {
            meterService.report(FusionTelemetryMeterEvent.NODE_EVENT_EXTENSION_SUCCESS, event);
        }
        if ((spanService = FusionTelemetrySpanService.getInstance(project)) != null) {
            spanService.reportLog("Extension Load Ready");
        }
    }
}

