/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.log;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.manager.LogManager;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MainThreadLogService
extends MainThreadBaseProxy {
    private static final String FUSION_LOG_NAME = "fusion.log";
    private static final int LOG_LEVEL_INFO = 0;
    private static final int LOG_LEVEL_WARNING = 1;
    private static final int LOG_LEVEL_ERROR = 2;
    private static final int LOG_LEVEL_DEBUG = 3;

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$log": {
                this.log(project, args, complete);
                break;
            }
            case "$provideExtraLoggerPaths": {
                this.provideExtraLoggerPaths(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void log(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 2) {
            LogManager.warn(MainThreadLogService.class, "log args size < 2");
            complete.accept(null);
            return;
        }
        int type = Integer.parseInt(args.get(0).toString());
        String message = args.get(1).toString();
        switch (type) {
            case 0: {
                LogManager.info(this.getClass(), message);
                break;
            }
            case 1: {
                LogManager.warn(this.getClass(), message);
                break;
            }
            case 2: {
                LogManager.error(this.getClass(), message);
                break;
            }
            case 3: {
                LogManager.debug(this.getClass(), message);
                break;
            }
            default: {
                LogManager.warn(MainThreadLogService.class, "log type out of range: " + type);
            }
        }
        complete.accept(null);
    }

    private void provideExtraLoggerPaths(Project project, List<Object> args, Consumer<Object> complete) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            String logPath = PathManager.getLogPath();
            String ideaLogFile = Paths.get(logPath, "idea.log").toString();
            paths.add(ideaLogFile);
            Path fusionLogDir = Paths.get(logPath, "fusion", "logs");
            List<Path> findTodayLogFolders = this.findTodayLogFolders(fusionLogDir);
            paths.addAll(findTodayLogFolders.stream().map(Path::toString).collect(Collectors.toList()));
            complete.accept(paths);
        }
        catch (Exception e) {
            LogManager.error(MainThreadLogService.class, "Error providing extra logger paths " + String.valueOf(e));
            complete.accept(paths);
        }
    }

    private List<Path> findTodayLogFolders(Path fusionLogDir) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        LocalDate today = LocalDate.now();
        try (DirectoryStream<Path> uuidDirs = Files.newDirectoryStream(fusionLogDir);){
            for (Path uuidDir : uuidDirs) {
                LocalDate fileDate;
                Path logFile;
                if (!Files.isDirectory(uuidDir, new LinkOption[0]) || !Files.isRegularFile(logFile = uuidDir.resolve(FUSION_LOG_NAME), new LinkOption[0]) || !(fileDate = Files.getLastModifiedTime(logFile, new LinkOption[0]).toInstant().atZone(ZoneId.systemDefault()).toLocalDate()).equals(today)) continue;
                result.add(uuidDir);
            }
        }
        return result;
    }
}

