/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.message;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.tencent.code.intel.action.base.BaseAnAction;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.message.model.MainThreadMessageCommand;
import com.tencent.code.intel.apibridge.extension.mainthread.message.model.MainThreadMessageOptions;
import com.tencent.code.intel.common.PluginInfo;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MainThreadMessageService
extends MainThreadBaseProxy {
    private static final String SHOW_MESSAGE = "$showMessage";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$showMessage": {
                ThreadManager.getInstance().runUiThread(() -> this.showMessage(project, args, complete));
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void showMessage(Project project, List<Object> args, Consumer<Object> complete) {
        if (args.size() < 4) {
            complete.accept(null);
            LogManager.warn(MainThreadMessageService.class, "showMessage args size < 4");
            return;
        }
        try {
            MainThreadMessageOptions options = (MainThreadMessageOptions)JSONObject.parseObject((String)args.get(2).toString(), MainThreadMessageOptions.class);
            if (options.getModal() != null && options.getModal().booleanValue()) {
                this.showModalDialog(project, options, args, complete);
            } else {
                this.showModalNotification(project, options, args, complete);
            }
        }
        catch (Exception e) {
            LogManager.warn(MainThreadMessageService.class, "showMessage failed" + String.valueOf(e));
            complete.accept(null);
        }
    }

    private void showModalDialog(Project project, MainThreadMessageOptions options, List<Object> args, Consumer<Object> complete) {
        List commands;
        String[] buttonTitles;
        int severity = Integer.parseInt(args.get(0).toString());
        String message = args.get(1).toString();
        int resultIndex = Messages.showDialog((String)message, (String)PluginInfo.COPILOT_NAME, (String[])(buttonTitles = (String[])(commands = JSONArray.parseArray((String)args.get(3).toString(), MainThreadMessageCommand.class)).stream().map(cmd -> cmd.getTitle()).toArray(String[]::new)), (int)0, (Icon)this.getSeverityIcon(severity));
        if (resultIndex >= 0 && resultIndex < commands.size()) {
            MainThreadMessageCommand selectedCmd = (MainThreadMessageCommand)commands.get(resultIndex);
            this.executeCommand(selectedCmd, complete);
        } else {
            complete.accept(null);
            LogManager.warn(MainThreadMessageService.class, "showMessage dialog result is invalid");
        }
    }

    private Icon getSeverityIcon(int severity) {
        switch (severity) {
            case 2: {
                return Messages.getWarningIcon();
            }
            case 3: {
                return Messages.getErrorIcon();
            }
        }
        return Messages.getInformationIcon();
    }

    private void showModalNotification(Project project, MainThreadMessageOptions options, List<Object> args, final Consumer<Object> complete) {
        int severity = Integer.parseInt(args.get(0).toString());
        String message = args.get(1).toString();
        List commands = JSONArray.parseArray((String)args.get(3).toString(), MainThreadMessageCommand.class);
        if (severity == 0) {
            severity = 1;
        }
        NotificationType type = NotificationType.values()[severity];
        NotificationGroup group = NotificationGroupManager.getInstance().getNotificationGroup("default");
        final Notification notification = this.createNotification(group, PluginInfo.COPILOT_NAME, message, type);
        if (notification == null) {
            LogManager.warn(MainThreadMessageService.class, "showModalNotification failed, notification is null");
            complete.accept(null);
            return;
        }
        for (final MainThreadMessageCommand cmd : commands) {
            notification.addAction((AnAction)new BaseAnAction(cmd.getTitle()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MainThreadMessageService.this.executeCommand(cmd, complete);
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/apibridge/extension/mainthread/message/MainThreadMessageService$1", "actionPerformed"));
                }
            });
        }
        Notifications.Bus.notify((Notification)notification);
    }

    private Notification createNotification(NotificationGroup group, String title, String content, NotificationType type) {
        Method method = null;
        try {
            method = NotificationGroup.class.getMethod("createNotification", String.class, String.class, NotificationType.class);
            return (Notification)method.invoke((Object)group, title, content, type);
        }
        catch (Exception e) {
            try {
                method = NotificationGroup.class.getMethod("createNotification", String.class, String.class, String.class, NotificationType.class);
                return (Notification)method.invoke((Object)group, title, "", content, type);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    private void executeCommand(MainThreadMessageCommand cmd, Consumer<Object> complete) {
        complete.accept(cmd.getHandle());
    }
}

