/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.progress;

import com.alibaba.fastjson2.JSONObject;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MainThreadProgress
extends MainThreadBaseProxy {
    private final String PROGRESS_START = "$startProgress";
    private final String PROGRESS_REPORT = "$progressReport";
    private final String PROGRESS_END = "$progressEnd";
    private ProgressIndicator progressIndicator;

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$startProgress": {
                this.startProgress(project, args, complete);
                break;
            }
            case "$progressEnd": {
                this.endProgress(project, args, complete);
                break;
            }
            case "$progressReport": {
                complete.accept(null);
            }
            default: {
                complete.accept(null);
            }
        }
    }

    public void startProgress(Project project, List<Object> args, final Consumer<Object> complete) {
        String title = ((JSONObject)args.get(1)).getString("title");
        Boolean cancellable = ((JSONObject)args.get(1)).getBoolean("cancellable");
        Task.Backgroundable task = new Task.Backgroundable(project, title, cancellable == null ? false : cancellable){

            public void onCancel() {
                super.onCancel();
                complete.accept(null);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                while (!indicator.isCanceled()) {
                }
                complete.accept(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/tencent/code/intel/apibridge/extension/mainthread/progress/MainThreadProgress$1", "run"));
            }
        };
        this.progressIndicator = new BackgroundableProcessIndicator(task);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, this.progressIndicator);
    }

    private void endProgress(Project project, List<Object> args, Consumer<Object> complete) {
        complete.accept(null);
        if (this.progressIndicator != null) {
            this.progressIndicator.cancel();
            this.progressIndicator = null;
        }
    }
}

