/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.quickopen;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.quickopen.QuickInputSession;
import com.tencent.code.intel.apibridge.extension.mainthread.quickopen.QuickModalSelectorSession;
import com.tencent.code.intel.apibridge.extension.mainthread.quickopen.TransferQuickPickItem;
import com.tencent.code.intel.apibridge.nodeprocess.NodeProjectService;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.common.PluginInfo;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.sidebar.conversation.chat.footer.file.CodeReviewFileChooserDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;

public class MainThreadQuickOpen
extends MainThreadBaseProxy {
    private final Map<Integer, QuickInputSession> sessions = new ConcurrentHashMap<Integer, QuickInputSession>();
    private final int QUICK_MODAL_SELECTOR_POPUP_MIN_SIZE = 400;
    private QuickModalSelectorSession currentQuickModalSession;

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$createOrUpdate": {
                this.createOrUpdate(project, args, complete);
                break;
            }
            case "$dispose": {
                this.disposeQuickInput(args, complete);
                break;
            }
            case "$show": {
                this.showQuickModalSelectorPopup(project, args, complete);
                break;
            }
            case "$setItems": {
                this.setQuickModalSelectorItems(project, args, complete);
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void disposeQuickInput(List<Object> args, Consumer<Object> complete) {
        int sessionId;
        QuickInputSession session;
        if (args != null && !args.isEmpty() && args.get(0) instanceof Number && (session = this.sessions.remove(sessionId = ((Number)args.get(0)).intValue())) != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (session.popup != null && !session.popup.isDisposed()) {
                    session.popup.cancel();
                }
                if (session.disposable != null) {
                    Disposer.dispose((Disposable)session.disposable);
                }
            });
        }
        complete.accept(null);
    }

    private void createOrUpdate(Project project, List<Object> args, Consumer<Object> complete) {
        JSONObject params = (JSONObject)args.get(0);
        String openType = params.getString("type");
        int sessionId = params.getIntValue("id");
        if (openType == null) {
            LogManager.warn(MainThreadQuickOpen.class, "Quick open type is null for session: " + sessionId);
            complete.accept(null);
            return;
        }
        switch (openType) {
            case "quickPick": 
            case "quickPickCommand": {
                this.handleQuickPick(project, params, sessionId, complete);
                break;
            }
            case "quickPickFile": {
                this.showQuickPickFileDialog(project, sessionId, complete);
                break;
            }
            default: {
                LogManager.warn(MainThreadQuickOpen.class, "Unsupported quick open type: " + openType + " for session: " + sessionId);
                complete.accept(null);
            }
        }
    }

    private void handleQuickPick(Project project, JSONObject params, int sessionId, Consumer<Object> complete) {
        QuickInputSession session = this.sessions.get(sessionId);
        JSONArray itemsJson = params.getJSONArray("items");
        QuickPickData data = this.parseQuickPickItemsAndSeparators(itemsJson);
        boolean hasPlaceholder = params.containsKey("placeholder");
        if (session != null && session.popup != null && !session.popup.isDisposed() && session.listModel != null) {
            this.updateQuickPickPopup(session.listModel, data, project, sessionId);
        } else {
            session = new QuickInputSession(null, Disposer.newDisposable((String)("QuickInputSession:" + sessionId)));
            this.sessions.put(sessionId, session);
            this.showQuickPickPopup(project, params, sessionId, data, hasPlaceholder, session);
        }
        complete.accept(null);
    }

    private void showQuickPickPopup(Project project, JSONObject params, int sessionId, QuickPickData data, boolean hasPlaceholder, QuickInputSession finalSession) {
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                Pair<JBPopup, DefaultListModel<TransferQuickPickItem>> popupAndModel = this.createQuickPickPopup(project, params, sessionId, data, hasPlaceholder);
                JBPopup popup = (JBPopup)popupAndModel.getFirst();
                DefaultListModel listModel = (DefaultListModel)popupAndModel.getSecond();
                boolean visible = params.getBooleanValue("visible", false);
                if (visible) {
                    if (hasPlaceholder) {
                        JFrame window = WindowManager.getInstance().getFrame(project);
                        int x = window.getX() + (window.getWidth() - popup.getContent().getPreferredSize().width) / 2;
                        int y = window.getY();
                        popup.show(new RelativePoint(new Point(x, y)));
                    } else {
                        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                        Point mouseLocation = pointerInfo.getLocation();
                        popup.show(new RelativePoint(mouseLocation));
                    }
                } else {
                    popup.cancel();
                }
                finalSession.popup = popup;
                finalSession.listModel = listModel;
                Disposer.register((Disposable)finalSession.disposable, (Disposable)popup);
            }
            catch (Exception e) {
                LogManager.warn(MainThreadQuickOpen.class, "Failed to show quick pick popup");
            }
        });
    }

    private QuickPickData parseQuickPickItemsAndSeparators(JSONArray itemsJson) {
        ArrayList<TransferQuickPickItem> items = new ArrayList<TransferQuickPickItem>();
        HashMap<Integer, String> separatorLabels = new HashMap<Integer, String>();
        if (itemsJson != null) {
            String pendingSeparatorLabel = null;
            for (Object itemObj : itemsJson) {
                if (!(itemObj instanceof JSONObject)) continue;
                JSONObject jsonItem = (JSONObject)itemObj;
                String type = jsonItem.getString("type");
                if ("separator".equals(type)) {
                    String label = jsonItem.getString("label");
                    if (label.isEmpty()) {
                        TransferQuickPickItem separatorItem = new TransferQuickPickItem();
                        separatorItem.setType("separator");
                        separatorItem.setLabel(jsonItem.getString("label"));
                        items.add(separatorItem);
                        continue;
                    }
                    pendingSeparatorLabel = label;
                    continue;
                }
                TransferQuickPickItem item = (TransferQuickPickItem)jsonItem.toJavaObject(TransferQuickPickItem.class, new JSONReader.Feature[0]);
                if (pendingSeparatorLabel != null) {
                    item.setDescription(pendingSeparatorLabel);
                    pendingSeparatorLabel = null;
                }
                items.add(item);
            }
        }
        return new QuickPickData(items, separatorLabels);
    }

    private Pair<JBPopup, DefaultListModel<TransferQuickPickItem>> createQuickPickPopup(final Project project, JSONObject params, final int sessionId, QuickPickData data, boolean hasPlaceholder) {
        JBPopup popup;
        final JBPopup[] popupRef = new JBPopup[1];
        String title = params.getString("title");
        title = title == null || title.isEmpty() ? PluginInfo.COPILOT_NAME : title;
        String prompt = params.getString("prompt") == null ? "" : params.getString("prompt");
        ArrayList<TransferQuickPickItem> items = new ArrayList<TransferQuickPickItem>(data.items);
        final PlaceholderTextField textField = new PlaceholderTextField();
        if (hasPlaceholder) {
            textField.setPlaceholder(params.getString("placeholder"));
        } else {
            TransferQuickPickItem resetItem = new TransferQuickPickItem();
            resetItem.setLabel("$(copilot-reset-status)" + LocaleManager.get("reset_plugin_status"));
            resetItem.setType("action");
            resetItem.setHandle(-1);
            items.add(resetItem);
        }
        int textFieldHeight = textField.getPreferredSize().height;
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        textFieldPanel.add((Component)textField, "Center");
        textFieldPanel.setPreferredSize(new Dimension(10, textFieldHeight));
        textFieldPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, textFieldHeight));
        textFieldPanel.setMinimumSize(new Dimension(10, textFieldHeight));
        final DefaultListModel listModel = new DefaultListModel();
        items.forEach(listModel::addElement);
        final JList<Object> jList = new JList<Object>(listModel);
        jList.setSelectionMode(0);
        jList.setFixedCellHeight(-1);
        SwingUtilities.invokeLater(() -> this.selectFirstNonSeparator(jList, listModel));
        JPanel listWrapper = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        Box spacer = Box.createHorizontalBox();
        int minListWidth = 200;
        if (hasPlaceholder) {
            minListWidth = 400;
        }
        spacer.setMinimumSize(new Dimension(minListWidth, 0));
        spacer.setPreferredSize(new Dimension(minListWidth, 0));
        listWrapper.add((Component)spacer, gbc);
        listWrapper.add(jList, gbc);
        jList.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                boolean isSeparator = false;
                for (int i = index0; i <= index1; ++i) {
                    TransferQuickPickItem value = (TransferQuickPickItem)listModel.getElementAt(i);
                    if (value == null || !"separator".equals(value.getType())) continue;
                    isSeparator = true;
                    break;
                }
                if (!isSeparator) {
                    super.setSelectionInterval(index0, index1);
                }
            }
        });
        jList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof TransferQuickPickItem) {
                    TransferQuickPickItem item = (TransferQuickPickItem)value;
                    if ("separator".equals(item.getType())) {
                        JLabel sep = new JLabel(){

                            @Override
                            public Dimension getPreferredSize() {
                                return new Dimension(10, 2);
                            }

                            @Override
                            protected void paintComponent(Graphics g) {
                                super.paintComponent(g);
                                g.setColor(JBUI.CurrentTheme.Popup.separatorColor());
                                int y = this.getHeight() / 2;
                                g.drawLine(0, y, this.getWidth(), y);
                            }
                        };
                        sep.setOpaque(false);
                        return sep;
                    }
                    JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    String mainText = item.getTextLabel() != null ? item.getTextLabel() : item.getLabel();
                    String desc = item.getDescription();
                    if (desc != null && !desc.isEmpty()) {
                        label.setText(mainText + "\u3010" + desc + "\u3011");
                    } else {
                        label.setText(mainText);
                    }
                    String iconLabel = item.getIconLabel();
                    if (iconLabel != null) {
                        label.setIcon(MainThreadQuickOpen.this.getIconByIconLabel(iconLabel));
                    }
                    return label;
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            void update() {
                String input = textField.getText();
                NodeRunner.getInstance(project).getQuickOpen().onDidChangeValue(sessionId, input, jsonObject -> {});
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        jList.addListSelectionListener(e -> {
            TransferQuickPickItem selected;
            if (!e.getValueIsAdjusting() && (selected = (TransferQuickPickItem)jList.getSelectedValue()) != null && !"separator".equals(selected.getType())) {
                NodeRunner.getInstance(project).getQuickOpen().onDidChangeActive(sessionId, Collections.singletonList(selected.getHandle()), jsonObject -> {});
            }
        });
        jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    TransferQuickPickItem selected = (TransferQuickPickItem)jList.getSelectedValue();
                    if (selected.getHandle() == -1) {
                        NodeProjectService nodeProjectService = (NodeProjectService)project.getService(NodeProjectService.class);
                        if (nodeProjectService != null) {
                            nodeProjectService.reset();
                        }
                    } else if (selected != null && !"separator".equals(selected.getType())) {
                        NodeRunner.getInstance(project).getQuickOpen().onDidChangeSelection(sessionId, Collections.singletonList(selected.getHandle()), jsonObject -> {});
                        NodeRunner.getInstance(project).getQuickOpen().onDidAccept(sessionId, jsonObject -> {});
                    }
                    popupRef[0].cancel();
                }
            }
        });
        textField.addActionListener(e -> {
            TransferQuickPickItem selected = (TransferQuickPickItem)jList.getSelectedValue();
            if (selected != null && !"separator".equals(selected.getType())) {
                NodeRunner.getInstance(project).getQuickOpen().onDidChangeSelection(sessionId, Collections.singletonList(selected.getHandle()), jsonObject -> {});
                NodeRunner.getInstance(project).getQuickOpen().onDidAccept(sessionId, jsonObject -> {});
                popupRef[0].cancel();
            }
        });
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int idx = jList.getSelectedIndex();
                if (e.getKeyCode() == 40) {
                    if (idx < listModel.size() - 1) {
                        jList.setSelectedIndex(idx + 1);
                    }
                } else if (e.getKeyCode() == 38 && idx > 0) {
                    jList.setSelectedIndex(idx - 1);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints panelGbc = new GridBagConstraints();
        panelGbc.fill = 2;
        panelGbc.weightx = 1.0;
        panelGbc.gridwidth = 0;
        panel.setBorder(new EmptyBorder(0, 8, 8, 8));
        if (!prompt.isEmpty()) {
            JLabel promptLabel = new JLabel(prompt);
            panel.add((Component)promptLabel, panelGbc);
        }
        if (hasPlaceholder) {
            panel.add((Component)textFieldPanel, panelGbc);
            panel.add(Box.createVerticalStrut(4), panelGbc);
        }
        panel.add((Component)listWrapper, panelGbc);
        popupRef[0] = popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)textField).setTitle(title).setResizable(true).setMovable(true).setRequestFocus(true).setCancelOnClickOutside(true).createPopup();
        popup.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                NodeRunner nodeRunner;
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if ((nodeRunner = NodeRunner.getInstance(project)) == null) {
                    return;
                }
                nodeRunner.getQuickOpen().onDidHide(sessionId, jsonObject -> {});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/tencent/code/intel/apibridge/extension/mainthread/quickopen/MainThreadQuickOpen$6", "onClosed"));
            }
        });
        return Pair.create((Object)popup, listModel);
    }

    private void selectFirstNonSeparator(JList<TransferQuickPickItem> jList, ListModel<TransferQuickPickItem> model) {
        for (int i = 0; i < model.getSize(); ++i) {
            TransferQuickPickItem item = model.getElementAt(i);
            if ("separator".equals(item.getType())) continue;
            jList.setSelectedIndex(i);
            break;
        }
    }

    private void updateQuickPickPopup(DefaultListModel<TransferQuickPickItem> listModel, QuickPickData data, Project project, int sessionId) {
        QuickInputSession session;
        listModel.clear();
        for (TransferQuickPickItem item : data.items) {
            listModel.addElement(item);
        }
        if (!listModel.isEmpty()) {
            TransferQuickPickItem activeItem = listModel.getElementAt(0);
            NodeRunner.getInstance(project).getQuickOpen().onDidChangeActive(sessionId, Collections.singletonList(activeItem.getHandle()), jsonObject -> {});
        }
        if ((session = this.sessions.get(sessionId)) != null && session.popup != null && !session.popup.isDisposed()) {
            JList<?> list = this.findJListInComponent(session.popup.getContent());
            if (list != null) {
                list.invalidate();
                SwingUtilities.invokeLater(() -> this.selectFirstNonSeparator(list, list.getModel()));
            }
            session.popup.getContent().revalidate();
            session.popup.getContent().repaint();
            session.popup.pack(true, true);
        }
    }

    private JList<?> findJListInComponent(Component component) {
        if (component instanceof JList) {
            return (JList)component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component child : container.getComponents()) {
                JList<?> list = this.findJListInComponent(child);
                if (list == null) continue;
                return list;
            }
        }
        return null;
    }

    private void showQuickModalSelectorPopup(Project project, List<Object> args, final Consumer<Object> complete) {
        try {
            if (this.currentQuickModalSession != null) {
                this.currentQuickModalSession.dispose();
                this.currentQuickModalSession = null;
            }
            JSONObject params = (JSONObject)args.get(1);
            String title = params.getString("title");
            final JBList modalSelectorList = new JBList();
            Disposable disposable = Disposer.newDisposable((String)"QuickModalSelectorSession");
            modalSelectorList.addListSelectionListener(e -> {
                TransferQuickPickItem selectedItem;
                if (this.currentQuickModalSession != null && this.currentQuickModalSession.isValid() && (selectedItem = (TransferQuickPickItem)modalSelectorList.getSelectedValue()) != null) {
                    complete.accept(selectedItem.getHandle());
                    this.currentQuickModalSession.popup.cancel();
                }
            });
            modalSelectorList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    int hoverIndex;
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    Point mousePos = list.getMousePosition();
                    if (mousePos != null && (hoverIndex = list.locationToIndex(mousePos)) == index) {
                        this.setBackground(UIUtil.getListSelectionBackground());
                    }
                    return this;
                }
            });
            modalSelectorList.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    modalSelectorList.repaint();
                }
            });
            final JBPopup popup = this.createQuickModalSelectorPopup(title, (JBList<TransferQuickPickItem>)modalSelectorList);
            JBPopupListener quickModalSelectorListener = new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    complete.accept(null);
                    if (MainThreadQuickOpen.this.currentQuickModalSession != null && MainThreadQuickOpen.this.currentQuickModalSession.popup == popup) {
                        MainThreadQuickOpen.this.currentQuickModalSession = null;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/tencent/code/intel/apibridge/extension/mainthread/quickopen/MainThreadQuickOpen$9", "onClosed"));
                }
            };
            popup.addListener(quickModalSelectorListener);
            this.currentQuickModalSession = new QuickModalSelectorSession(popup, (JBList<TransferQuickPickItem>)modalSelectorList, new ArrayList<TransferQuickPickItem>(), disposable);
            Disposer.register((Disposable)disposable, (Disposable)popup);
        }
        catch (Exception e2) {
            LogManager.warn(MainThreadQuickOpen.class, "showQuickModalSelector: " + String.valueOf(e2));
            complete.accept(null);
        }
    }

    private JBPopupListener createQuickModalSelectorListener(final Consumer<Object> complete) {
        return new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    10.$$$reportNull$$$0(0);
                }
                complete.accept(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/tencent/code/intel/apibridge/extension/mainthread/quickopen/MainThreadQuickOpen$10", "onClosed"));
            }
        };
    }

    private void setQuickModalSelectorItems(Project project, List<Object> args, Consumer<Object> complete) {
        if (this.currentQuickModalSession == null || !this.currentQuickModalSession.isValid()) {
            LogManager.warn(MainThreadQuickOpen.class, "setQuickModalSelectorItems: No valid session found");
            complete.accept(null);
            return;
        }
        JSONArray params = (JSONArray)args.get(1);
        QuickPickData data = this.parseQuickPickItemsAndSeparators(params);
        this.currentQuickModalSession.items = data.items;
        this.currentQuickModalSession.list.setModel((ListModel)JBList.createDefaultListModel(data.items));
        ThreadManager.getInstance().runUiThreadSave(() -> {
            if (this.currentQuickModalSession != null && this.currentQuickModalSession.isValid()) {
                JFrame parentComponent = WindowManager.getInstance().getFrame(project);
                int x = parentComponent.getX() + (parentComponent.getWidth() - 400) / 2;
                int y = parentComponent.getY();
                this.currentQuickModalSession.popup.show(new RelativePoint(new Point(x, y)));
                this.currentQuickModalSession.popup.getContent().revalidate();
                this.currentQuickModalSession.popup.getContent().repaint();
            }
        });
        complete.accept(null);
    }

    public JBPopup createQuickModalSelectorPopup(String title, final JBList<TransferQuickPickItem> modalSelectorList) {
        JPanel panel = new JPanel(new BorderLayout());
        final JTextField searchField = new JTextField();
        panel.add((Component)searchField, "North");
        panel.add((Component)modalSelectorList, "Center");
        searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            private void filter() {
                if (MainThreadQuickOpen.this.currentQuickModalSession == null || !MainThreadQuickOpen.this.currentQuickModalSession.isValid()) {
                    return;
                }
                String filterText = searchField.getText().toLowerCase();
                List<TransferQuickPickItem> items = MainThreadQuickOpen.this.currentQuickModalSession.items;
                if (TextUtils.isEmpty((CharSequence)filterText)) {
                    modalSelectorList.setModel((ListModel)JBList.createDefaultListModel(items));
                    return;
                }
                DefaultListModel<TransferQuickPickItem> filteredModel = new DefaultListModel<TransferQuickPickItem>();
                for (int i = 0; i < items.size(); ++i) {
                    TransferQuickPickItem item = items.get(i);
                    if (!item.getLabel().toLowerCase().contains(filterText)) continue;
                    filteredModel.addElement(item);
                }
                modalSelectorList.setModel(filteredModel);
            }
        });
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, (JComponent)searchField).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setModalContext(true).createPopup();
        popup.setMinimumSize(new Dimension(400, popup.getContent().getPreferredSize().height));
        return popup;
    }

    private void showQuickPickFileDialog(Project project, int sessionId, Consumer<Object> complete) {
        CompletableFuture.supplyAsync(() -> {
            CompletableFuture future = new CompletableFuture();
            ApplicationManager.getApplication().invokeLater(() -> {
                CodeReviewFileChooserDialog chooserDialog = new CodeReviewFileChooserDialog(project, null, null, null, null, false);
                chooserDialog.show();
                if (chooserDialog.getSelectedFile() != null) {
                    future.complete(chooserDialog.getSelectedFile().getVirtualFile().getPath());
                } else {
                    future.complete(null);
                }
            });
            try {
                return (String)future.get(1L, TimeUnit.DAYS);
            }
            catch (Exception e) {
                LogManager.warn(MainThreadQuickOpen.class, "Choose project file error");
                return null;
            }
        }).thenAccept(selectedFilePath -> {
            if (selectedFilePath == null) {
                complete.accept(null);
                return;
            }
            NodeRunner.getInstance(project).getQuickOpen().onDidChangeSelection(sessionId, null, jsonObject -> {});
            NodeRunner.getInstance(project).getQuickOpen().onDidAccept(sessionId, jsonObject -> {});
            complete.accept(selectedFilePath);
        });
    }

    private Icon getIconByIconLabel(String iconLabel) {
        Icon icon = null;
        switch (iconLabel) {
            case "account": {
                icon = AllIcons.General.User;
                break;
            }
            case "check": {
                icon = SdkIcons.COPILOT_ACTIVATE_COMPLETION;
                break;
            }
            case "blank": {
                icon = SdkIcons.COPILOT_DEACTIVATE_COMPLETION;
                break;
            }
            case "gear": {
                icon = AllIcons.General.Gear;
                break;
            }
            case "keyboard": {
                icon = AllIcons.Debugger.EvaluateExpression;
                break;
            }
            case "sync": {
                icon = SdkIcons.COPILOT_CHECK_UPDATE;
                break;
            }
            case "output": {
                icon = AllIcons.General.OpenDisk;
                break;
            }
            case "book": {
                icon = SdkIcons.COPILOT_START_PAGE;
                break;
            }
            case "feedback": {
                icon = SdkIcons.COPILOT_ISSUE_FEEDBACK;
                break;
            }
            case "debug-console": 
            case "sign-out": {
                icon = SdkIcons.COPILOT_LOGOUT;
                break;
            }
            case "arrow-circle-up": {
                icon = SdkIcons.COPILOT_CHECK_UPDATE;
                break;
            }
            case "package": {
                icon = SdkIcons.COPILOT_PACKAGE;
                break;
            }
            case "copilot-reset-status": {
                icon = SdkIcons.COPILOT_RESET_STATUS;
            }
        }
        return icon;
    }

    public static class PlaceholderTextField
    extends JTextField {
        private String placeholder;

        public void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.placeholder != null && this.getText().isEmpty()) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(Color.GRAY);
                Insets insets = this.getInsets();
                FontMetrics fm = g2.getFontMetrics();
                int y = (this.getHeight() + fm.getAscent() - fm.getDescent()) / 2;
                g2.drawString(this.placeholder, insets.left + 8, y);
                g2.dispose();
            }
        }
    }

    private static class QuickPickData {
        List<TransferQuickPickItem> items;
        Map<Integer, String> separatorLabels;

        QuickPickData(List<TransferQuickPickItem> items, Map<Integer, String> separatorLabels) {
            this.items = items;
            this.separatorLabels = separatorLabels;
        }
    }
}

