/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.scm;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.CommitWorkflowHandler;
import com.tencent.code.intel.action.base.BaseAnAction;
import com.tencent.code.intel.apibridge.extension.extension.command.ExtHostCommands;
import com.tencent.code.intel.apibridge.extension.extension.configuration.ExtHostConfiguration;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.context.MainThreadContext;
import com.tencent.code.intel.apibridge.extension.mainthread.context.contextexpression.ContextExpression;
import com.tencent.code.intel.apibridge.extension.mainthread.scm.SCMMenuContext;
import com.tencent.code.intel.apibridge.extension.mainthread.toolwindow.MainThreadToolWindow;
import com.tencent.code.intel.apibridge.util.FusionActionUtils;
import com.tencent.code.intel.common.SdkIcons;
import com.tencent.code.intel.manager.LocaleManager;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.util.JsonRpcUtils;
import com.tencent.code.intel.util.ProjectDiffUtils;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MainThreadSCM
extends MainThreadBaseProxy {
    private static final String REGISTER_SCM = "$registerSCM";
    private static final String SET_INPUT_BOX_VALUE = "$setInputBoxValue";
    private static final String GET_DIFF_CONTENTS = "$getDiffContents";
    private static final String SET_DIFF_CONTENTS = "$setCommitMsg";
    public final String SET_SCM_PROVIDER = "$setScmProvider";
    private static final Map<Project, Set<String>> PROJECT_ACTIONS = new ConcurrentHashMap<Project, Set<String>>();
    private static final Map<Project, List<SCMMenuContext>> PROJECT_SCM_CONTEXTS = new ConcurrentHashMap<Project, List<SCMMenuContext>>();
    private static final Map<Project, AnActionEvent> PROJECT_ACTION_EVENTS = new ConcurrentHashMap<Project, AnActionEvent>();
    private static final Map<Project, String> PROJECT_CACHE_MESSAGES = new ConcurrentHashMap<Project, String>();
    private static final Map<Project, Boolean> PROJECT_LISTENERS_SETUP = new ConcurrentHashMap<Project, Boolean>();

    public MainThreadSCM() {
        ProjectManager.getInstance().addProjectManagerListener(new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                MainThreadSCM.this.cleanupProjectActions(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/tencent/code/intel/apibridge/extension/mainthread/scm/MainThreadSCM$1", "projectClosed"));
            }
        });
    }

    private void cleanupProjectActions(Project project) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup vcsMessageActionGroup = (DefaultActionGroup)actionManager.getAction("Vcs.MessageActionGroup");
        Set<String> projectActions = PROJECT_ACTIONS.remove(project);
        if (projectActions != null) {
            for (String actionId : projectActions) {
                AnAction action = actionManager.getAction(actionId);
                if (action == null) continue;
                if (vcsMessageActionGroup != null && vcsMessageActionGroup.containsAction(action)) {
                    vcsMessageActionGroup.remove(action);
                }
                actionManager.unregisterAction(actionId);
            }
        }
        PROJECT_SCM_CONTEXTS.remove(project);
        PROJECT_ACTION_EVENTS.remove(project);
        PROJECT_CACHE_MESSAGES.remove(project);
        LogManager.info(MainThreadSCM.class, "\u5df2\u6e05\u7406\u9879\u76ee " + project.getName() + " \u7684\u6240\u6709 SCM actions \u548c\u6570\u636e");
    }

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$registerSCM": {
                this.initScmContext(project, args, complete);
                break;
            }
            case "$setInputBoxValue": 
            case "$setCommitMsg": {
                String commitMessageText = args.get(0).toString();
                this.setInputBoxValue(project, commitMessageText);
                break;
            }
            case "$getDiffContents": {
                this.getDiffContents(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void getDiffContents(Project project, List<Object> args, Consumer<Object> complete) {
        ThreadManager.getInstance().runUiThread(() -> {
            try {
                int maxDiffToken = 8000;
                List<Object> diffLines = Collections.emptyList();
                AnActionEvent lastEvent = PROJECT_ACTION_EVENTS.get(project);
                if (lastEvent != null) {
                    CommitWorkflowHandler handler = (CommitWorkflowHandler)lastEvent.getData(VcsDataKeys.COMMIT_WORKFLOW_HANDLER);
                    diffLines = ProjectDiffUtils.getSelectedDiff(handler, project, 8000);
                }
                if (diffLines == null || diffLines.isEmpty()) {
                    diffLines = ProjectDiffUtils.getDiff(project, 8000);
                }
                String result = diffLines == null || diffLines.isEmpty() ? "" : String.join((CharSequence)"\n", diffLines);
                complete.accept(result);
            }
            catch (Throwable t) {
                LogManager.warn(MainThreadSCM.class, "getDiffContents failed: " + t.getMessage());
                complete.accept("");
            }
        });
    }

    public void initScmContext(Project project, List<Object> args, Consumer<Object> complete) {
        AbstractVcs vcs = this.getProjectVcs(project);
        if (vcs != null) {
            ExtHostConfiguration.setRepositories(project);
            this.setVcsProvider(project, vcs);
            this.registerSCM(project, args, complete);
            PROJECT_LISTENERS_SETUP.remove(project);
            return;
        }
        if (!PROJECT_LISTENERS_SETUP.containsKey(project)) {
            LogManager.info(MainThreadSCM.class, "\u9996\u6b21\u4e3a\u9879\u76ee " + project.getName() + " \u8bbe\u7f6e VCS \u4e8b\u4ef6\u76d1\u542c\u5668");
            this.setupVcsEventListeners(project, args, complete);
            PROJECT_LISTENERS_SETUP.put(project, true);
            LogManager.info(MainThreadSCM.class, "\u672a\u627e\u5230\u9879\u76ee " + project.getName() + " \u7684VCS");
        }
    }

    private void setupVcsEventListeners(final Project project, final List<Object> args, final Consumer<Object> complete) {
        LogManager.info(MainThreadSCM.class, "\u4e3a\u9879\u76ee " + project.getName() + " \u8bbe\u7f6e VCS \u4e8b\u4ef6\u76d1\u542c\u5668");
        project.getMessageBus().connect().subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            public void repositoryChanged(@NotNull GitRepository repository) {
                if (repository == null) {
                    2.$$$reportNull$$$0(0);
                }
                LogManager.info(MainThreadSCM.class, "\u68c0\u6d4b\u5230\u9879\u76ee " + project.getName() + " \u7684 Git \u4ed3\u5e93\u72b6\u6001\u53d8\u5316\uff0c\u5c1d\u8bd5\u521d\u59cb\u5316 SCM \u83dc\u5355");
                ExtHostConfiguration.setRepositories(project);
                MainThreadSCM.this.initScmContext(project, args, complete);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/tencent/code/intel/apibridge/extension/mainthread/scm/MainThreadSCM$2", "repositoryChanged"));
            }
        });
    }

    public void setVcsProvider(Project project, AbstractVcs vcs) {
        String vcsName = vcs.getName().toLowerCase();
        MainThreadContext.getInstance(project).getContext().put("scmProvider", vcsName);
        LogManager.info(MainThreadSCM.class, "\u5df2\u8bbe\u7f6e\u9879\u76ee\u7684SCM\u63d0\u4f9b\u8005\u4e3a " + vcsName);
    }

    public AbstractVcs getProjectVcs(Project project) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        AbstractVcs[] activeVcses = vcsManager.getAllActiveVcss();
        return activeVcses.length > 0 ? activeVcses[0] : null;
    }

    public void updateScmMenu(Project project) {
        ThreadManager.getInstance().runUiThread(() -> {
            ActionManager actionManager = ActionManager.getInstance();
            DefaultActionGroup vcsMessageActionGroup = (DefaultActionGroup)actionManager.getAction("Vcs.MessageActionGroup");
            List<SCMMenuContext> scmMenuContexts = PROJECT_SCM_CONTEXTS.get(project);
            if (scmMenuContexts == null) {
                return;
            }
            for (SCMMenuContext scmMenuContext : scmMenuContexts) {
                AnAction action = this.createMenuAction(project, scmMenuContext.getCommand(), scmMenuContext.getTitle(), scmMenuContext.getRealRule(), scmMenuContext.getIcon());
                if (action == null) continue;
                String projectActionId = this.getProjectActionId(project, scmMenuContext.getCommand());
                AnAction existingAction = actionManager.getAction(projectActionId);
                if (vcsMessageActionGroup == null || existingAction == null || vcsMessageActionGroup.containsAction(existingAction)) continue;
                vcsMessageActionGroup.add(action);
            }
        });
    }

    private String getProjectActionId(Project project, String command) {
        return "menuAction." + command + "_" + project.getLocationHash();
    }

    private void registerSCM(Project project, List<Object> menus, Consumer<Object> complete) {
        try {
            if (menus == null || menus.isEmpty()) {
                complete.accept(false);
                return;
            }
            List<SCMMenuContext> existingContexts = PROJECT_SCM_CONTEXTS.get(project);
            if (existingContexts != null && !existingContexts.isEmpty()) {
                LogManager.info(MainThreadSCM.class, "\u9879\u76ee " + project.getName() + " \u7684 SCM \u83dc\u5355\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u91cd\u590d\u6ce8\u518c");
                complete.accept(true);
                return;
            }
            this.cleanupProjectActions(project);
            List scmMenuContexts = menus.stream().filter(keybinding -> keybinding instanceof List).flatMap(items -> ((List)items).stream()).map(menu -> {
                SCMMenuContext menuContext = JsonRpcUtils.toJavaObject(menu, SCMMenuContext.class);
                menuContext.setProject(project);
                return menuContext;
            }).collect(Collectors.toList());
            PROJECT_SCM_CONTEXTS.put(project, scmMenuContexts);
            this.updateScmMenu(project);
            complete.accept(true);
        }
        catch (Exception e) {
            LogManager.info(MainThreadSCM.class, "register scm menus failed" + e.getMessage());
            complete.accept(false);
        }
    }

    private AnAction createMenuAction(final Project project, final String command, String title, final ContextExpression rule, String icon) {
        String projectActionId = this.getProjectActionId(project, command);
        ActionManager actionManager = ActionManager.getInstance();
        if (actionManager.getAction(projectActionId) != null) {
            actionManager.unregisterAction(projectActionId);
        }
        Icon iconObj = null;
        if (icon != null) {
            try {
                Field field = SdkIcons.class.getField(icon);
                iconObj = (Icon)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                LogManager.warn(MainThreadToolWindow.class, "Failed to get icon: " + icon);
            }
        }
        BaseAnAction action = new BaseAnAction(title, "", iconObj){

            public void update(@NotNull AnActionEvent e) {
                Project currentProject;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                    e.getPresentation().setEnabled(false);
                    e.getPresentation().setVisible(false);
                    return;
                }
                boolean shouldShow = rule.evaluate();
                e.getPresentation().setEnabled(shouldShow);
                e.getPresentation().setVisible(shouldShow);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project currentProject;
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((currentProject = e.getProject()) == null || currentProject.isDisposed() || !currentProject.equals(project)) {
                    return;
                }
                List<Object> args = null;
                PROJECT_ACTION_EVENTS.put(project, e);
                CommitMessage commitMessage = MainThreadSCM.this.getCommitMessage(e);
                if (commitMessage == null) {
                    return;
                }
                String commitMessageGenActionId = FusionActionUtils.getInternalCommandId("codingcopilot.commit.message.generate");
                String commitMessageCancelActionId = FusionActionUtils.getInternalCommandId("codingcopilot.commit.message.cancel");
                if (command.equals(commitMessageGenActionId)) {
                    String cacheMessage = commitMessage.getEditorField().getText();
                    PROJECT_CACHE_MESSAGES.put(project, cacheMessage);
                    commitMessage.getEditorField().setEnabled(false);
                    commitMessage.getEditorField().setText(LocaleManager.get("ui.commit.message.suggestion.generating"));
                    String gitRepoUrl = MainThreadSCM.this.getGitRepositoryUrl(currentProject);
                    HashMap<String, String> rootUriMap = new HashMap<String, String>();
                    rootUriMap.put("fsPath", gitRepoUrl);
                    HashMap<String, HashMap<String, String>> argsMap = new HashMap<String, HashMap<String, String>>();
                    argsMap.put("rootUri", rootUriMap);
                    args = gitRepoUrl != null ? List.of(argsMap) : Collections.emptyList();
                    LogManager.info(MainThreadSCM.class, "git repo url: " + gitRepoUrl);
                    MainThreadContext.getInstance(currentProject).getContext().put("codingcopilot.commitMessageAvailable", "false");
                } else if (command.equals(commitMessageCancelActionId)) {
                    MainThreadSCM.this.reset(project, commitMessage);
                    MainThreadContext.getInstance(currentProject).getContext().put("codingcopilot.commitMessageAvailable", "true");
                }
                ExtHostCommands.executeCommand(currentProject, command, args, jsonObject -> {});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/scm/MainThreadSCM$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        actionManager.registerAction(projectActionId, (AnAction)action);
        PROJECT_ACTIONS.computeIfAbsent(project, k -> new HashSet()).add(projectActionId);
        return action;
    }

    private void setInputBoxValue(Project project, String value) {
        PROJECT_CACHE_MESSAGES.put(project, value);
        AnActionEvent actionEvent = PROJECT_ACTION_EVENTS.get(project);
        if (actionEvent != null) {
            this.reset(project, this.getCommitMessage(actionEvent));
        }
    }

    private CommitMessage getCommitMessage(@NotNull AnActionEvent e) {
        if (e == null) {
            MainThreadSCM.$$$reportNull$$$0(0);
        }
        return (CommitMessage)e.getData(VcsDataKeys.COMMIT_MESSAGE_CONTROL);
    }

    private void reset(Project project, CommitMessage commitMessage) {
        ThreadManager.getInstance().runUiThread(() -> {
            String cacheMessage = PROJECT_CACHE_MESSAGES.get(project);
            if (cacheMessage != null) {
                commitMessage.getEditorField().setText(cacheMessage);
            }
            commitMessage.getEditorField().setEnabled(true);
        });
    }

    private String getGitRepositoryUrl(Project project) {
        try {
            GitRepositoryManager gitManager = GitUtil.getRepositoryManager((Project)project);
            if (gitManager == null) {
                return null;
            }
            List repositories = gitManager.getRepositories();
            if (repositories.isEmpty()) {
                return null;
            }
            GitRepository repository = (GitRepository)repositories.get(0);
            VirtualFile root = repository.getRoot();
            Object path = root.getPath();
            if (System.getProperty("os.name").toLowerCase().contains("windows") && ((String)(path = ((String)path).replace('/', '\\'))).length() > 1 && ((String)path).charAt(1) == ':') {
                path = Character.toLowerCase(((String)path).charAt(0)) + ((String)path).substring(1);
            }
            return path;
        }
        catch (Exception e) {
            LogManager.warn(MainThreadSCM.class, "\u83b7\u53d6Git\u4ed3\u5e93URL\u5931\u8d25: " + e.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/tencent/code/intel/apibridge/extension/mainthread/scm/MainThreadSCM", "getCommitMessage"));
    }
}

