/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.secretstate;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.tencent.code.intel.apibridge.extension.extension.secretstate.ExtHostSecretState;
import java.util.Hashtable;
import java.util.Map;
import org.jdom.Element;

@State(name="SecretStorage", storages={@Storage(value="secret-storage.xml")})
@Service
public final class SecretStorage
implements PersistentStateComponent<Element> {
    private final SecretTable scores = new SecretTable();

    public Element getState() {
        Element root = new Element("MapStorage");
        Element mapElement = new Element("Scores");
        for (Map.Entry entry : this.scores.entrySet()) {
            Element entryElement = new Element("Entry");
            entryElement.setAttribute("key", (String)entry.getKey());
            entryElement.setAttribute("value", (String)entry.getValue());
            mapElement.addContent(entryElement);
        }
        root.addContent(mapElement);
        return root;
    }

    public void noStateLoaded() {
        this.scores.inited = true;
    }

    public void loadState(Element state) {
        Element mapElement = state.getChild("Scores");
        if (mapElement == null) {
            return;
        }
        this.scores.clear();
        for (Element entryElement : mapElement.getChildren("Entry")) {
            String key = entryElement.getAttributeValue("key");
            String valueStr = entryElement.getAttributeValue("value");
            if (key == null || valueStr == null) continue;
            this.scores.put(key, valueStr);
        }
        this.scores.inited = true;
    }

    public static SecretStorage getInstance() {
        return (SecretStorage)ServiceManager.getService(SecretStorage.class);
    }

    public SecretTable getScores() {
        return this.scores;
    }

    public static class SecretTable
    extends Hashtable<String, String> {
        public Boolean inited = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String put(String key, String value) {
            try {
                String string = super.put(key, value);
                return string;
            }
            finally {
                if (this.inited.booleanValue()) {
                    for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                        ExtHostSecretState.onDidChangePassword(project, key);
                    }
                }
            }
        }
    }
}

