/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.statusbar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.statusbar.FusionStatusWidget;
import com.tencent.code.intel.apibridge.util.FusionStatusBarFactory;
import com.tencent.code.intel.manager.ThreadManager;
import com.tencent.code.intel.ui.statusbar.CopilotStatusBarWidget;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadStatusBar
extends MainThreadBaseProxy {
    private final String SET_ENTRY = "$setEntry";
    private final String DISPOSE_ENTRY = "$disposeEntry";

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$setEntry": {
                this.setEntry(project, args);
                complete.accept(null);
                break;
            }
            case "$disposeEntry": {
                this.disposeEntry(project, args);
                complete.accept(null);
                break;
            }
            default: {
                complete.accept(null);
            }
        }
    }

    private void setEntry(Project project, List<Object> args) {
        String displayText;
        String id;
        if (args.size() < 13) {
            return;
        }
        String string = id = args.get(0) == null ? null : args.get(0).toString();
        if (id == null) {
            return;
        }
        if (id.equals("1")) {
            this.associateToStatusBarItem(project, args);
            return;
        }
        String string2 = displayText = args.get(4) == null ? null : args.get(4).toString();
        if (displayText == null) {
            return;
        }
        ThreadManager.getInstance().runUiThread(() -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            statusBar.removeWidget(id);
            FusionStatusWidget widget = new FusionStatusWidget(project, id, displayText, args);
            statusBar.addWidget((StatusBarWidget)widget, (Disposable)project);
        });
    }

    private void disposeEntry(Project project, List<Object> args) {
        if (args.isEmpty() || args.get(0) == null) {
            return;
        }
        ThreadManager.getInstance().runUiThreadSave(() -> {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            String id = args.get(0).toString();
            statusBar.removeWidget(id);
        });
    }

    private void associateToStatusBarItem(Project project, List<Object> args) {
        FusionStatusWidget widget = new FusionStatusWidget(project, "1", "Fusion", args);
        String command = widget.traitClickCmd();
        String title = widget.traitTitleText();
        String toolTips = widget.traitToolTipText();
        String id = args.get(0) == null ? null : args.get(0).toString();
        StatusBarWidget originWidget = FusionStatusBarFactory.getStatusBarWidget(project, id);
        if (originWidget instanceof CopilotStatusBarWidget) {
            ((CopilotStatusBarWidget)originWidget).associateToData(command, title, toolTips);
        }
        FusionStatusBarFactory.updateStatus(project);
    }
}

