/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.storage;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.tencent.code.intel.apibridge.extension.extension.storage.MainThreadStorage;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import java.util.Hashtable;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="MainThreadStorage", storages={@Storage(value="MainThreadStorage.xml")})
@Service
public final class MainThreadStoragePersistState
implements PersistentStateComponent<Element> {
    private Hashtable<String, String> state = new Hashtable();

    public static MainThreadStoragePersistState getInstance() {
        return (MainThreadStoragePersistState)ServiceManager.getService(MainThreadStoragePersistState.class);
    }

    @Nullable
    public synchronized Element getState() {
        Element root = new Element("MapStorage");
        Element mapElement = new Element("state");
        for (Map.Entry<String, String> entry : this.state.entrySet()) {
            Element entryElement = new Element("Entry");
            entryElement.setAttribute("key", entry.getKey());
            entryElement.setAttribute("value", entry.getValue());
            mapElement.addContent(entryElement);
        }
        root.addContent(mapElement);
        return root;
    }

    public synchronized void noStateLoaded() {
        this.state = new Hashtable();
    }

    public synchronized void loadState(Element state) {
        Element mapElement = state.getChild("state");
        if (mapElement == null) {
            return;
        }
        this.state.clear();
        for (Element entryElement : mapElement.getChildren("Entry")) {
            String key = entryElement.getAttributeValue("key");
            String valueStr = entryElement.getAttributeValue("value");
            if (key == null || valueStr == null) continue;
            this.state.put(key, valueStr);
        }
    }

    public String get(String key) {
        return this.state.get(key);
    }

    public void set(String key, String value) {
        this.state.put(key, value);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            MainThreadStorage.onDidChangeValue(NodeRunner.getInstance(project).getRpcChannel(), key);
        }
    }

    public void set(String storageKey, String value, String eventKey) {
        this.state.put(storageKey, value);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            MainThreadStorage.onDidChangeValue(NodeRunner.getInstance(project).getRpcChannel(), eventKey);
        }
    }

    public void remove(String key) {
        this.state.remove(key);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            MainThreadStorage.onDidChangeValue(NodeRunner.getInstance(project).getRpcChannel(), key);
        }
    }

    public void remove(String storageKey, String eventKey) {
        this.state.remove(storageKey);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            MainThreadStorage.onDidChangeValue(NodeRunner.getInstance(project).getRpcChannel(), eventKey);
        }
    }
}

