/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.storage;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.storage.MainThreadStoragePersistState;
import com.tencent.code.intel.manager.LogManager;
import java.util.List;
import java.util.function.Consumer;

public class MainThreadStorageService
extends MainThreadBaseProxy {
    private static final String SET_EXTENSION_STATE = "$setExtensionState";
    private static final String GET_EXTENSION_STATE_RAW = "$getExtensionStateRaw";
    private static final int LARGE_STATE_WARNING_THRESHOLD = 102400;
    private static final String WORKSPACE_KEY_PREFIX = "@ws:";

    private String buildStorageKey(Project project, String extensionKey, boolean isGlobal) {
        if (isGlobal || project == null) {
            return extensionKey;
        }
        String basePath = project.getBasePath();
        String workspaceHash = basePath != null ? Integer.toHexString(basePath.hashCode()) : Integer.toHexString((project.getName() != null ? project.getName() : "unknown").hashCode());
        return extensionKey + WORKSPACE_KEY_PREFIX + workspaceHash;
    }

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        switch (name) {
            case "$setExtensionState": {
                this.setExtensionState(project, args, complete);
                break;
            }
            case "$getExtensionStateRaw": {
                this.getExtensionStateRaw(project, args, complete);
                break;
            }
            default: {
                super.handleReq(project, name, args, complete);
            }
        }
    }

    private void setExtensionState(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            if (args.size() < 3) {
                LogManager.warn(MainThreadStorageService.class, "setExtensionState args size < 3");
                complete.accept(null);
                return;
            }
            String extensionKey = args.get(0) == null ? null : args.get(0).toString();
            Object valueObj = args.get(1);
            boolean isGlobal = args.get(2).equals(true);
            if (extensionKey == null) {
                LogManager.warn(MainThreadStorageService.class, "setExtensionState extensionKey is null");
                complete.accept(null);
                return;
            }
            String storageKey = this.buildStorageKey(project, extensionKey, isGlobal);
            if (valueObj == null) {
                MainThreadStoragePersistState.getInstance().remove(storageKey, extensionKey);
                complete.accept(null);
                return;
            }
            String value = valueObj.toString();
            if (value.length() > 102400) {
                LogManager.warn(MainThreadStorageService.class, "[mainThreadStorage] large extension state detected (extensionId: " + extensionKey + ", global: " + isGlobal + "): " + value.length() / 1024 + "kb. Consider to use 'storageUri' or 'globalStorageUri' to store this data on disk instead.");
            }
            MainThreadStoragePersistState.getInstance().set(storageKey, value, extensionKey);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadStorageService.class, "setExtensionState error" + e.getMessage());
            complete.accept(null);
        }
    }

    private void getExtensionStateRaw(Project project, List<Object> args, Consumer<Object> complete) {
        try {
            if (args.size() < 2) {
                LogManager.warn(MainThreadStorageService.class, "getExtensionStateRaw args size < 2");
                complete.accept(null);
                return;
            }
            String extensionKey = args.get(0).toString();
            boolean isGlobal = args.get(1).equals(true);
            String storageKey = this.buildStorageKey(project, extensionKey, isGlobal);
            String value = MainThreadStoragePersistState.getInstance().get(storageKey);
            if (value != null && value.length() > 102400) {
                LogManager.warn(MainThreadStorageService.class, "[mainThreadStorage] large extension state detected (extensionId: " + extensionKey + ", global: " + isGlobal + "): " + value.length() / 1024 + "kb. Consider to use 'storageUri' or 'globalStorageUri' to store this data on disk instead.");
            }
            complete.accept(value);
        }
        catch (Exception e) {
            LogManager.warn(MainThreadStorageService.class, "getExtensionStateRaw args error" + e.getMessage());
            complete.accept(null);
        }
    }
}

