/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.terminal;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.Terminal;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.TerminalLaunchConfig;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.util.TerminalSettingUtils;
import com.tencent.code.intel.manager.LogManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class MainThreadTerminalService
extends MainThreadBaseProxy {
    public Terminal pendingApiTerminal = null;
    public final Map<String, Terminal> terminals = new ConcurrentHashMap<String, Terminal>();

    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        String CREATE_TERMINAL = "$createTerminal";
        String SHOW = "$show";
        String SEND_TEXT = "$sendText";
        switch (name) {
            case "$createTerminal": {
                String extHostTerminalId = args.get(0).toString();
                this.createTerminal(project, extHostTerminalId, complete);
                break;
            }
            case "$show": {
                String extHostTerminalId = args.get(0).toString();
                this.show(project, extHostTerminalId);
                break;
            }
            case "$sendText": {
                String extHostTerminalId = args.get(0).toString();
                this.setText(project, extHostTerminalId, args.get(1).toString());
                break;
            }
        }
    }

    public void createTerminal(Project project, String extHostTerminalId, Consumer<Object> complete) {
        Terminal terminal = new Terminal();
        terminal.createFromMainThread = true;
        this.terminals.put(extHostTerminalId, terminal);
        LogManager.warn(MainThreadTerminalService.class, "createTerminal id=instanceid=" + terminal.instanceId);
        this.pendingApiTerminal = terminal;
        TerminalLaunchConfig config = new TerminalLaunchConfig("Craft", TerminalSettingUtils.getShellPath(), project.getBasePath());
        NodeRunner.getInstance(project).getRpcChannel().sendReq("ExtHostTerminalService", "$acceptTerminalOpened", List.of(terminal.instanceId, extHostTerminalId, "Craft", config), null);
        NodeRunner.getInstance(project).getRpcChannel().sendReq("ExtHostTerminalService", "$acceptActiveTerminalChanged", List.of(terminal.instanceId), null);
        complete.accept(null);
    }

    public void show(Project project, String extHostTerminalId) {
        LogManager.warn(MainThreadTerminalService.class, "show id=" + extHostTerminalId);
        Terminal terminal = this.findActiveTerminal(extHostTerminalId);
        if (terminal != null) {
            terminal.show(project);
        } else {
            LogManager.warn(MainThreadTerminalService.class, "terminal is null");
        }
    }

    public void setText(Project project, String extHostTerminalId, String text) {
        Terminal terminal = this.findActiveTerminal(extHostTerminalId);
        if (terminal != null) {
            terminal.setText(project, text);
        } else {
            LogManager.warn(MainThreadTerminalService.class, "terminal is null");
        }
    }

    private Terminal findActiveTerminal(String terminalId) {
        try {
            int id = Integer.parseInt(terminalId);
            return this.terminals.values().stream().filter(t -> t.instanceId == id).findFirst().orElse(null);
        }
        catch (NumberFormatException e) {
            return this.terminals.get(terminalId);
        }
    }
}

