/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.terminal;

import com.intellij.openapi.project.Project;
import com.tencent.code.intel.apibridge.extension.mainthread.MainThreadBaseProxy;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.MainThreadTerminalService;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.Terminal;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.manager.LogManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class MainThreadTerminalShellIntegration
extends MainThreadBaseProxy {
    @Override
    public void handleReq(Project project, String name, List<Object> args, Consumer<Object> complete) {
        String EXECUTE_COMMAND = "$executeCommand";
        switch (name) {
            case "$executeCommand": {
                String id = args.get(0).toString();
                String command = args.get(1).toString();
                this.executeCommand(project, id, command);
                break;
            }
            default: {
                LogManager.warn(MainThreadTerminalShellIntegration.class, "MainThreadTerminalShellIntegration: unknown name: " + name);
            }
        }
    }

    public Terminal findTerminalByInstanceId(Project project, Integer targetInstanceId) {
        for (Terminal terminal : this.getTerminalService((Project)project).terminals.values()) {
            if (!Objects.equals(terminal.instanceId, targetInstanceId)) continue;
            return terminal;
        }
        return null;
    }

    private MainThreadTerminalService getTerminalService(Project project) {
        return (MainThreadTerminalService)NodeRunner.getInstance(project).getRpcChannel().getService(MainThreadTerminalService.class.getSimpleName());
    }

    public void executeCommand(Project project, String instanceIdString, String command) {
        Integer instanceId = Integer.valueOf(instanceIdString);
        Terminal terminal = this.findTerminalByInstanceId(project, instanceId);
        if (terminal != null) {
            terminal.run(project, command);
        } else {
            LogManager.warn(MainThreadTerminalShellIntegration.class, "MainThreadTerminalShellIntegration: terminal not found: " + instanceId);
        }
    }
}

