/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.terminal;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.util.TerminalSettingUtils;
import com.tencent.code.intel.manager.LogManager;
import com.tencent.code.intel.manager.ThreadManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.util.TextUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalView;

public class Terminal {
    public final Integer instanceId = instanceCounter.getAndIncrement();
    private static final AtomicInteger instanceCounter = new AtomicInteger(0);
    private ShellTerminalWidget shellTerminalWidget;
    private TerminalView terminalView;
    private ProcessHandler processHandler;
    private String insertText;
    private boolean fromSendText = false;
    public boolean createFromMainThread = false;

    private void onShowTerminal(Project project, ShellTerminalWidget widget) {
        if (TextUtils.isEmpty((CharSequence)this.insertText)) {
            LogManager.info(Terminal.class, "onShowTerminal insertText is null");
            return;
        }
        LogManager.info(Terminal.class, "onShowTerminal insertText=" + this.insertText);
        String cleanedText = this.insertText.replaceAll("\u001b\\[200~", "").replaceAll("\u001b\\[201~", "");
        if (this.fromSendText) {
            int delayMillis = this.createFromMainThread ? 1500 : 100;
            ThreadManager.getInstance().executeDelay(delayMillis, () -> {
                this.insertTextToTerminalWidget(widget, cleanedText);
                this.fromSendText = false;
                widget.requestFocusInWindow();
                return null;
            });
        } else {
            widget.writePlainMessage(cleanedText);
            widget.requestFocusInWindow();
        }
        if (NodeRunner.getInstance(project) != null) {
            NodeRunner.getInstance(project).getRpcChannel().sendReq("ExtHostTerminalShellIntegration", "$shellExecutionData", List.of(this.instanceId, this.insertText), null);
        }
        this.insertText = null;
    }

    private void insertTextToTerminalWidget(ShellTerminalWidget widget, String text) {
        try {
            widget.getTtyConnector().write(text);
        }
        catch (Exception e) {
            LogManager.warn(Terminal.class, "Failed to write to TTY connector: " + e.getMessage());
            widget.writePlainMessage(text);
        }
    }

    public void show(Project project) {
        if (project == null || project.isDisposed()) {
            LogManager.warn(Terminal.class, "Project is null or disposed");
            return;
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().invokeLater(() -> {
            try {
                TerminalView terminalView = TerminalView.getInstance((Project)project);
                if (terminalView == null) {
                    LogManager.warn(Terminal.class, "TerminalView is null (plugin may be disabled)");
                    return;
                }
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow("Terminal");
                if (toolWindow == null) {
                    LogManager.warn(Terminal.class, "ToolWindow 'Terminal' not found");
                    return;
                }
                toolWindow.activate(() -> {
                    if (this.shellTerminalWidget != null) {
                        LogManager.warn(Terminal.class, "Terminal " + this.instanceId + " already exists, activated");
                        return;
                    }
                    String basePath = project.getBasePath();
                    if (basePath == null) {
                        basePath = PathManager.getHomePath();
                    }
                    ShellTerminalWidget widget = null;
                    try {
                        widget = terminalView.createLocalShellWidget(basePath, "Craft Session");
                    }
                    catch (Throwable t) {
                        LogManager.warn(Terminal.class, "createLocalShellWidget failed: " + t.getMessage());
                    }
                    if (widget == null) {
                        LogManager.warn(Terminal.class, "Terminal widget is null (terminal not supported in this environment)");
                        return;
                    }
                    this.shellTerminalWidget = widget;
                    this.dispose(project);
                    this.shellTerminalWidget.getTerminalPanel().addCustomKeyListener((KeyListener)new KeyAdapter(){

                        @Override
                        public void keyPressed(KeyEvent e) {
                            if (e.isControlDown() && e.getKeyCode() == 67) {
                                Terminal.this.cancel();
                            }
                        }
                    });
                    this.shellTerminalWidget.setEnabled(true);
                    NodeRunner nodeRunner = NodeRunner.getInstance(project);
                    if (nodeRunner == null) {
                        LogManager.warn(Terminal.class, "NodeRunner is null");
                        return;
                    }
                    String cwd = basePath;
                    nodeRunner.getRpcChannel().sendReq("ExtHostTerminalShellIntegration", "$shellExecutionStart", List.of(this.instanceId, "", Integer.valueOf(2), Boolean.valueOf(true), cwd), null);
                    nodeRunner.getRpcChannel().sendReq("ExtHostTerminalShellIntegration", "$cwdChange", List.of(this.instanceId, cwd), null);
                    LogManager.info(Terminal.class, "Terminal " + this.instanceId + " is ready");
                    this.onShowTerminal(project, this.shellTerminalWidget);
                });
            }
            catch (Exception e) {
                LogManager.warn(Terminal.class, "Error initializing terminal: " + e.getMessage());
            }
        }));
    }

    public void run(final Project project, String command) {
        try {
            GeneralCommandLine cmdLine = new GeneralCommandLine();
            String shellPath = TerminalSettingUtils.getShellPath();
            cmdLine.setExePath(shellPath);
            String param = TerminalSettingUtils.getShellCommandParam(shellPath);
            cmdLine.addParameters(new String[]{param, command});
            cmdLine.setCharset(StandardCharsets.UTF_8);
            cmdLine.setWorkDirectory(project.getBasePath());
            String commandLine = cmdLine.getCommandLineString();
            LogManager.info(Terminal.class, " run command line: " + commandLine);
            Charset charset = EncodingManager.getInstance().getDefaultConsoleEncoding();
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                charset = Charset.forName("GBK");
            }
            this.processHandler = new OSProcessHandler(cmdLine.createProcess(), commandLine, charset);
            LogManager.warn(Terminal.class, "terminal " + this.instanceId + " run command " + command);
            final AtomicBoolean processTerminated = new AtomicBoolean(false);
            this.processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (processTerminated.get()) {
                        ThreadManager.getInstance().runUiThread(() -> {
                            if (Terminal.this.shellTerminalWidget != null) {
                                Terminal.this.shellTerminalWidget.getTerminalPanel().dispatchEvent((AWTEvent)new KeyEvent((Component)Terminal.this.shellTerminalWidget.getTerminalPanel(), 401, System.currentTimeMillis(), 0, 10, '\uffff'));
                            }
                        });
                        return;
                    }
                    String output = event.getText();
                    LogManager.warn(Terminal.class, "terminal " + Terminal.this.instanceId + " received text " + event.getText());
                    if (NodeRunner.getInstance(project) == null) {
                        return;
                    }
                    ThreadManager.getInstance().runUiThread(() -> {
                        Terminal.this.insertText = output;
                        if (Terminal.this.shellTerminalWidget != null) {
                            LogManager.info(Terminal.class, "terminal " + Terminal.this.instanceId + " onTextAvailable insert text " + output);
                            Terminal.this.onShowTerminal(project, Terminal.this.shellTerminalWidget);
                        }
                    });
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    processTerminated.set(true);
                    LogManager.warn(Terminal.class, Terminal.this.instanceId + " processTerminated");
                    ThreadManager.getInstance().runUiThread(() -> {
                        if (NodeRunner.getInstance(project) == null) {
                            return;
                        }
                        String output = event.getText() != null ? event.getText() : "";
                        NodeRunner.getInstance(project).getRpcChannel().sendReq("ExtHostTerminalShellIntegration", "$shellExecutionEnd", List.of(Terminal.this.instanceId, output, Integer.valueOf(2), Boolean.valueOf(true), Integer.valueOf(event.getExitCode())), null);
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/terminal/Terminal$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            ProcessTerminatedListener.attach((ProcessHandler)this.processHandler);
            Thread.sleep(2000L);
            this.processHandler.startNotify();
        }
        catch (Exception e) {
            LogManager.warn(Terminal.class, "Error running command in terminal: " + e.getMessage());
            this.handlErrorMessage(project, e.getMessage());
        }
    }

    private void handlErrorMessage(Project project, String errMsg) {
        NodeRunner nodeRunner;
        if (this.shellTerminalWidget != null) {
            this.shellTerminalWidget.writePlainMessage(errMsg);
        }
        if ((nodeRunner = NodeRunner.getInstance(project)) == null) {
            return;
        }
        nodeRunner.getRpcChannel().sendReq("ExtHostTerminalShellIntegration", "$shellExecutionData", List.of(this.instanceId, errMsg), null);
    }

    public void cancel() {
        if (this.processHandler != null && !this.processHandler.isProcessTerminated()) {
            this.processHandler.destroyProcess();
        }
        LogManager.warn(Terminal.class, "terminal " + this.instanceId + " canceled");
    }

    public void setText(Project project, String text) {
        ThreadManager.getInstance().runUiThread(() -> {
            this.insertText = text;
            this.fromSendText = true;
            if (this.shellTerminalWidget != null) {
                LogManager.info(Terminal.class, "terminal " + this.instanceId + ",  setText:  " + text);
                this.onShowTerminal(project, this.shellTerminalWidget);
            }
        });
    }

    public void dispose(Project project) {
        if (this.shellTerminalWidget != null) {
            Disposer.register((Disposable)this.shellTerminalWidget, () -> {
                this.cancel();
                this.shellTerminalWidget = null;
                if (NodeRunner.getInstance(project) == null) {
                    return;
                }
            });
        }
    }

    public void setShellTerminalWidget(ShellTerminalWidget shellTerminalWidget) {
        this.shellTerminalWidget = shellTerminalWidget;
    }
}

