/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.code.intel.apibridge.extension.mainthread.terminal;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.MainThreadTerminalService;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.Terminal;
import com.tencent.code.intel.apibridge.extension.mainthread.terminal.TerminalLaunchConfig;
import com.tencent.code.intel.apibridge.nodeprocess.NodeRunner;
import com.tencent.code.intel.apibridge.util.TerminalSettingUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalView;

public class TerminalManager {
    private final Project project;
    private final NodeRunner nodeRunner;
    private final Map<Content, Terminal> terminalMap = new ConcurrentHashMap<Content, Terminal>();

    public TerminalManager(Project project, NodeRunner nodeRunner) {
        this.project = project;
        this.nodeRunner = nodeRunner;
    }

    public void initialize() {
        ToolWindow terminalToolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow("Terminal");
        if (terminalToolWindow != null) {
            Content[] contents;
            ContentManager contentManager = terminalToolWindow.getContentManager();
            for (Content content : contents = contentManager.getContents()) {
                String terminalName = content.getDisplayName();
                Terminal terminal = this.createTerminal(content);
                this.terminalMap.put(content, terminal);
                this.nodeRunner.getRpcChannel().sendReq("ExtHostTerminalService", "$acceptTerminalOpened", List.of(terminal.instanceId, String.valueOf(terminal.hashCode()), terminalName, this.createTerminalConfig(terminalName)), null);
                this.nodeRunner.getRpcChannel().sendReq("ExtHostTerminalService", "$acceptActiveTerminalChanged", List.of(terminal.instanceId), null);
            }
            contentManager.addContentManagerListener(new ContentManagerListener(){

                public void contentAdded(@NotNull ContentManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Content content = event.getContent();
                    MainThreadTerminalService terminalService = TerminalManager.this.getTerminalService();
                    if (terminalService != null && terminalService.pendingApiTerminal != null) {
                        Terminal latestApiTerminal = terminalService.pendingApiTerminal;
                        TerminalManager.this.terminalMap.put(content, latestApiTerminal);
                        terminalService.pendingApiTerminal = null;
                        return;
                    }
                    Terminal terminal = TerminalManager.this.createTerminal(event.getContent());
                    String terminalName = content.getDisplayName();
                    TerminalManager.this.terminalMap.put(content, terminal);
                    TerminalManager.this.nodeRunner.getRpcChannel().sendReq("ExtHostTerminalService", "$acceptTerminalOpened", List.of(terminal.instanceId, String.valueOf(terminal.hashCode()), terminalName, TerminalManager.this.createTerminalConfig(terminalName)), null);
                    TerminalManager.this.nodeRunner.getRpcChannel().sendReq("ExtHostTerminalService", "$acceptActiveTerminalChanged", List.of(terminal.instanceId), null);
                }

                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    Content content;
                    Terminal terminal;
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((terminal = TerminalManager.this.terminalMap.remove(content = event.getContent())) != null) {
                        MainThreadTerminalService terminalService = TerminalManager.this.getTerminalService();
                        if (terminalService != null) {
                            terminalService.terminals.entrySet().removeIf(entry -> ((Terminal)entry.getValue()).instanceId.equals(terminal.instanceId));
                        }
                        TerminalManager.this.nodeRunner.getRpcChannel().sendReq("ExtHostTerminalService", "$acceptTerminalClosed", List.of(terminal.instanceId), null);
                        if (TerminalManager.this.terminalMap.isEmpty()) {
                            TerminalManager.this.nodeRunner.getRpcChannel().sendReq("ExtHostTerminalService", "$acceptActiveTerminalChanged", null, null);
                        }
                    }
                }

                public void selectionChanged(@NotNull ContentManagerEvent event) {
                    Content content;
                    Terminal terminal;
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((terminal = TerminalManager.this.terminalMap.get(content = event.getContent())) != null && event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                        TerminalManager.this.nodeRunner.getRpcChannel().sendReq("ExtHostTerminalService", "$acceptActiveTerminalChanged", List.of(terminal.instanceId), null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/tencent/code/intel/apibridge/extension/mainthread/terminal/TerminalManager$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contentAdded";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contentRemoved";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "selectionChanged";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private MainThreadTerminalService getTerminalService() {
        return (MainThreadTerminalService)this.nodeRunner.getRpcChannel().getService("MainThreadTerminalService");
    }

    private Terminal createTerminal(Content content) {
        JBTerminalWidget widget;
        TerminalView terminalView;
        Terminal terminal = new Terminal();
        MainThreadTerminalService terminalService = this.getTerminalService();
        if (terminalService != null) {
            terminalService.terminals.put(String.valueOf(terminal.hashCode()), terminal);
        }
        if ((terminalView = TerminalView.getInstance((Project)this.project)) != null && content != null && (widget = TerminalView.getWidgetByContent((Content)content)) instanceof ShellTerminalWidget) {
            terminal.setShellTerminalWidget((ShellTerminalWidget)widget);
        }
        return terminal;
    }

    private TerminalLaunchConfig createTerminalConfig(String name) {
        return new TerminalLaunchConfig(name, TerminalSettingUtils.getShellPath(), this.project.getBasePath() != null ? this.project.getBasePath() : PathManager.getHomePath());
    }
}

